/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.admin.Transactions;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.common.policies.data.TransactionBufferStats;
import org.apache.pulsar.common.policies.data.TransactionCoordinatorStats;
import org.apache.pulsar.common.policies.data.TransactionInBufferStats;
import org.apache.pulsar.common.policies.data.TransactionInPendingAckStats;
import org.apache.pulsar.common.policies.data.TransactionMetadata;
import org.apache.pulsar.common.policies.data.TransactionPendingAckStats;
import org.apache.pulsar.shade.javax.ws.rs.client.InvocationCallback;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;

public class TransactionsImpl
extends BaseResource
implements Transactions {
    private final WebTarget adminV3Transactions;

    public TransactionsImpl(WebTarget web, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.adminV3Transactions = web.path("/admin/v3/transactions");
    }

    public CompletableFuture<TransactionCoordinatorStats> getCoordinatorStatsById(int coordinatorId) {
        WebTarget path = this.adminV3Transactions.path("coordinatorStats");
        path = path.queryParam("coordinatorId", coordinatorId);
        final CompletableFuture<TransactionCoordinatorStats> future = new CompletableFuture<TransactionCoordinatorStats>();
        this.asyncGetRequest(path, new InvocationCallback<TransactionCoordinatorStats>(){

            @Override
            public void completed(TransactionCoordinatorStats stats) {
                future.complete(stats);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(TransactionsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public CompletableFuture<Map<Integer, TransactionCoordinatorStats>> getCoordinatorStats() {
        WebTarget path = this.adminV3Transactions.path("coordinatorStats");
        final CompletableFuture<Map<Integer, TransactionCoordinatorStats>> future = new CompletableFuture<Map<Integer, TransactionCoordinatorStats>>();
        this.asyncGetRequest(path, new InvocationCallback<Map<Integer, TransactionCoordinatorStats>>(){

            @Override
            public void completed(Map<Integer, TransactionCoordinatorStats> stats) {
                future.complete(stats);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(TransactionsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public CompletableFuture<TransactionInBufferStats> getTransactionInBufferStats(TxnID txnID, String topic) {
        WebTarget path = this.adminV3Transactions.path("transactionInBufferStats");
        path = path.queryParam("mostSigBits", txnID.getMostSigBits());
        path = path.queryParam("leastSigBits", txnID.getLeastSigBits());
        path = path.queryParam("topic", topic);
        final CompletableFuture<TransactionInBufferStats> future = new CompletableFuture<TransactionInBufferStats>();
        this.asyncGetRequest(path, new InvocationCallback<TransactionInBufferStats>(){

            @Override
            public void completed(TransactionInBufferStats stats) {
                future.complete(stats);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(TransactionsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public CompletableFuture<TransactionInPendingAckStats> getTransactionInPendingAckStats(TxnID txnID, String topic, String subName) {
        WebTarget path = this.adminV3Transactions.path("transactionInPendingAckStats");
        path = path.queryParam("mostSigBits", txnID.getMostSigBits());
        path = path.queryParam("leastSigBits", txnID.getLeastSigBits());
        path = path.queryParam("topic", topic);
        path = path.queryParam("subName", subName);
        final CompletableFuture<TransactionInPendingAckStats> future = new CompletableFuture<TransactionInPendingAckStats>();
        this.asyncGetRequest(path, new InvocationCallback<TransactionInPendingAckStats>(){

            @Override
            public void completed(TransactionInPendingAckStats stats) {
                future.complete(stats);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(TransactionsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public CompletableFuture<TransactionMetadata> getTransactionMetadata(TxnID txnID) {
        WebTarget path = this.adminV3Transactions.path("transactionMetadata");
        path = path.queryParam("mostSigBits", txnID.getMostSigBits());
        path = path.queryParam("leastSigBits", txnID.getLeastSigBits());
        final CompletableFuture<TransactionMetadata> future = new CompletableFuture<TransactionMetadata>();
        this.asyncGetRequest(path, new InvocationCallback<TransactionMetadata>(){

            @Override
            public void completed(TransactionMetadata metadata) {
                future.complete(metadata);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(TransactionsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public CompletableFuture<TransactionBufferStats> getTransactionBufferStats(String topic) {
        WebTarget path = this.adminV3Transactions.path("transactionBufferStats");
        path = path.queryParam("topic", topic);
        final CompletableFuture<TransactionBufferStats> future = new CompletableFuture<TransactionBufferStats>();
        this.asyncGetRequest(path, new InvocationCallback<TransactionBufferStats>(){

            @Override
            public void completed(TransactionBufferStats stats) {
                future.complete(stats);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(TransactionsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public CompletableFuture<TransactionPendingAckStats> getPendingAckStats(String topic, String subName) {
        WebTarget path = this.adminV3Transactions.path("pendingAckStats");
        path = path.queryParam("topic", topic);
        path = path.queryParam("subName", subName);
        final CompletableFuture<TransactionPendingAckStats> future = new CompletableFuture<TransactionPendingAckStats>();
        this.asyncGetRequest(path, new InvocationCallback<TransactionPendingAckStats>(){

            @Override
            public void completed(TransactionPendingAckStats stats) {
                future.complete(stats);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(TransactionsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }
}

