/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util.keystoretls;

import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLContextValidatorEngine {
    private static final Logger log = LoggerFactory.getLogger(SSLContextValidatorEngine.class);
    private static final ByteBuffer EMPTY_BUF = ByteBuffer.allocate(0);
    private final SSLEngine sslEngine;
    private SSLEngineResult handshakeResult;
    private ByteBuffer appBuffer;
    private ByteBuffer netBuffer;
    private boolean finished = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validate(SSLEngineProvider clientSslEngineSupplier, SSLEngineProvider serverSslEngineSupplier) throws SSLException {
        SSLContextValidatorEngine clientEngine = new SSLContextValidatorEngine(clientSslEngineSupplier);
        SSLContextValidatorEngine serverEngine = new SSLContextValidatorEngine(serverSslEngineSupplier);
        try {
            clientEngine.beginHandshake();
            serverEngine.beginHandshake();
            while (!serverEngine.complete() || !clientEngine.complete()) {
                clientEngine.handshake(serverEngine);
                serverEngine.handshake(clientEngine);
            }
        }
        finally {
            clientEngine.close();
            serverEngine.close();
        }
    }

    private SSLContextValidatorEngine(SSLEngineProvider sslEngineSupplier) {
        this.sslEngine = sslEngineSupplier.createSSLEngine("localhost", 0);
        this.appBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getApplicationBufferSize());
        this.netBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getPacketBufferSize());
    }

    void beginHandshake() throws SSLException {
        this.sslEngine.beginHandshake();
    }

    void handshake(SSLContextValidatorEngine peerEngine) throws SSLException {
        SSLEngineResult.HandshakeStatus handshakeStatus = this.sslEngine.getHandshakeStatus();
        block16: while (true) {
            switch (handshakeStatus) {
                case NEED_WRAP: {
                    this.handshakeResult = this.sslEngine.wrap(EMPTY_BUF, this.netBuffer);
                    switch (this.handshakeResult.getStatus()) {
                        case OK: {
                            break;
                        }
                        case BUFFER_OVERFLOW: {
                            this.netBuffer.compact();
                            this.netBuffer = SSLContextValidatorEngine.ensureCapacity(this.netBuffer, this.sslEngine.getSession().getPacketBufferSize());
                            this.netBuffer.flip();
                            break;
                        }
                        default: {
                            throw new SSLException("Unexpected handshake status: " + (Object)((Object)this.handshakeResult.getStatus()));
                        }
                    }
                    return;
                }
                case NEED_UNWRAP: {
                    if (peerEngine.netBuffer.position() == 0) {
                        return;
                    }
                    peerEngine.netBuffer.flip();
                    this.handshakeResult = this.sslEngine.unwrap(peerEngine.netBuffer, this.appBuffer);
                    peerEngine.netBuffer.compact();
                    handshakeStatus = this.handshakeResult.getHandshakeStatus();
                    switch (this.handshakeResult.getStatus()) {
                        case OK: {
                            continue block16;
                        }
                        case BUFFER_OVERFLOW: {
                            this.appBuffer = SSLContextValidatorEngine.ensureCapacity(this.appBuffer, this.sslEngine.getSession().getApplicationBufferSize());
                            continue block16;
                        }
                        case BUFFER_UNDERFLOW: {
                            this.netBuffer = SSLContextValidatorEngine.ensureCapacity(this.netBuffer, this.sslEngine.getSession().getPacketBufferSize());
                            continue block16;
                        }
                    }
                    throw new SSLException("Unexpected handshake status: " + (Object)((Object)this.handshakeResult.getStatus()));
                }
                case NEED_TASK: {
                    this.sslEngine.getDelegatedTask().run();
                    handshakeStatus = this.sslEngine.getHandshakeStatus();
                    continue block16;
                }
                case FINISHED: {
                    return;
                }
                case NOT_HANDSHAKING: {
                    if (this.handshakeResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) {
                        throw new SSLException("Did not finish handshake");
                    }
                    this.finished = true;
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException("Unexpected handshake status " + (Object)((Object)handshakeStatus));
    }

    boolean complete() {
        return this.finished;
    }

    void close() {
        this.sslEngine.closeOutbound();
        try {
            this.sslEngine.closeInbound();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ByteBuffer ensureCapacity(ByteBuffer existingBuffer, int newLength) {
        if (newLength > existingBuffer.capacity()) {
            ByteBuffer newBuffer = ByteBuffer.allocate(newLength);
            existingBuffer.flip();
            newBuffer.put(existingBuffer);
            return newBuffer;
        }
        return existingBuffer;
    }

    @FunctionalInterface
    public static interface SSLEngineProvider {
        public SSLEngine createSSLEngine(String var1, int var2);
    }
}

