/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import java.util.Objects;
import org.apache.pulsar.shade.com.fasterxml.jackson.annotation.JsonAlias;
import org.apache.pulsar.shade.com.google.common.base.MoreObjects;

public class BacklogQuota {
    @JsonAlias(value={"limit"})
    private long limitSize;
    private int limitTime;
    private RetentionPolicy policy;

    public long getLimitSize() {
        return this.limitSize;
    }

    public int getLimitTime() {
        return this.limitTime;
    }

    public RetentionPolicy getPolicy() {
        return this.policy;
    }

    public void setLimitSize(long limitSize) {
        this.limitSize = limitSize;
    }

    public void setPolicy(RetentionPolicy policy) {
        this.policy = policy;
    }

    protected BacklogQuota() {
    }

    public BacklogQuota(long limitSize, RetentionPolicy policy) {
        this(limitSize, -1, policy);
    }

    public BacklogQuota(long limitSize, int limitTime, RetentionPolicy policy) {
        this.limitTime = limitTime;
        this.limitSize = limitSize;
        this.policy = policy;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.limitSize, (long)this.limitTime, this.policy});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("limitSize", this.limitSize).add("limitTime", this.limitTime).add("policy", (Object)this.policy).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BacklogQuota) {
            BacklogQuota other = (BacklogQuota)obj;
            return Objects.equals(this.limitSize, other.limitSize) && Objects.equals(this.limitTime, other.limitTime) && Objects.equals((Object)this.policy, (Object)other.policy);
        }
        return false;
    }

    public static enum RetentionPolicy {
        producer_request_hold,
        producer_exception,
        consumer_backlog_eviction;

    }

    public static enum BacklogQuotaType {
        destination_storage,
        message_age;

    }
}

