/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.yahoo.memory;

import java.io.File;
import java.io.FileDescriptor;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.pulsar.shade.com.yahoo.memory.NativeMemory;
import org.apache.pulsar.shade.com.yahoo.memory.UnsafeUtil;
import sun.nio.ch.FileChannelImpl;

public class MemoryMappedFile
extends NativeMemory {
    private FileChannel fileChannel_ = null;
    private RandomAccessFile randomAccessFile_ = null;
    private MappedByteBuffer dummyMbbInstance_ = null;

    public MemoryMappedFile(File file, long position, long len) throws Exception {
        super(0L, null, null);
        if (position < 0L) {
            throw new IllegalArgumentException("Negative position");
        }
        if (len < 0L) {
            throw new IllegalArgumentException("Negative size");
        }
        if (position + len < 0L) {
            throw new IllegalArgumentException("Position + size overflow");
        }
        this.randomAccessFile_ = new RandomAccessFile(file, "rw");
        this.fileChannel_ = this.randomAccessFile_.getChannel();
        this.nativeRawStartAddress_ = this.map(position, len);
        this.capacityBytes_ = len;
        this.memReq_ = null;
        this.randomAccessFile_.setLength(len);
        this.createDummyMbbInstance();
    }

    MemoryMappedFile(long objectBaseOffset, Object memArray, ByteBuffer byteBuf) {
        super(objectBaseOffset, memArray, byteBuf);
    }

    public void load() {
        this.madvise();
        int ps = UnsafeUtil.unsafe.pageSize();
        int count = MemoryMappedFile.pageCount(ps, this.capacityBytes_);
        long a = this.nativeRawStartAddress_;
        for (int i = 0; i < count; ++i) {
            UnsafeUtil.unsafe.getByte(a);
            a += (long)ps;
        }
    }

    public boolean isLoaded() {
        try {
            int ps = UnsafeUtil.unsafe.pageSize();
            int pageCount = MemoryMappedFile.pageCount(ps, this.capacityBytes_);
            Method method = MappedByteBuffer.class.getDeclaredMethod("isLoaded0", Long.TYPE, Long.TYPE, Integer.TYPE);
            method.setAccessible(true);
            return (Boolean)method.invoke((Object)this.dummyMbbInstance_, this.nativeRawStartAddress_, this.capacityBytes_, pageCount);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Encountered %s exception while loading", e.getClass()));
        }
    }

    public void force() {
        try {
            Method method = MappedByteBuffer.class.getDeclaredMethod("force0", FileDescriptor.class, Long.TYPE, Long.TYPE);
            method.setAccessible(true);
            method.invoke((Object)this.dummyMbbInstance_, this.randomAccessFile_.getFD(), this.nativeRawStartAddress_, this.capacityBytes_);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Encountered %s exception in force", e.getClass()));
        }
    }

    @Override
    public void freeMemory() {
        if (this.fileChannel_ != null) {
            this.unmap();
            this.nativeRawStartAddress_ = 0L;
        }
        super.freeMemory();
    }

    protected void finalize() {
        if (this.requiresFree()) {
            System.err.println("ERROR: freeMemory() has not been called: Address: " + this.nativeRawStartAddress_ + ", capacity: " + this.capacityBytes_);
            StackTraceElement[] arr = Thread.currentThread().getStackTrace();
            for (int i = 0; i < arr.length; ++i) {
                System.err.println(arr[i].toString());
            }
        }
    }

    private void unmap() throws RuntimeException {
        try {
            Method method = FileChannelImpl.class.getDeclaredMethod("unmap0", Long.TYPE, Long.TYPE);
            method.setAccessible(true);
            method.invoke((Object)this.fileChannel_, this.nativeRawStartAddress_, this.capacityBytes_);
            this.randomAccessFile_.close();
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Encountered %s exception while freeing memory", e.getClass()));
        }
    }

    static final int pageCount(int ps, long length) {
        long s = 1L;
        while (s * (long)ps < length) {
            ++s;
        }
        return (int)s;
    }

    private void createDummyMbbInstance() throws RuntimeException {
        try {
            Class<?> cl = Class.forName("java.nio.DirectByteBuffer");
            Constructor<?> ctor = cl.getDeclaredConstructor(Integer.TYPE, Long.TYPE, FileDescriptor.class, Runnable.class);
            ctor.setAccessible(true);
            this.dummyMbbInstance_ = (MappedByteBuffer)ctor.newInstance(0, this.nativeRawStartAddress_, null, null);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create Dummy MappedByteBuffer instance: " + e.getClass());
        }
    }

    private void madvise() throws RuntimeException {
        try {
            Method method = MappedByteBuffer.class.getDeclaredMethod("load0", Long.TYPE, Long.TYPE);
            method.setAccessible(true);
            method.invoke((Object)this.dummyMbbInstance_, this.nativeRawStartAddress_, this.capacityBytes_);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Encountered %s exception while loading", e.getClass()));
        }
    }

    private long map(long position, long len) throws RuntimeException {
        int pagePosition = (int)(position % (long)UnsafeUtil.unsafe.pageSize());
        long mapPosition = position - (long)pagePosition;
        long mapSize = len + (long)pagePosition;
        try {
            Method method = FileChannelImpl.class.getDeclaredMethod("map0", Integer.TYPE, Long.TYPE, Long.TYPE);
            method.setAccessible(true);
            long addr = (Long)method.invoke((Object)this.fileChannel_, 1, mapPosition, mapSize);
            return addr;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Encountered %s exception while mapping", e.getClass()));
        }
    }
}

