/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.util;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorProvider {
    private static final Logger log = LoggerFactory.getLogger(ExecutorProvider.class);
    private final int numThreads;
    private final List<ExecutorService> executors;
    private final AtomicInteger currentThread = new AtomicInteger(0);

    public ExecutorProvider(int numThreads, ThreadFactory threadFactory) {
        Preconditions.checkArgument(numThreads > 0);
        this.numThreads = numThreads;
        Preconditions.checkNotNull(threadFactory);
        this.executors = Lists.newArrayListWithCapacity(numThreads);
        for (int i = 0; i < numThreads; ++i) {
            this.executors.add(Executors.newSingleThreadScheduledExecutor(threadFactory));
        }
    }

    public ExecutorService getExecutor() {
        return this.executors.get((this.currentThread.getAndIncrement() & Integer.MAX_VALUE) % this.numThreads);
    }

    public void shutdownNow() {
        this.executors.forEach(executor -> {
            executor.shutdownNow();
            try {
                executor.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.warn("Shutdown of thread pool was interrupted");
            }
        });
    }
}

