/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema.generic;

import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.api.schema.Field;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.api.schema.SchemaReader;
import org.apache.pulsar.client.impl.schema.generic.GenericProtobufNativeRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericProtobufNativeReader
implements SchemaReader<GenericRecord> {
    private Descriptors.Descriptor descriptor;
    private byte[] schemaVersion;
    private List<Field> fields;
    private static final Logger log = LoggerFactory.getLogger(GenericProtobufNativeReader.class);

    public GenericProtobufNativeReader(Descriptors.Descriptor descriptor) {
        this(descriptor, null);
    }

    public GenericProtobufNativeReader(Descriptors.Descriptor descriptor, byte[] schemaVersion) {
        try {
            this.schemaVersion = schemaVersion;
            this.descriptor = descriptor;
            this.fields = descriptor.getFields().stream().map(f -> new Field(f.getName(), f.getIndex())).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("GenericProtobufNativeReader init error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public GenericProtobufNativeRecord read(byte[] bytes, int offset, int length) {
        try {
            if (bytes.length != length || offset != 0) {
                bytes = Arrays.copyOfRange(bytes, offset, offset + length);
            }
            return new GenericProtobufNativeRecord(this.schemaVersion, this.descriptor, this.fields, DynamicMessage.parseFrom(this.descriptor, bytes));
        }
        catch (InvalidProtocolBufferException e) {
            throw new SchemaSerializationException((Throwable)e);
        }
    }

    public GenericProtobufNativeRecord read(InputStream inputStream) {
        try {
            return new GenericProtobufNativeRecord(this.schemaVersion, this.descriptor, this.fields, DynamicMessage.parseFrom(this.descriptor, inputStream));
        }
        catch (IOException e) {
            throw new SchemaSerializationException((Throwable)e);
        }
    }
}

