/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.impl.schema.AbstractSchema;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;

public class DoubleSchema
extends AbstractSchema<Double> {
    private static final DoubleSchema INSTANCE;
    private static final SchemaInfo SCHEMA_INFO;

    public static DoubleSchema of() {
        return INSTANCE;
    }

    public void validate(byte[] message) {
        if (message.length != 8) {
            throw new SchemaSerializationException("Size of data received by DoubleSchema is not 8");
        }
    }

    @Override
    public void validate(ByteBuf message) {
        if (message.readableBytes() != 8) {
            throw new SchemaSerializationException("Size of data received by DoubleSchema is not 8");
        }
    }

    public byte[] encode(Double message) {
        if (null == message) {
            return null;
        }
        long bits = Double.doubleToLongBits(message);
        return new byte[]{(byte)(bits >>> 56), (byte)(bits >>> 48), (byte)(bits >>> 40), (byte)(bits >>> 32), (byte)(bits >>> 24), (byte)(bits >>> 16), (byte)(bits >>> 8), (byte)bits};
    }

    public Double decode(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        this.validate(bytes);
        long value = 0L;
        for (byte b : bytes) {
            value <<= 8;
            value |= (long)(b & 0xFF);
        }
        return Double.longBitsToDouble(value);
    }

    @Override
    public Double decode(ByteBuf byteBuf) {
        if (null == byteBuf) {
            return null;
        }
        this.validate(byteBuf);
        long value = 0L;
        for (int i = 0; i < 8; ++i) {
            value <<= 8;
            value |= (long)(byteBuf.getByte(i) & 0xFF);
        }
        return Double.longBitsToDouble(value);
    }

    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }

    static {
        SCHEMA_INFO = new SchemaInfo().setName("Double").setType(SchemaType.DOUBLE).setSchema(new byte[0]);
        INSTANCE = new DoubleSchema();
    }
}

