/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.TopicMessageIdImpl;

public class ResetCursorData {
    protected long ledgerId;
    protected long entryId;
    protected int partitionIndex = -1;
    protected boolean isExcluded = false;
    protected int batchIndex = -1;

    public ResetCursorData(long ledgerId, long entryId) {
        this.ledgerId = ledgerId;
        this.entryId = entryId;
    }

    public ResetCursorData(long ledgerId, long entryId, boolean isExcluded) {
        this.ledgerId = ledgerId;
        this.entryId = entryId;
        this.isExcluded = isExcluded;
    }

    public ResetCursorData(MessageId messageId) {
        if (messageId instanceof BatchMessageIdImpl) {
            BatchMessageIdImpl batchMessageId = (BatchMessageIdImpl)messageId;
            this.ledgerId = batchMessageId.getLedgerId();
            this.entryId = batchMessageId.getEntryId();
            this.batchIndex = batchMessageId.getBatchIndex();
        } else if (messageId instanceof MessageIdImpl) {
            MessageIdImpl messageIdImpl = (MessageIdImpl)messageId;
            this.ledgerId = messageIdImpl.getLedgerId();
            this.entryId = messageIdImpl.getEntryId();
        } else if (messageId instanceof TopicMessageIdImpl) {
            throw new IllegalArgumentException("Not supported operation on partitioned-topic");
        }
    }

    public long getLedgerId() {
        return this.ledgerId;
    }

    public long getEntryId() {
        return this.entryId;
    }

    public int getPartitionIndex() {
        return this.partitionIndex;
    }

    public boolean isExcluded() {
        return this.isExcluded;
    }

    public int getBatchIndex() {
        return this.batchIndex;
    }

    public void setLedgerId(long ledgerId) {
        this.ledgerId = ledgerId;
    }

    public void setEntryId(long entryId) {
        this.entryId = entryId;
    }

    public void setPartitionIndex(int partitionIndex) {
        this.partitionIndex = partitionIndex;
    }

    public void setExcluded(boolean isExcluded) {
        this.isExcluded = isExcluded;
    }

    public void setBatchIndex(int batchIndex) {
        this.batchIndex = batchIndex;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResetCursorData)) {
            return false;
        }
        ResetCursorData other = (ResetCursorData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLedgerId() != other.getLedgerId()) {
            return false;
        }
        if (this.getEntryId() != other.getEntryId()) {
            return false;
        }
        if (this.getPartitionIndex() != other.getPartitionIndex()) {
            return false;
        }
        if (this.isExcluded() != other.isExcluded()) {
            return false;
        }
        return this.getBatchIndex() == other.getBatchIndex();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResetCursorData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $ledgerId = this.getLedgerId();
        result = result * 59 + (int)($ledgerId >>> 32 ^ $ledgerId);
        long $entryId = this.getEntryId();
        result = result * 59 + (int)($entryId >>> 32 ^ $entryId);
        result = result * 59 + this.getPartitionIndex();
        result = result * 59 + (this.isExcluded() ? 79 : 97);
        result = result * 59 + this.getBatchIndex();
        return result;
    }

    public String toString() {
        return "ResetCursorData(ledgerId=" + this.getLedgerId() + ", entryId=" + this.getEntryId() + ", partitionIndex=" + this.getPartitionIndex() + ", isExcluded=" + this.isExcluded() + ", batchIndex=" + this.getBatchIndex() + ")";
    }

    public ResetCursorData() {
    }
}

