/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.BatchMessageAcker;
import org.apache.pulsar.client.impl.BatchMessageAckerDisabled;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.TopicMessageIdImpl;
import org.apache.pulsar.shade.com.google.common.collect.ComparisonChain;

public class BatchMessageIdImpl
extends MessageIdImpl {
    private static final int NO_BATCH = -1;
    private final int batchIndex;
    private final int batchSize;
    private final transient BatchMessageAcker acker;

    private BatchMessageIdImpl() {
        this(-1L, -1L, -1, -1);
    }

    public BatchMessageIdImpl(long ledgerId, long entryId, int partitionIndex, int batchIndex) {
        this(ledgerId, entryId, partitionIndex, batchIndex, 0, BatchMessageAckerDisabled.INSTANCE);
    }

    public BatchMessageIdImpl(long ledgerId, long entryId, int partitionIndex, int batchIndex, int batchSize, BatchMessageAcker acker) {
        super(ledgerId, entryId, partitionIndex);
        this.batchIndex = batchIndex;
        this.batchSize = batchSize;
        this.acker = acker;
    }

    public BatchMessageIdImpl(MessageIdImpl other) {
        super(other.ledgerId, other.entryId, other.partitionIndex);
        if (other instanceof BatchMessageIdImpl) {
            BatchMessageIdImpl otherId = (BatchMessageIdImpl)other;
            this.batchIndex = otherId.batchIndex;
            this.batchSize = otherId.batchSize;
            this.acker = otherId.acker;
        } else {
            this.batchIndex = -1;
            this.batchSize = 0;
            this.acker = BatchMessageAckerDisabled.INSTANCE;
        }
    }

    public int getBatchIndex() {
        return this.batchIndex;
    }

    @Override
    public int compareTo(MessageId o) {
        if (o instanceof BatchMessageIdImpl) {
            BatchMessageIdImpl other = (BatchMessageIdImpl)o;
            return ComparisonChain.start().compare(this.ledgerId, other.ledgerId).compare(this.entryId, other.entryId).compare(this.batchIndex, other.batchIndex).compare(this.getPartitionIndex(), other.getPartitionIndex()).result();
        }
        if (o instanceof MessageIdImpl) {
            int res = super.compareTo(o);
            if (res == 0 && this.batchIndex > -1) {
                return 1;
            }
            return res;
        }
        if (o instanceof TopicMessageIdImpl) {
            return this.compareTo(((TopicMessageIdImpl)o).getInnerMessageId());
        }
        throw new IllegalArgumentException("expected BatchMessageIdImpl object. Got instance of " + o.getClass().getName());
    }

    @Override
    public int hashCode() {
        return (int)(31L * (this.ledgerId + 31L * this.entryId) + (long)(31 * this.partitionIndex) + (long)this.batchIndex);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BatchMessageIdImpl) {
            BatchMessageIdImpl other = (BatchMessageIdImpl)obj;
            return this.ledgerId == other.ledgerId && this.entryId == other.entryId && this.partitionIndex == other.partitionIndex && this.batchIndex == other.batchIndex;
        }
        if (obj instanceof MessageIdImpl) {
            MessageIdImpl other = (MessageIdImpl)obj;
            return this.ledgerId == other.ledgerId && this.entryId == other.entryId && this.partitionIndex == other.partitionIndex && this.batchIndex == -1;
        }
        return false;
    }

    @Override
    public String toString() {
        return "" + this.ledgerId + ':' + this.entryId + ':' + this.partitionIndex + ':' + this.batchIndex;
    }

    @Override
    public byte[] toByteArray() {
        return this.toByteArray(this.batchIndex);
    }

    public boolean ackIndividual() {
        return this.acker.ackIndividual(this.batchIndex);
    }

    public boolean ackCumulative() {
        return this.acker.ackCumulative(this.batchIndex);
    }

    public int getOutstandingAcksInSameBatch() {
        return this.acker.getOutstandingAcks();
    }

    public int getBatchSize() {
        return this.acker.getBatchSize();
    }

    public MessageIdImpl prevBatchMessageId() {
        return new MessageIdImpl(this.ledgerId, this.entryId - 1L, this.partitionIndex);
    }

    public BatchMessageAcker getAcker() {
        return this.acker;
    }
}

