/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.admin.Brokers;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.conf.InternalConfigurationData;
import org.apache.pulsar.common.naming.TopicVersion;
import org.apache.pulsar.common.policies.data.BrokerInfo;
import org.apache.pulsar.common.policies.data.NamespaceOwnershipStatus;
import org.apache.pulsar.common.util.Codec;
import org.apache.pulsar.shade.javax.ws.rs.client.Entity;
import org.apache.pulsar.shade.javax.ws.rs.client.InvocationCallback;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;

public class BrokersImpl
extends BaseResource
implements Brokers {
    private final WebTarget adminBrokers;

    public BrokersImpl(WebTarget web, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.adminBrokers = web.path("admin/v2/brokers");
    }

    @Override
    public List<String> getActiveBrokers() throws PulsarAdminException {
        return (List)this.sync(() -> this.getActiveBrokersAsync(null));
    }

    @Override
    public CompletableFuture<List<String>> getActiveBrokersAsync() {
        return this.getActiveBrokersAsync(null);
    }

    @Override
    public List<String> getActiveBrokers(String cluster) throws PulsarAdminException {
        return (List)this.sync(() -> this.getActiveBrokersAsync(cluster));
    }

    @Override
    public CompletableFuture<List<String>> getActiveBrokersAsync(String cluster) {
        WebTarget path = cluster == null ? this.adminBrokers : this.adminBrokers.path(cluster);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<List<String>>(){});
    }

    @Override
    public BrokerInfo getLeaderBroker() throws PulsarAdminException {
        return (BrokerInfo)this.sync(() -> this.getLeaderBrokerAsync());
    }

    @Override
    public CompletableFuture<BrokerInfo> getLeaderBrokerAsync() {
        WebTarget path = this.adminBrokers.path("leaderBroker");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<BrokerInfo>(){});
    }

    @Override
    public Map<String, NamespaceOwnershipStatus> getOwnedNamespaces(String cluster, String brokerUrl) throws PulsarAdminException {
        return (Map)this.sync(() -> this.getOwnedNamespacesAsync(cluster, brokerUrl));
    }

    @Override
    public CompletableFuture<Map<String, NamespaceOwnershipStatus>> getOwnedNamespacesAsync(String cluster, String brokerUrl) {
        WebTarget path = this.adminBrokers.path(cluster).path(brokerUrl).path("ownedNamespaces");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<Map<String, NamespaceOwnershipStatus>>(){});
    }

    @Override
    public void updateDynamicConfiguration(String configName, String configValue) throws PulsarAdminException {
        this.sync(() -> this.updateDynamicConfigurationAsync(configName, configValue));
    }

    @Override
    public CompletableFuture<Void> updateDynamicConfigurationAsync(String configName, String configValue) {
        String value = Codec.encode(configValue);
        WebTarget path = this.adminBrokers.path("configuration").path(configName).path(value);
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public void deleteDynamicConfiguration(String configName) throws PulsarAdminException {
        this.sync(() -> this.deleteDynamicConfigurationAsync(configName));
    }

    @Override
    public CompletableFuture<Void> deleteDynamicConfigurationAsync(String configName) {
        WebTarget path = this.adminBrokers.path("configuration").path(configName);
        return this.asyncDeleteRequest(path);
    }

    @Override
    public Map<String, String> getAllDynamicConfigurations() throws PulsarAdminException {
        return (Map)this.sync(this::getAllDynamicConfigurationsAsync);
    }

    @Override
    public CompletableFuture<Map<String, String>> getAllDynamicConfigurationsAsync() {
        WebTarget path = this.adminBrokers.path("configuration").path("values");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<Map<String, String>>(){});
    }

    @Override
    public List<String> getDynamicConfigurationNames() throws PulsarAdminException {
        return (List)this.sync(this::getDynamicConfigurationNamesAsync);
    }

    @Override
    public CompletableFuture<List<String>> getDynamicConfigurationNamesAsync() {
        WebTarget path = this.adminBrokers.path("configuration");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<List<String>>(){});
    }

    @Override
    public Map<String, String> getRuntimeConfigurations() throws PulsarAdminException {
        return (Map)this.sync(this::getRuntimeConfigurationsAsync);
    }

    @Override
    public CompletableFuture<Map<String, String>> getRuntimeConfigurationsAsync() {
        WebTarget path = this.adminBrokers.path("configuration").path("runtime");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<Map<String, String>>(){});
    }

    @Override
    public InternalConfigurationData getInternalConfigurationData() throws PulsarAdminException {
        return (InternalConfigurationData)this.sync(this::getInternalConfigurationDataAsync);
    }

    @Override
    public CompletableFuture<InternalConfigurationData> getInternalConfigurationDataAsync() {
        WebTarget path = this.adminBrokers.path("internal-configuration");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<InternalConfigurationData>(){});
    }

    @Override
    public void backlogQuotaCheck() throws PulsarAdminException {
        this.sync(this::backlogQuotaCheckAsync);
    }

    @Override
    public CompletableFuture<Void> backlogQuotaCheckAsync() {
        WebTarget path = this.adminBrokers.path("backlogQuotaCheck");
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.asyncGetRequest(path, new InvocationCallback<Void>(){

            @Override
            public void completed(Void unused) {
                future.complete(null);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        });
        return future;
    }

    @Override
    @Deprecated
    public void healthcheck() throws PulsarAdminException {
        this.healthcheck(TopicVersion.V1);
    }

    @Override
    @Deprecated
    public CompletableFuture<Void> healthcheckAsync() {
        return this.healthcheckAsync(TopicVersion.V1);
    }

    @Override
    public void healthcheck(TopicVersion topicVersion) throws PulsarAdminException {
        this.sync(() -> this.healthcheckAsync(topicVersion));
    }

    @Override
    public CompletableFuture<Void> healthcheckAsync(TopicVersion topicVersion) {
        WebTarget path = this.adminBrokers.path("health");
        if (topicVersion != null) {
            path = path.queryParam("topicVersion", new Object[]{topicVersion});
        }
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.asyncGetRequest(path, new InvocationCallback<String>(){

            @Override
            public void completed(String result) {
                if (!"ok".equalsIgnoreCase(result.trim())) {
                    future.completeExceptionally(new PulsarAdminException("Healthcheck returned unexpected result: " + result));
                } else {
                    future.complete(null);
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> shutDownBrokerGracefully(int maxConcurrentUnloadPerSec, boolean forcedTerminateTopic) {
        WebTarget path = this.adminBrokers.path("shutdown").queryParam("maxConcurrentUnloadPerSec", maxConcurrentUnloadPerSec).queryParam("forcedTerminateTopic", forcedTerminateTopic);
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public String getVersion() throws PulsarAdminException {
        return (String)this.sync(this::getVersionAsync);
    }

    public CompletableFuture<String> getVersionAsync() {
        WebTarget path = this.adminBrokers.path("version");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<String>(){});
    }
}

