/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.admin.BrokerStats;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.stats.AllocatorStats;
import org.apache.pulsar.shade.com.google.gson.Gson;
import org.apache.pulsar.shade.com.google.gson.JsonObject;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;
import org.apache.pulsar.shade.org.apache.pulsar.policies.data.loadbalancer.LoadManagerReport;

public class BrokerStatsImpl
extends BaseResource
implements BrokerStats {
    private final WebTarget adminBrokerStats;
    private final WebTarget adminV2BrokerStats;

    public BrokerStatsImpl(WebTarget target, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.adminBrokerStats = target.path("/admin/broker-stats");
        this.adminV2BrokerStats = target.path("/admin/v2/broker-stats");
    }

    @Override
    public String getMetrics() throws PulsarAdminException {
        return (String)this.sync(this::getMetricsAsync);
    }

    @Override
    public CompletableFuture<String> getMetricsAsync() {
        WebTarget path = this.adminV2BrokerStats.path("/metrics");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<String>(){});
    }

    @Override
    public AllocatorStats getAllocatorStats(String allocatorName) throws PulsarAdminException {
        return (AllocatorStats)this.sync(() -> this.getAllocatorStatsAsync(allocatorName));
    }

    @Override
    public CompletableFuture<AllocatorStats> getAllocatorStatsAsync(String allocatorName) {
        WebTarget path = this.adminV2BrokerStats.path("/allocator-stats").path(allocatorName);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<AllocatorStats>(){});
    }

    @Override
    public String getMBeans() throws PulsarAdminException {
        return (String)this.sync(this::getMBeansAsync);
    }

    @Override
    public CompletableFuture<String> getMBeansAsync() {
        WebTarget path = this.adminV2BrokerStats.path("/mbeans");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<String>(){});
    }

    @Override
    public String getTopics() throws PulsarAdminException {
        return (String)this.sync(this::getTopicsAsync);
    }

    @Override
    public CompletableFuture<String> getTopicsAsync() {
        WebTarget path = this.adminV2BrokerStats.path("/topics");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<String>(){});
    }

    @Override
    public LoadManagerReport getLoadReport() throws PulsarAdminException {
        return (LoadManagerReport)this.sync(this::getLoadReportAsync);
    }

    @Override
    public CompletableFuture<LoadManagerReport> getLoadReportAsync() {
        WebTarget path = this.adminV2BrokerStats.path("/load-report");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<LoadManagerReport>(){});
    }

    @Override
    public String getPendingBookieOpsStats() throws PulsarAdminException {
        return (String)this.sync(this::getPendingBookieOpsStatsAsync);
    }

    @Override
    public CompletableFuture<String> getPendingBookieOpsStatsAsync() {
        WebTarget path = this.adminV2BrokerStats.path("/bookieops");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<String>(){});
    }

    public JsonObject getBrokerResourceAvailability(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget admin = ns.isV2() ? this.adminV2BrokerStats : this.adminBrokerStats;
            String json = this.request(admin.path("/broker-resource-availability").path(ns.toString())).get(String.class);
            return new Gson().fromJson(json, JsonObject.class);
        }
        catch (Exception e) {
            throw BrokerStatsImpl.getApiException(e);
        }
    }
}

