/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util.collections;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pulsar.common.util.collections.ConcurrentBitSet;
import org.apache.pulsar.common.util.collections.LongPairRangeSet;
import org.apache.pulsar.shade.com.google.common.collect.BoundType;
import org.apache.pulsar.shade.com.google.common.collect.Range;
import org.apache.pulsar.shade.org.apache.commons.lang.mutable.MutableInt;

public class ConcurrentOpenLongPairRangeSet<T extends Comparable<T>>
implements LongPairRangeSet<T> {
    protected final NavigableMap<Long, BitSet> rangeBitSetMap = new ConcurrentSkipListMap<Long, BitSet>();
    private boolean threadSafe = true;
    private final int bitSetSize;
    private final LongPairRangeSet.LongPairConsumer<T> consumer;
    private volatile int cachedSize = 0;
    private volatile String cachedToString = "[]";
    private volatile boolean updatedAfterCachedForSize = true;
    private volatile boolean updatedAfterCachedForToString = true;

    public ConcurrentOpenLongPairRangeSet(LongPairRangeSet.LongPairConsumer<T> consumer) {
        this(1024, true, consumer);
    }

    public ConcurrentOpenLongPairRangeSet(int size, LongPairRangeSet.LongPairConsumer<T> consumer) {
        this(size, true, consumer);
    }

    public ConcurrentOpenLongPairRangeSet(int size, boolean threadSafe, LongPairRangeSet.LongPairConsumer<T> consumer) {
        this.threadSafe = threadSafe;
        this.bitSetSize = size;
        this.consumer = consumer;
    }

    @Override
    public void addOpenClosed(long lowerKey, long lowerValueOpen, long upperKey, long upperValue) {
        long lowerValue = lowerValueOpen + 1L;
        if (lowerKey != upperKey) {
            BitSet rangeBitSet;
            if (this.isValid(lowerKey, lowerValue) && (rangeBitSet = (BitSet)this.rangeBitSetMap.get(lowerKey)) != null && (long)rangeBitSet.previousSetBit(rangeBitSet.size()) > lowerValueOpen) {
                int lastValue = rangeBitSet.previousSetBit(rangeBitSet.size());
                rangeBitSet.set((int)lowerValue, (int)Math.max((long)lastValue, lowerValue) + 1);
            }
            if (this.isValid(upperKey, upperValue) && (rangeBitSet = this.rangeBitSetMap.computeIfAbsent(upperKey, key -> this.createNewBitSet())) != null) {
                rangeBitSet.set(0, (int)upperValue + 1);
            }
        } else {
            long key2 = lowerKey;
            BitSet rangeBitSet = this.rangeBitSetMap.computeIfAbsent(key2, k -> this.createNewBitSet());
            rangeBitSet.set((int)lowerValue, (int)upperValue + 1);
        }
        this.updatedAfterCachedForSize = true;
        this.updatedAfterCachedForToString = true;
    }

    private boolean isValid(long key, long value) {
        return key != LongPairRangeSet.LongPair.earliest.getKey() && value != LongPairRangeSet.LongPair.earliest.getValue() && key != LongPairRangeSet.LongPair.latest.getKey() && value != LongPairRangeSet.LongPair.latest.getValue();
    }

    @Override
    public boolean contains(long key, long value) {
        BitSet rangeBitSet = (BitSet)this.rangeBitSetMap.get(key);
        if (rangeBitSet != null) {
            return rangeBitSet.get(this.getSafeEntry(value));
        }
        return false;
    }

    @Override
    public Range<T> rangeContaining(long key, long value) {
        BitSet rangeBitSet = (BitSet)this.rangeBitSetMap.get(key);
        if (rangeBitSet != null) {
            if (!rangeBitSet.get(this.getSafeEntry(value))) {
                return null;
            }
            int lowerValue = rangeBitSet.previousClearBit(this.getSafeEntry(value)) + 1;
            Comparable lower = (Comparable)this.consumer.apply(key, lowerValue);
            Comparable upper = (Comparable)this.consumer.apply(key, Math.max(rangeBitSet.nextClearBit(this.getSafeEntry(value)) - 1, lowerValue));
            return Range.closed(lower, upper);
        }
        return null;
    }

    @Override
    public void removeAtMost(long key, long value) {
        this.remove(Range.atMost(new LongPairRangeSet.LongPair(key, value)));
    }

    @Override
    public boolean isEmpty() {
        if (this.rangeBitSetMap.isEmpty()) {
            return true;
        }
        for (BitSet rangeBitSet : this.rangeBitSetMap.values()) {
            if (rangeBitSet.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        this.rangeBitSetMap.clear();
        this.updatedAfterCachedForSize = true;
        this.updatedAfterCachedForToString = true;
    }

    @Override
    public Range<T> span() {
        if (this.rangeBitSetMap.isEmpty()) {
            return null;
        }
        Map.Entry<Long, BitSet> firstSet = this.rangeBitSetMap.firstEntry();
        Map.Entry<Long, BitSet> lastSet = this.rangeBitSetMap.lastEntry();
        int first = firstSet.getValue().nextSetBit(0);
        int last = lastSet.getValue().previousSetBit(lastSet.getValue().size());
        return Range.openClosed((Comparable)this.consumer.apply(firstSet.getKey(), first - 1), (Comparable)this.consumer.apply(lastSet.getKey(), last));
    }

    @Override
    public List<Range<T>> asRanges() {
        ArrayList ranges = new ArrayList();
        this.forEach(range -> {
            ranges.add(range);
            return true;
        });
        return ranges;
    }

    @Override
    public void forEach(LongPairRangeSet.RangeProcessor<T> action) {
        this.forEach(action, this.consumer);
    }

    @Override
    public void forEach(LongPairRangeSet.RangeProcessor<T> action, LongPairRangeSet.LongPairConsumer<? extends T> consumer) {
        AtomicBoolean completed = new AtomicBoolean(false);
        this.rangeBitSetMap.forEach((? super K key, ? super V set) -> {
            if (completed.get()) {
                return;
            }
            if (set.isEmpty()) {
                return;
            }
            int first = set.nextSetBit(0);
            int last = set.previousSetBit(set.size());
            int currentClosedMark = first;
            while (currentClosedMark != -1 && currentClosedMark <= last) {
                int nextOpenMark = set.nextClearBit(currentClosedMark);
                Range<Comparable> range = Range.openClosed((Comparable)consumer.apply((long)key, currentClosedMark - 1), (Comparable)consumer.apply((long)key, nextOpenMark - 1));
                if (!action.process(range)) {
                    completed.set(true);
                    break;
                }
                currentClosedMark = set.nextSetBit(nextOpenMark);
            }
        });
    }

    @Override
    public Range<T> firstRange() {
        if (this.rangeBitSetMap.isEmpty()) {
            return null;
        }
        Map.Entry<Long, BitSet> firstSet = this.rangeBitSetMap.firstEntry();
        int lower = firstSet.getValue().nextSetBit(0);
        int upper = Math.max(lower, firstSet.getValue().nextClearBit(lower) - 1);
        return Range.openClosed((Comparable)this.consumer.apply(firstSet.getKey(), lower - 1), (Comparable)this.consumer.apply(firstSet.getKey(), upper));
    }

    @Override
    public Range<T> lastRange() {
        if (this.rangeBitSetMap.isEmpty()) {
            return null;
        }
        Map.Entry<Long, BitSet> lastSet = this.rangeBitSetMap.lastEntry();
        int upper = lastSet.getValue().previousSetBit(lastSet.getValue().size());
        int lower = Math.min(lastSet.getValue().previousClearBit(upper), upper);
        return Range.openClosed((Comparable)this.consumer.apply(lastSet.getKey(), lower), (Comparable)this.consumer.apply(lastSet.getKey(), upper));
    }

    @Override
    public int size() {
        if (this.updatedAfterCachedForSize) {
            MutableInt size = new MutableInt(0);
            this.forEach(range -> {
                size.increment();
                return true;
            });
            this.cachedSize = size.intValue();
            this.updatedAfterCachedForSize = false;
        }
        return this.cachedSize;
    }

    public String toString() {
        if (this.updatedAfterCachedForToString) {
            StringBuilder toString = new StringBuilder();
            AtomicBoolean first = new AtomicBoolean(true);
            if (toString != null) {
                toString.append("[");
            }
            this.forEach(range -> {
                if (!first.get()) {
                    toString.append(",");
                }
                toString.append(range);
                first.set(false);
                return true;
            });
            toString.append("]");
            this.cachedToString = toString.toString();
            this.updatedAfterCachedForToString = false;
        }
        return this.cachedToString;
    }

    public void add(Range<LongPairRangeSet.LongPair> range) {
        LongPairRangeSet.LongPair lowerEndpoint = range.hasLowerBound() ? range.lowerEndpoint() : LongPairRangeSet.LongPair.earliest;
        LongPairRangeSet.LongPair upperEndpoint = range.hasUpperBound() ? range.upperEndpoint() : LongPairRangeSet.LongPair.latest;
        long lowerValueOpen = range.hasLowerBound() && range.lowerBoundType().equals((Object)BoundType.CLOSED) ? (long)(this.getSafeEntry(lowerEndpoint) - 1) : (long)this.getSafeEntry(lowerEndpoint);
        long upperValueClosed = range.hasUpperBound() && range.upperBoundType().equals((Object)BoundType.CLOSED) ? (long)this.getSafeEntry(upperEndpoint) : (long)(this.getSafeEntry(upperEndpoint) + 1);
        this.rangeBitSetMap.computeIfAbsent(lowerEndpoint.getKey(), key -> this.createNewBitSet()).set((int)lowerValueOpen + 1);
        this.addOpenClosed(lowerEndpoint.getKey(), lowerValueOpen, upperEndpoint.getKey(), upperValueClosed);
    }

    public boolean contains(LongPairRangeSet.LongPair position) {
        Objects.requireNonNull(position, "argument can't be null");
        return this.contains(position.getKey(), position.getValue());
    }

    public void remove(Range<LongPairRangeSet.LongPair> range) {
        long upper;
        LongPairRangeSet.LongPair lowerEndpoint = range.hasLowerBound() ? range.lowerEndpoint() : LongPairRangeSet.LongPair.earliest;
        LongPairRangeSet.LongPair upperEndpoint = range.hasUpperBound() ? range.upperEndpoint() : LongPairRangeSet.LongPair.latest;
        long lower = range.hasLowerBound() && range.lowerBoundType().equals((Object)BoundType.CLOSED) ? (long)this.getSafeEntry(lowerEndpoint) : (long)(this.getSafeEntry(lowerEndpoint) + 1);
        long l = upper = range.hasUpperBound() && range.upperBoundType().equals((Object)BoundType.CLOSED) ? (long)this.getSafeEntry(upperEndpoint) : (long)(this.getSafeEntry(upperEndpoint) - 1);
        if (lowerEndpoint.equals(LongPairRangeSet.LongPair.earliest)) {
            this.rangeBitSetMap.forEach((? super K key, ? super V set) -> {
                if (key < upperEndpoint.getKey()) {
                    this.rangeBitSetMap.remove(key);
                }
            });
        }
        if (upperEndpoint.equals(LongPairRangeSet.LongPair.latest)) {
            this.rangeBitSetMap.forEach((? super K key, ? super V set) -> {
                if (key > lowerEndpoint.getKey()) {
                    this.rangeBitSetMap.remove(key);
                }
            });
        }
        this.rangeBitSetMap.forEach((? super K key, ? super V set) -> {
            if (lowerEndpoint.getKey() == upperEndpoint.getKey() && key.longValue() == upperEndpoint.getKey()) {
                set.clear((int)lower, (int)upper + 1);
            } else if (key.longValue() == lowerEndpoint.getKey()) {
                set.clear((int)lower, set.previousSetBit(set.size()));
            } else if (key.longValue() == upperEndpoint.getKey()) {
                set.clear(0, (int)upper + 1);
            } else if (key > lowerEndpoint.getKey() && key < upperEndpoint.getKey()) {
                this.rangeBitSetMap.remove(key);
            }
            if (set.isEmpty()) {
                this.rangeBitSetMap.remove(key);
            }
        });
        this.updatedAfterCachedForSize = true;
        this.updatedAfterCachedForToString = true;
    }

    private int getSafeEntry(LongPairRangeSet.LongPair position) {
        return (int)Math.max(position.getValue(), -1L);
    }

    private int getSafeEntry(long value) {
        return (int)Math.max(value, -1L);
    }

    private BitSet createNewBitSet() {
        return this.threadSafe ? new ConcurrentBitSet(this.bitSetSize) : new BitSet(this.bitSetSize);
    }
}

