/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import org.apache.pulsar.common.util.FileModifiedTimeUpdater;
import org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.common.util.SslContextAutoRefreshBuilder;

public class DefaultSslContextBuilder
extends SslContextAutoRefreshBuilder<SSLContext> {
    private volatile SSLContext sslContext;
    protected final boolean tlsAllowInsecureConnection;
    protected final FileModifiedTimeUpdater tlsTrustCertsFilePath;
    protected final FileModifiedTimeUpdater tlsCertificateFilePath;
    protected final FileModifiedTimeUpdater tlsKeyFilePath;
    protected final boolean tlsRequireTrustedClientCertOnConnect;

    public DefaultSslContextBuilder(boolean allowInsecure, String trustCertsFilePath, String certificateFilePath, String keyFilePath, boolean requireTrustedClientCertOnConnect, long certRefreshInSec) throws SSLException, FileNotFoundException, GeneralSecurityException, IOException {
        super(certRefreshInSec);
        this.tlsAllowInsecureConnection = allowInsecure;
        this.tlsTrustCertsFilePath = new FileModifiedTimeUpdater(trustCertsFilePath);
        this.tlsCertificateFilePath = new FileModifiedTimeUpdater(certificateFilePath);
        this.tlsKeyFilePath = new FileModifiedTimeUpdater(keyFilePath);
        this.tlsRequireTrustedClientCertOnConnect = requireTrustedClientCertOnConnect;
    }

    @Override
    public synchronized SSLContext update() throws GeneralSecurityException {
        this.sslContext = SecurityUtility.createSslContext(this.tlsAllowInsecureConnection, this.tlsTrustCertsFilePath.getFileName(), this.tlsCertificateFilePath.getFileName(), this.tlsKeyFilePath.getFileName());
        return this.sslContext;
    }

    @Override
    public SSLContext getSslContext() {
        return this.sslContext;
    }

    @Override
    public boolean needUpdate() {
        return this.tlsTrustCertsFilePath.checkAndRefresh() || this.tlsCertificateFilePath.checkAndRefresh() || this.tlsKeyFilePath.checkAndRefresh();
    }
}

