/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.pulsar.PulsarVersion;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.ControlledClusterFailoverBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.ServiceUrlProvider;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.common.util.Runnables;
import org.apache.pulsar.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.com.google.common.base.Strings;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpRequest;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpResponse;
import org.apache.pulsar.shade.io.netty.util.concurrent.DefaultThreadFactory;
import org.apache.pulsar.shade.org.asynchttpclient.AsyncHttpClient;
import org.apache.pulsar.shade.org.asynchttpclient.BoundRequestBuilder;
import org.apache.pulsar.shade.org.asynchttpclient.DefaultAsyncHttpClient;
import org.apache.pulsar.shade.org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.apache.pulsar.shade.org.asynchttpclient.Request;
import org.apache.pulsar.shade.org.asynchttpclient.Response;
import org.apache.pulsar.shade.org.asynchttpclient.channel.DefaultKeepAliveStrategy;
import org.apache.pulsar.shade.org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlledClusterFailover
implements ServiceUrlProvider {
    private static final Logger log = LoggerFactory.getLogger(ControlledClusterFailover.class);
    private static final int DEFAULT_CONNECT_TIMEOUT_IN_SECONDS = 10;
    private static final int DEFAULT_READ_TIMEOUT_IN_SECONDS = 30;
    private static final int DEFAULT_MAX_REDIRECTS = 20;
    private PulsarClientImpl pulsarClient;
    private volatile String currentPulsarServiceUrl;
    private volatile ControlledConfiguration currentControlledConfiguration;
    private final ScheduledExecutorService executor;
    private final long interval;
    private ObjectMapper objectMapper = null;
    private final AsyncHttpClient httpClient;
    private final BoundRequestBuilder requestBuilder;

    private ControlledClusterFailover(ControlledClusterFailoverBuilderImpl builder) throws IOException {
        this.currentPulsarServiceUrl = builder.defaultServiceUrl;
        this.interval = builder.interval;
        this.executor = Executors.newSingleThreadScheduledExecutor(new DefaultThreadFactory("pulsar-service-provider"));
        this.httpClient = this.buildHttpClient();
        this.requestBuilder = (BoundRequestBuilder)this.httpClient.prepareGet(builder.urlProvider).addHeader((CharSequence)"Accept", "application/json");
        if (builder.header != null && !builder.header.isEmpty()) {
            builder.header.forEach(this.requestBuilder::addHeader);
        }
    }

    private AsyncHttpClient buildHttpClient() {
        DefaultAsyncHttpClientConfig.Builder confBuilder = new DefaultAsyncHttpClientConfig.Builder();
        confBuilder.setFollowRedirect(true);
        confBuilder.setMaxRedirects(20);
        confBuilder.setConnectTimeout(10000);
        confBuilder.setReadTimeout(30000);
        confBuilder.setUserAgent(String.format("Pulsar-Java-v%s", PulsarVersion.getVersion()));
        confBuilder.setKeepAliveStrategy(new DefaultKeepAliveStrategy(){

            @Override
            public boolean keepAlive(InetSocketAddress remoteAddress, Request ahcRequest, HttpRequest request, HttpResponse response) {
                return response.status().code() / 100 != 5 && super.keepAlive(remoteAddress, ahcRequest, request, response);
            }
        });
        DefaultAsyncHttpClientConfig config = confBuilder.build();
        return new DefaultAsyncHttpClient(config);
    }

    public void initialize(PulsarClient client) {
        this.pulsarClient = (PulsarClientImpl)client;
        this.executor.scheduleAtFixedRate(Runnables.catchingAndLoggingThrowables(() -> {
            ControlledConfiguration controlledConfiguration = null;
            try {
                controlledConfiguration = this.fetchControlledConfiguration();
                if (controlledConfiguration != null && !Strings.isNullOrEmpty(controlledConfiguration.getServiceUrl()) && !controlledConfiguration.equals(this.currentControlledConfiguration)) {
                    log.info("Switch Pulsar service url from {} to {}", (Object)this.currentControlledConfiguration, (Object)controlledConfiguration.toString());
                    Authentication authentication = null;
                    if (!Strings.isNullOrEmpty(controlledConfiguration.authPluginClassName) && !Strings.isNullOrEmpty(controlledConfiguration.getAuthParamsString())) {
                        authentication = AuthenticationFactory.create((String)controlledConfiguration.getAuthPluginClassName(), (String)controlledConfiguration.getAuthParamsString());
                    }
                    String tlsTrustCertsFilePath = controlledConfiguration.getTlsTrustCertsFilePath();
                    String serviceUrl = controlledConfiguration.getServiceUrl();
                    if (authentication != null) {
                        this.pulsarClient.updateAuthentication(authentication);
                    }
                    if (!Strings.isNullOrEmpty(tlsTrustCertsFilePath)) {
                        this.pulsarClient.updateTlsTrustCertsFilePath(tlsTrustCertsFilePath);
                    }
                    this.pulsarClient.updateServiceUrl(serviceUrl);
                    this.currentPulsarServiceUrl = serviceUrl;
                    this.currentControlledConfiguration = controlledConfiguration;
                }
            }
            catch (IOException e) {
                log.error("Failed to switch new Pulsar url, current: {}, new: {}", new Object[]{this.currentControlledConfiguration, controlledConfiguration, e});
            }
        }), this.interval, this.interval, TimeUnit.MILLISECONDS);
    }

    public String getCurrentPulsarServiceUrl() {
        return this.currentPulsarServiceUrl;
    }

    @VisibleForTesting
    protected BoundRequestBuilder getRequestBuilder() {
        return this.requestBuilder;
    }

    protected ControlledConfiguration fetchControlledConfiguration() throws IOException {
        try {
            Response response = (Response)this.requestBuilder.execute().get();
            int statusCode = response.getStatusCode();
            if (statusCode == 200) {
                String content = response.getResponseBody(StandardCharsets.UTF_8);
                return this.getObjectMapper().readValue(content, ControlledConfiguration.class);
            }
            log.warn("Failed to fetch controlled configuration, status code: {}", (Object)statusCode);
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("Failed to fetch controlled configuration ", (Throwable)e);
        }
        return null;
    }

    private ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
        }
        return this.objectMapper;
    }

    public String getServiceUrl() {
        return this.currentPulsarServiceUrl;
    }

    public void close() {
        this.executor.shutdown();
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                log.error("Failed to close http client.");
            }
        }
    }

    public static ControlledClusterFailoverBuilder builder() {
        return new ControlledClusterFailoverBuilderImpl();
    }

    public static class ControlledClusterFailoverBuilderImpl
    implements ControlledClusterFailoverBuilder {
        private String defaultServiceUrl;
        private String urlProvider;
        private Map<String, String> header = null;
        private long interval = 30000L;

        public ControlledClusterFailoverBuilder defaultServiceUrl(@NonNull String serviceUrl) {
            if (serviceUrl == null) {
                throw new NullPointerException("serviceUrl is marked non-null but is null");
            }
            this.defaultServiceUrl = serviceUrl;
            return this;
        }

        public ControlledClusterFailoverBuilder urlProvider(@NonNull String urlProvider) {
            if (urlProvider == null) {
                throw new NullPointerException("urlProvider is marked non-null but is null");
            }
            this.urlProvider = urlProvider;
            return this;
        }

        public ControlledClusterFailoverBuilder urlProviderHeader(Map<String, String> header) {
            this.header = header;
            return this;
        }

        public ControlledClusterFailoverBuilder checkInterval(long interval, @NonNull TimeUnit timeUnit) {
            if (timeUnit == null) {
                throw new NullPointerException("timeUnit is marked non-null but is null");
            }
            this.interval = timeUnit.toMillis(interval);
            return this;
        }

        public ServiceUrlProvider build() throws IOException {
            Objects.requireNonNull(this.defaultServiceUrl, "default service url shouldn't be null");
            Objects.requireNonNull(this.urlProvider, "urlProvider shouldn't be null");
            ControlledClusterFailoverBuilderImpl.checkArgument(this.interval > 0L, "checkInterval should > 0");
            return new ControlledClusterFailover(this);
        }

        public static void checkArgument(boolean expression, @Nullable Object errorMessage) {
            if (!expression) {
                throw new IllegalArgumentException(String.valueOf(errorMessage));
            }
        }
    }

    protected static class ControlledConfiguration {
        private String serviceUrl;
        private String tlsTrustCertsFilePath;
        private String authPluginClassName;
        private String authParamsString;

        public String toJson() {
            ObjectMapper objectMapper = ObjectMapperFactory.getThreadLocal();
            try {
                return objectMapper.writeValueAsString(this);
            }
            catch (JsonProcessingException e) {
                log.warn("Failed to write as json. ", (Throwable)e);
                return null;
            }
        }

        public String getServiceUrl() {
            return this.serviceUrl;
        }

        public String getTlsTrustCertsFilePath() {
            return this.tlsTrustCertsFilePath;
        }

        public String getAuthPluginClassName() {
            return this.authPluginClassName;
        }

        public String getAuthParamsString() {
            return this.authParamsString;
        }

        public void setServiceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
        }

        public void setTlsTrustCertsFilePath(String tlsTrustCertsFilePath) {
            this.tlsTrustCertsFilePath = tlsTrustCertsFilePath;
        }

        public void setAuthPluginClassName(String authPluginClassName) {
            this.authPluginClassName = authPluginClassName;
        }

        public void setAuthParamsString(String authParamsString) {
            this.authParamsString = authParamsString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ControlledConfiguration)) {
                return false;
            }
            ControlledConfiguration other = (ControlledConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$serviceUrl = this.getServiceUrl();
            String other$serviceUrl = other.getServiceUrl();
            if (this$serviceUrl == null ? other$serviceUrl != null : !this$serviceUrl.equals(other$serviceUrl)) {
                return false;
            }
            String this$tlsTrustCertsFilePath = this.getTlsTrustCertsFilePath();
            String other$tlsTrustCertsFilePath = other.getTlsTrustCertsFilePath();
            if (this$tlsTrustCertsFilePath == null ? other$tlsTrustCertsFilePath != null : !this$tlsTrustCertsFilePath.equals(other$tlsTrustCertsFilePath)) {
                return false;
            }
            String this$authPluginClassName = this.getAuthPluginClassName();
            String other$authPluginClassName = other.getAuthPluginClassName();
            if (this$authPluginClassName == null ? other$authPluginClassName != null : !this$authPluginClassName.equals(other$authPluginClassName)) {
                return false;
            }
            String this$authParamsString = this.getAuthParamsString();
            String other$authParamsString = other.getAuthParamsString();
            return !(this$authParamsString == null ? other$authParamsString != null : !this$authParamsString.equals(other$authParamsString));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ControlledConfiguration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $serviceUrl = this.getServiceUrl();
            result = result * 59 + ($serviceUrl == null ? 43 : $serviceUrl.hashCode());
            String $tlsTrustCertsFilePath = this.getTlsTrustCertsFilePath();
            result = result * 59 + ($tlsTrustCertsFilePath == null ? 43 : $tlsTrustCertsFilePath.hashCode());
            String $authPluginClassName = this.getAuthPluginClassName();
            result = result * 59 + ($authPluginClassName == null ? 43 : $authPluginClassName.hashCode());
            String $authParamsString = this.getAuthParamsString();
            result = result * 59 + ($authParamsString == null ? 43 : $authParamsString.hashCode());
            return result;
        }

        public String toString() {
            return "ControlledClusterFailover.ControlledConfiguration(serviceUrl=" + this.getServiceUrl() + ", tlsTrustCertsFilePath=" + this.getTlsTrustCertsFilePath() + ", authPluginClassName=" + this.getAuthPluginClassName() + ", authParamsString=" + this.getAuthParamsString() + ")";
        }
    }
}

