/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.admin.Brokers;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.conf.InternalConfigurationData;
import org.apache.pulsar.common.naming.TopicVersion;
import org.apache.pulsar.common.policies.data.BrokerInfo;
import org.apache.pulsar.common.policies.data.NamespaceOwnershipStatus;
import org.apache.pulsar.common.util.Codec;
import org.apache.pulsar.shade.javax.ws.rs.client.Entity;
import org.apache.pulsar.shade.javax.ws.rs.client.InvocationCallback;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;

public class BrokersImpl
extends BaseResource
implements Brokers {
    private final WebTarget adminBrokers;

    public BrokersImpl(WebTarget web, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.adminBrokers = web.path("admin/v2/brokers");
    }

    public List<String> getActiveBrokers(String cluster) throws PulsarAdminException {
        return (List)this.sync(() -> this.getActiveBrokersAsync(cluster));
    }

    public CompletableFuture<List<String>> getActiveBrokersAsync(String cluster) {
        WebTarget path = this.adminBrokers.path(cluster);
        final CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        this.asyncGetRequest(path, new InvocationCallback<List<String>>(){

            @Override
            public void completed(List<String> brokers) {
                future.complete(brokers);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BrokersImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public BrokerInfo getLeaderBroker() throws PulsarAdminException {
        return (BrokerInfo)this.sync(() -> this.getLeaderBrokerAsync());
    }

    public CompletableFuture<BrokerInfo> getLeaderBrokerAsync() {
        WebTarget path = this.adminBrokers.path("leaderBroker");
        final CompletableFuture<BrokerInfo> future = new CompletableFuture<BrokerInfo>();
        this.asyncGetRequest(path, new InvocationCallback<BrokerInfo>(){

            @Override
            public void completed(BrokerInfo leaderBroker) {
                future.complete(leaderBroker);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BrokersImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public Map<String, NamespaceOwnershipStatus> getOwnedNamespaces(String cluster, String brokerUrl) throws PulsarAdminException {
        return (Map)this.sync(() -> this.getOwnedNamespacesAsync(cluster, brokerUrl));
    }

    public CompletableFuture<Map<String, NamespaceOwnershipStatus>> getOwnedNamespacesAsync(String cluster, String brokerUrl) {
        WebTarget path = this.adminBrokers.path(cluster).path(brokerUrl).path("ownedNamespaces");
        final CompletableFuture<Map<String, NamespaceOwnershipStatus>> future = new CompletableFuture<Map<String, NamespaceOwnershipStatus>>();
        this.asyncGetRequest(path, new InvocationCallback<Map<String, NamespaceOwnershipStatus>>(){

            @Override
            public void completed(Map<String, NamespaceOwnershipStatus> ownedNamespaces) {
                future.complete(ownedNamespaces);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BrokersImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void updateDynamicConfiguration(String configName, String configValue) throws PulsarAdminException {
        this.sync(() -> this.updateDynamicConfigurationAsync(configName, configValue));
    }

    public CompletableFuture<Void> updateDynamicConfigurationAsync(String configName, String configValue) {
        String value = Codec.encode(configValue);
        WebTarget path = this.adminBrokers.path("configuration").path(configName).path(value);
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    public void deleteDynamicConfiguration(String configName) throws PulsarAdminException {
        this.sync(() -> this.deleteDynamicConfigurationAsync(configName));
    }

    public CompletableFuture<Void> deleteDynamicConfigurationAsync(String configName) {
        WebTarget path = this.adminBrokers.path("configuration").path(configName);
        return this.asyncDeleteRequest(path);
    }

    public Map<String, String> getAllDynamicConfigurations() throws PulsarAdminException {
        return (Map)this.sync(() -> this.getAllDynamicConfigurationsAsync());
    }

    public CompletableFuture<Map<String, String>> getAllDynamicConfigurationsAsync() {
        WebTarget path = this.adminBrokers.path("configuration").path("values");
        final CompletableFuture<Map<String, String>> future = new CompletableFuture<Map<String, String>>();
        this.asyncGetRequest(path, new InvocationCallback<Map<String, String>>(){

            @Override
            public void completed(Map<String, String> allConfs) {
                future.complete(allConfs);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BrokersImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public List<String> getDynamicConfigurationNames() throws PulsarAdminException {
        return (List)this.sync(() -> this.getDynamicConfigurationNamesAsync());
    }

    public CompletableFuture<List<String>> getDynamicConfigurationNamesAsync() {
        WebTarget path = this.adminBrokers.path("configuration");
        final CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        this.asyncGetRequest(path, new InvocationCallback<List<String>>(){

            @Override
            public void completed(List<String> confNames) {
                future.complete(confNames);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BrokersImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public Map<String, String> getRuntimeConfigurations() throws PulsarAdminException {
        return (Map)this.sync(() -> this.getRuntimeConfigurationsAsync());
    }

    public CompletableFuture<Map<String, String>> getRuntimeConfigurationsAsync() {
        WebTarget path = this.adminBrokers.path("configuration").path("runtime");
        final CompletableFuture<Map<String, String>> future = new CompletableFuture<Map<String, String>>();
        this.asyncGetRequest(path, new InvocationCallback<Map<String, String>>(){

            @Override
            public void completed(Map<String, String> runtimeConfs) {
                future.complete(runtimeConfs);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BrokersImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public InternalConfigurationData getInternalConfigurationData() throws PulsarAdminException {
        return (InternalConfigurationData)this.sync(() -> this.getInternalConfigurationDataAsync());
    }

    public CompletableFuture<InternalConfigurationData> getInternalConfigurationDataAsync() {
        WebTarget path = this.adminBrokers.path("internal-configuration");
        final CompletableFuture<InternalConfigurationData> future = new CompletableFuture<InternalConfigurationData>();
        this.asyncGetRequest(path, new InvocationCallback<InternalConfigurationData>(){

            @Override
            public void completed(InternalConfigurationData internalConfigurationData) {
                future.complete(internalConfigurationData);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BrokersImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void backlogQuotaCheck() throws PulsarAdminException {
        this.sync(() -> this.backlogQuotaCheckAsync());
    }

    public CompletableFuture<Void> backlogQuotaCheckAsync() {
        WebTarget path = this.adminBrokers.path("backlogQuotaCheck");
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.asyncGetRequest(path, new InvocationCallback<Void>(){

            @Override
            public void completed(Void unused) {
                future.complete(null);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        });
        return future;
    }

    @Deprecated
    public void healthcheck() throws PulsarAdminException {
        this.healthcheck(TopicVersion.V1);
    }

    @Deprecated
    public CompletableFuture<Void> healthcheckAsync() {
        return this.healthcheckAsync(TopicVersion.V1);
    }

    public void healthcheck(TopicVersion topicVersion) throws PulsarAdminException {
        this.sync(() -> this.healthcheckAsync(topicVersion));
    }

    public CompletableFuture<Void> healthcheckAsync(TopicVersion topicVersion) {
        WebTarget path = this.adminBrokers.path("health");
        if (topicVersion != null) {
            path = path.queryParam("topicVersion", topicVersion);
        }
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.asyncGetRequest(path, new InvocationCallback<String>(){

            @Override
            public void completed(String result) {
                if (!"ok".equalsIgnoreCase(result.trim())) {
                    future.completeExceptionally(new PulsarAdminException("Healthcheck returned unexpected result: " + result));
                } else {
                    future.complete(null);
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BrokersImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public String getVersion() throws PulsarAdminException {
        return (String)this.sync(() -> this.getVersionAsync());
    }

    public CompletableFuture<String> getVersionAsync() {
        WebTarget path = this.adminBrokers.path("version");
        final CompletableFuture<String> future = new CompletableFuture<String>();
        this.asyncGetRequest(path, new InvocationCallback<String>(){

            @Override
            public void completed(String version) {
                future.complete(version);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BrokersImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }
}

