/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.naming;

import java.util.Map;

public class Metadata {
    private static final int MAX_METADATA_SIZE = 1024;

    private Metadata() {
    }

    public static void validateMetadata(Map<String, String> metadata) throws IllegalArgumentException {
        if (metadata == null) {
            return;
        }
        int size = 0;
        for (Map.Entry<String, String> e : metadata.entrySet()) {
            if ((size += e.getKey().length() + e.getValue().length()) <= 1024) continue;
            throw new IllegalArgumentException(Metadata.getErrorMessage());
        }
    }

    private static String getErrorMessage() {
        return "metadata has a max size of 1 Kb";
    }
}

