/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.AnnotationIntrospector;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.util.EnumResolver;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.io.netty.util.internal.StringUtil;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;

public final class FieldParser {
    private static final Map<String, Method> CONVERTERS = new HashMap<String, Method>();
    private static final Map<Class<?>, Class<?>> WRAPPER_TYPES = new HashMap();
    private static final AnnotationIntrospector ANNOTATION_INTROSPECTOR = new JacksonAnnotationIntrospector();

    public static <T> T convert(Object from, Class<T> to) {
        Objects.requireNonNull(to);
        if (from == null) {
            return null;
        }
        if ((to = FieldParser.wrap(to)).isAssignableFrom(from.getClass())) {
            return (T)to.cast(from);
        }
        String converterId = from.getClass().getName() + "_" + to.getName();
        Method converter = CONVERTERS.get(converterId);
        if (to.isEnum()) {
            EnumResolver r = EnumResolver.constructUsingToString(to, ANNOTATION_INTROSPECTOR);
            Enum<?> value = r.findEnum((String)from);
            if (value == null) {
                throw new RuntimeException("Invalid value '" + from + "' for enum " + to);
            }
            return (T)value;
        }
        if (converter == null) {
            throw new UnsupportedOperationException("Cannot convert from " + from.getClass().getName() + " to " + to.getName() + ". Requested converter does not exist.");
        }
        try {
            Object val = converter.invoke(to, from);
            return (T)to.cast(val);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot convert from " + from.getClass().getName() + " to " + to.getName() + ". Conversion failed with " + e.getMessage(), e);
        }
    }

    public static <T> void update(Map<String, String> properties, T obj) throws IllegalArgumentException {
        Field[] fields = obj.getClass().getDeclaredFields();
        Arrays.stream(fields).forEach(f -> {
            if (properties.containsKey(f.getName())) {
                try {
                    f.setAccessible(true);
                    String v = (String)properties.get(f.getName());
                    if (!StringUtils.isBlank(v)) {
                        f.set(obj, FieldParser.value(v, f));
                    } else {
                        FieldParser.setEmptyValue(v, f, obj);
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("failed to initialize %s field while setting value %s", f.getName(), properties.get(f.getName())), e);
                }
            }
        });
    }

    public static Object value(String strValue, Field field) {
        Objects.requireNonNull(field);
        Type fieldType = field.getGenericType();
        if (fieldType instanceof ParameterizedType) {
            Class clazz = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
            if (field.getType().equals(List.class)) {
                return FieldParser.stringToList(strValue, clazz);
            }
            if (field.getType().equals(Set.class)) {
                return FieldParser.stringToSet(strValue, clazz);
            }
            if (field.getType().equals(Map.class)) {
                Class valueClass = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[1];
                return FieldParser.stringToMap(strValue, clazz, valueClass);
            }
            if (field.getType().equals(Optional.class)) {
                Type typeClazz = ((ParameterizedType)fieldType).getActualTypeArguments()[0];
                if (typeClazz instanceof ParameterizedType) {
                    throw new IllegalArgumentException(String.format("unsupported non-primitive Optional<%s> for %s", typeClazz.getClass(), field.getName()));
                }
                return Optional.ofNullable(FieldParser.convert(strValue, (Class)typeClazz));
            }
            throw new IllegalArgumentException(String.format("unsupported field-type %s for %s", field.getType(), field.getName()));
        }
        return FieldParser.convert(strValue, field.getType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> void setEmptyValue(String strValue, Field field, T obj) throws IllegalArgumentException, IllegalAccessException {
        Objects.requireNonNull(field);
        Type fieldType = field.getGenericType();
        if (fieldType instanceof ParameterizedType) {
            if (field.getType().equals(List.class)) {
                field.set(obj, new ArrayList());
                return;
            } else if (field.getType().equals(Set.class)) {
                field.set(obj, new HashSet());
                return;
            } else {
                if (!field.getType().equals(Optional.class)) throw new IllegalArgumentException(String.format("unsupported field-type %s for %s", field.getType(), field.getName()));
                field.set(obj, Optional.empty());
            }
            return;
        } else {
            if (!Number.class.isAssignableFrom(field.getType()) && !fieldType.getClass().equals(String.class)) return;
            field.set(obj, null);
        }
    }

    private static Class<?> wrap(Class<?> type) {
        return WRAPPER_TYPES.containsKey(type) ? WRAPPER_TYPES.get(type) : type;
    }

    private static void initConverters() {
        Method[] methods = FieldParser.class.getDeclaredMethods();
        Arrays.stream(methods).forEach(method -> {
            if (method.getParameterTypes().length == 1) {
                CONVERTERS.put(method.getParameterTypes()[0].getName() + "_" + method.getReturnType().getName(), (Method)method);
            }
        });
    }

    private static void initWrappers() {
        WRAPPER_TYPES.put(Integer.TYPE, Integer.class);
        WRAPPER_TYPES.put(Float.TYPE, Float.class);
        WRAPPER_TYPES.put(Double.TYPE, Double.class);
        WRAPPER_TYPES.put(Long.TYPE, Long.class);
        WRAPPER_TYPES.put(Boolean.TYPE, Boolean.class);
    }

    public static Integer stringToInteger(String val) {
        String v = FieldParser.trim(val);
        if (StringUtil.isNullOrEmpty(v)) {
            return null;
        }
        return Integer.valueOf(v);
    }

    public static Long stringToLong(String val) {
        return Long.valueOf(FieldParser.trim(val));
    }

    public static Double stringToDouble(String val) {
        String v = FieldParser.trim(val);
        if (StringUtil.isNullOrEmpty(v)) {
            return null;
        }
        return Double.valueOf(v);
    }

    public static Float stringToFloat(String val) {
        return Float.valueOf(FieldParser.trim(val));
    }

    public static <T> List<T> stringToList(String val, Class<T> type) {
        String[] tokens = FieldParser.trim(val).split(",");
        return Arrays.stream(tokens).map(t -> FieldParser.convert(t, type)).collect(Collectors.toList());
    }

    public static <T> Set<T> stringToSet(String val, Class<T> type) {
        String[] tokens = FieldParser.trim(val).split(",");
        return Arrays.stream(tokens).map(t -> FieldParser.convert(t, type)).collect(Collectors.toSet());
    }

    private static <K, V> Map<K, V> stringToMap(String strValue, Class<K> keyType, Class<V> valueType) {
        String[] tokens = FieldParser.trim(strValue).split(",");
        HashMap<K, V> map = new HashMap<K, V>();
        for (String token : tokens) {
            String[] keyValue = FieldParser.trim(token).split("=");
            Preconditions.checkArgument(keyValue.length == 2, strValue + " map-value is not in correct format key1=value,key2=value2");
            map.put(FieldParser.convert(keyValue[0], keyType), FieldParser.convert(keyValue[1], valueType));
        }
        return map;
    }

    private static String trim(String val) {
        Objects.requireNonNull(val);
        return val.trim();
    }

    public static String integerToString(Integer value) {
        return value.toString();
    }

    public static String booleanToString(Boolean value) {
        return value.toString();
    }

    public static Boolean stringToBoolean(String value) {
        return Boolean.valueOf(value);
    }

    static {
        FieldParser.initConverters();
        FieldParser.initWrappers();
    }
}

