/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import org.apache.pulsar.client.api.NegativeAckRedeliveryBackoff;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;

public class NegativeAckRedeliveryExponentialBackoff
implements NegativeAckRedeliveryBackoff {
    private final long minNackTimeMs;
    private final long maxNackTimeMs;
    private final int maxBitShift;

    private NegativeAckRedeliveryExponentialBackoff(long minNackTimeMs, long maxNackTimeMs) {
        this.minNackTimeMs = minNackTimeMs;
        this.maxNackTimeMs = maxNackTimeMs;
        int i = 0;
        while (this.minNackTimeMs << ++i > 0L) {
        }
        this.maxBitShift = i;
    }

    public static NegativeAckRedeliveryExponentialBackoffBuilder builder() {
        return new NegativeAckRedeliveryExponentialBackoffBuilder();
    }

    public long getMinNackTimeMs() {
        return this.minNackTimeMs;
    }

    public long getMaxNackTimeMs() {
        return this.maxNackTimeMs;
    }

    public long next(int redeliveryCount) {
        if (redeliveryCount <= 0 || this.minNackTimeMs <= 0L) {
            return this.minNackTimeMs;
        }
        if (this.maxBitShift <= redeliveryCount) {
            return this.maxNackTimeMs;
        }
        return Math.min(this.minNackTimeMs << redeliveryCount, this.maxNackTimeMs);
    }

    public static class NegativeAckRedeliveryExponentialBackoffBuilder {
        private long minNackTimeMs = 10000L;
        private long maxNackTimeMs = 600000L;

        public NegativeAckRedeliveryExponentialBackoffBuilder minNackTimeMs(long minNackTimeMs) {
            this.minNackTimeMs = minNackTimeMs;
            return this;
        }

        public NegativeAckRedeliveryExponentialBackoffBuilder maxNackTimeMs(long maxNackTimeMs) {
            this.maxNackTimeMs = maxNackTimeMs;
            return this;
        }

        public NegativeAckRedeliveryExponentialBackoff build() {
            Preconditions.checkArgument(this.minNackTimeMs >= 0L, "min nack time must be >= 0");
            Preconditions.checkArgument(this.maxNackTimeMs >= this.minNackTimeMs, "max nack time must be >= minNackTimeMs");
            return new NegativeAckRedeliveryExponentialBackoff(this.minNackTimeMs, this.maxNackTimeMs);
        }
    }
}

