/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pulsar.client.admin.Packages;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.ComponentResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.packages.management.core.common.PackageMetadata;
import org.apache.pulsar.packages.management.core.common.PackageName;
import org.apache.pulsar.shade.com.google.gson.Gson;
import org.apache.pulsar.shade.javax.ws.rs.client.Entity;
import org.apache.pulsar.shade.javax.ws.rs.client.InvocationCallback;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;
import org.apache.pulsar.shade.javax.ws.rs.core.Response;
import org.apache.pulsar.shade.org.asynchttpclient.AsyncHttpClient;
import org.apache.pulsar.shade.org.asynchttpclient.Dsl;
import org.apache.pulsar.shade.org.asynchttpclient.RequestBuilder;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.multipart.FilePart;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.multipart.StringPart;

public class PackagesImpl
extends ComponentResource
implements Packages {
    private final WebTarget packages;
    private final AsyncHttpClient httpClient;

    public PackagesImpl(WebTarget webTarget, Authentication auth, AsyncHttpClient client, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.httpClient = client;
        this.packages = webTarget.path("/admin/v3/packages");
    }

    @Override
    public PackageMetadata getMetadata(String packageName) throws PulsarAdminException {
        try {
            return this.getMetadataAsync(packageName).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<PackageMetadata> getMetadataAsync(String packageName) {
        WebTarget path = this.packages.path(PackageName.get((String)packageName).toRestPath() + "/metadata");
        final CompletableFuture<PackageMetadata> future = new CompletableFuture<PackageMetadata>();
        this.asyncGetRequest(path, new InvocationCallback<PackageMetadata>(){

            @Override
            public void completed(PackageMetadata metadata) {
                future.complete(metadata);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(PackagesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void updateMetadata(String packageName, PackageMetadata metadata) throws PulsarAdminException {
        try {
            this.updateMetadataAsync(packageName, metadata).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
    }

    @Override
    public CompletableFuture<Void> updateMetadataAsync(String packageName, PackageMetadata metadata) {
        WebTarget path = this.packages.path(PackageName.get((String)packageName).toRestPath() + "/metadata");
        return this.asyncPutRequest(path, Entity.entity(metadata, "application/json"));
    }

    @Override
    public void upload(PackageMetadata metadata, String packageName, String path) throws PulsarAdminException {
        try {
            this.uploadAsync(metadata, packageName, path).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
    }

    @Override
    public CompletableFuture<Void> uploadAsync(PackageMetadata metadata, String packageName, String path) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            RequestBuilder builder = (RequestBuilder)((RequestBuilder)Dsl.post(this.packages.path(PackageName.get((String)packageName).toRestPath()).getUri().toASCIIString()).addBodyPart(new FilePart("file", new File(path), "application/octet-stream"))).addBodyPart(new StringPart("metadata", new Gson().toJson(metadata), "application/json"));
            ((CompletableFuture)this.httpClient.executeRequest(this.addAuthHeaders(this.packages, builder).build()).toCompletableFuture().thenAccept(response -> {
                if (response.getStatusCode() < 200 || response.getStatusCode() >= 300) {
                    future.completeExceptionally(this.getApiException(Response.status(response.getStatusCode()).entity(response.getResponseBody()).build()));
                } else {
                    future.complete(null);
                }
            })).exceptionally(throwable -> {
                future.completeExceptionally(this.getApiException((Throwable)throwable));
                return null;
            });
        }
        catch (PulsarAdminException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    @Override
    public void download(String packageName, String path) throws PulsarAdminException {
        try {
            this.downloadAsync(packageName, path).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof PulsarAdminException) {
                throw (PulsarAdminException)cause;
            }
            throw new PulsarAdminException(cause);
        }
    }

    @Override
    public CompletableFuture<Void> downloadAsync(String packageName, final String path) {
        WebTarget webTarget = this.packages.path(PackageName.get((String)packageName).toRestPath());
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.asyncGetRequest(webTarget, new InvocationCallback<Response>(){

            @Override
            public void completed(Response response) {
                if (response.getStatusInfo().equals(Response.Status.OK)) {
                    try (InputStream inputStream = response.readEntity(InputStream.class);){
                        Path destinyPath = Paths.get(path, new String[0]);
                        if (destinyPath.getParent() != null) {
                            Files.createDirectories(destinyPath.getParent(), new FileAttribute[0]);
                        }
                        Files.copy(inputStream, destinyPath, new CopyOption[0]);
                        future.complete(null);
                    }
                    catch (IOException e) {
                        future.completeExceptionally(e);
                    }
                } else {
                    future.completeExceptionally(PackagesImpl.this.getApiException(response));
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        });
        return future;
    }

    @Override
    public void delete(String packageName) throws PulsarAdminException {
        try {
            this.deleteAsync(packageName).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
    }

    @Override
    public CompletableFuture<Void> deleteAsync(String packageName) {
        PackageName name = PackageName.get((String)packageName);
        WebTarget path = this.packages.path(name.toRestPath());
        return this.asyncDeleteRequest(path);
    }

    @Override
    public List<String> listPackageVersions(String packageName) throws PulsarAdminException {
        try {
            return this.listPackageVersionsAsync(packageName).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
    }

    @Override
    public CompletableFuture<List<String>> listPackageVersionsAsync(String packageName) {
        PackageName name = PackageName.get((String)packageName);
        WebTarget path = this.packages.path(String.format("%s/%s/%s/%s", name.getPkgType().toString(), name.getTenant(), name.getNamespace(), name.getName()));
        final CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        this.asyncGetRequest(path, new InvocationCallback<List<String>>(){

            @Override
            public void completed(List<String> strings) {
                future.complete(strings);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(PackagesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public List<String> listPackages(String type, String namespace) throws PulsarAdminException {
        try {
            return this.listPackagesAsync(type, namespace).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
    }

    @Override
    public CompletableFuture<List<String>> listPackagesAsync(String type, String namespace) {
        WebTarget path = this.packages.path(type + "/" + NamespaceName.get(namespace).toString());
        final CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        this.asyncGetRequest(path, new InvocationCallback<List<String>>(){

            @Override
            public void completed(List<String> strings) {
                future.complete(strings);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(PackagesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }
}

