/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.tls;

import java.util.Collections;
import java.util.List;
import org.apache.pulsar.client.impl.tls.DomainType;

public final class PublicSuffixList {
    private final DomainType type;
    private final List<String> rules;
    private final List<String> exceptions;

    public PublicSuffixList(DomainType type, List<String> rules, List<String> exceptions) {
        this.type = type;
        this.rules = Collections.unmodifiableList(rules);
        this.exceptions = Collections.unmodifiableList(exceptions != null ? exceptions : Collections.emptyList());
    }

    public PublicSuffixList(List<String> rules, List<String> exceptions) {
        this(DomainType.UNKNOWN, rules, exceptions);
    }

    public DomainType getType() {
        return this.type;
    }

    public List<String> getRules() {
        return this.rules;
    }

    public List<String> getExceptions() {
        return this.exceptions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PublicSuffixList)) {
            return false;
        }
        PublicSuffixList other = (PublicSuffixList)o;
        DomainType this$type = this.getType();
        DomainType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        List<String> this$rules = this.getRules();
        List<String> other$rules = other.getRules();
        if (this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules)) {
            return false;
        }
        List<String> this$exceptions = this.getExceptions();
        List<String> other$exceptions = other.getExceptions();
        return !(this$exceptions == null ? other$exceptions != null : !((Object)this$exceptions).equals(other$exceptions));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DomainType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        List<String> $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        List<String> $exceptions = this.getExceptions();
        result = result * 59 + ($exceptions == null ? 43 : ((Object)$exceptions).hashCode());
        return result;
    }

    public String toString() {
        return "PublicSuffixList(type=" + (Object)((Object)this.getType()) + ", rules=" + this.getRules() + ", exceptions=" + this.getExceptions() + ")";
    }
}

