/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pulsar.client.admin.Clusters;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.policies.data.BrokerNamespaceIsolationData;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.FailureDomain;
import org.apache.pulsar.common.policies.data.NamespaceIsolationData;
import org.apache.pulsar.shade.javax.ws.rs.client.Entity;
import org.apache.pulsar.shade.javax.ws.rs.client.InvocationCallback;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;
import org.apache.pulsar.shade.javax.ws.rs.core.MediaType;

public class ClustersImpl
extends BaseResource
implements Clusters {
    private final WebTarget adminClusters;

    public ClustersImpl(WebTarget web, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.adminClusters = web.path("/admin/v2/clusters");
    }

    @Override
    public List<String> getClusters() throws PulsarAdminException {
        try {
            return this.getClustersAsync().get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<List<String>> getClustersAsync() {
        final CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        this.asyncGetRequest(this.adminClusters, new InvocationCallback<List<String>>(){

            @Override
            public void completed(List<String> clusters) {
                future.complete(clusters);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(ClustersImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public ClusterData getCluster(String cluster) throws PulsarAdminException {
        try {
            return this.getClusterAsync(cluster).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<ClusterData> getClusterAsync(String cluster) {
        WebTarget path = this.adminClusters.path(cluster);
        final CompletableFuture<ClusterData> future = new CompletableFuture<ClusterData>();
        this.asyncGetRequest(path, new InvocationCallback<ClusterData>(){

            @Override
            public void completed(ClusterData clusterData) {
                future.complete(clusterData);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(ClustersImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void createCluster(String cluster, ClusterData clusterData) throws PulsarAdminException {
        try {
            this.createClusterAsync(cluster, clusterData).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<Void> createClusterAsync(String cluster, ClusterData clusterData) {
        WebTarget path = this.adminClusters.path(cluster);
        return this.asyncPutRequest(path, Entity.entity(clusterData, "application/json"));
    }

    @Override
    public void updateCluster(String cluster, ClusterData clusterData) throws PulsarAdminException {
        try {
            this.updateClusterAsync(cluster, clusterData).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<Void> updateClusterAsync(String cluster, ClusterData clusterData) {
        WebTarget path = this.adminClusters.path(cluster);
        return this.asyncPostRequest(path, Entity.entity(clusterData, MediaType.APPLICATION_JSON_TYPE));
    }

    @Override
    public void updatePeerClusterNames(String cluster, LinkedHashSet<String> peerClusterNames) throws PulsarAdminException {
        try {
            this.updatePeerClusterNamesAsync(cluster, peerClusterNames).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<Void> updatePeerClusterNamesAsync(String cluster, LinkedHashSet<String> peerClusterNames) {
        WebTarget path = this.adminClusters.path(cluster).path("peers");
        return this.asyncPostRequest(path, Entity.entity(peerClusterNames, "application/json"));
    }

    @Override
    public Set<String> getPeerClusterNames(String cluster) throws PulsarAdminException {
        try {
            return this.getPeerClusterNamesAsync(cluster).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<Set<String>> getPeerClusterNamesAsync(String cluster) {
        WebTarget path = this.adminClusters.path(cluster).path("peers");
        final CompletableFuture<Set<String>> future = new CompletableFuture<Set<String>>();
        this.asyncGetRequest(path, new InvocationCallback<Set<String>>(){

            @Override
            public void completed(Set<String> clusterNames) {
                future.complete(clusterNames);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(ClustersImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void deleteCluster(String cluster) throws PulsarAdminException {
        try {
            this.deleteClusterAsync(cluster).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<Void> deleteClusterAsync(String cluster) {
        WebTarget path = this.adminClusters.path(cluster);
        return this.asyncDeleteRequest(path);
    }

    @Override
    public Map<String, NamespaceIsolationData> getNamespaceIsolationPolicies(String cluster) throws PulsarAdminException {
        try {
            return this.getNamespaceIsolationPoliciesAsync(cluster).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<Map<String, NamespaceIsolationData>> getNamespaceIsolationPoliciesAsync(String cluster) {
        WebTarget path = this.adminClusters.path(cluster).path("namespaceIsolationPolicies");
        final CompletableFuture<Map<String, NamespaceIsolationData>> future = new CompletableFuture<Map<String, NamespaceIsolationData>>();
        this.asyncGetRequest(path, new InvocationCallback<Map<String, NamespaceIsolationData>>(){

            @Override
            public void completed(Map<String, NamespaceIsolationData> stringNamespaceIsolationDataMap) {
                future.complete(stringNamespaceIsolationDataMap);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(ClustersImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public List<BrokerNamespaceIsolationData> getBrokersWithNamespaceIsolationPolicy(String cluster) throws PulsarAdminException {
        try {
            return this.getBrokersWithNamespaceIsolationPolicyAsync(cluster).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<List<BrokerNamespaceIsolationData>> getBrokersWithNamespaceIsolationPolicyAsync(String cluster) {
        WebTarget path = this.adminClusters.path(cluster).path("namespaceIsolationPolicies").path("brokers");
        final CompletableFuture<List<BrokerNamespaceIsolationData>> future = new CompletableFuture<List<BrokerNamespaceIsolationData>>();
        this.asyncGetRequest(path, new InvocationCallback<List<BrokerNamespaceIsolationData>>(){

            @Override
            public void completed(List<BrokerNamespaceIsolationData> brokerNamespaceIsolationData) {
                future.complete(brokerNamespaceIsolationData);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(ClustersImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public BrokerNamespaceIsolationData getBrokerWithNamespaceIsolationPolicy(String cluster, String broker) throws PulsarAdminException {
        try {
            return this.getBrokerWithNamespaceIsolationPolicyAsync(cluster, broker).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<BrokerNamespaceIsolationData> getBrokerWithNamespaceIsolationPolicyAsync(String cluster, String broker) {
        WebTarget path = this.adminClusters.path(cluster).path("namespaceIsolationPolicies").path("brokers").path(broker);
        final CompletableFuture<BrokerNamespaceIsolationData> future = new CompletableFuture<BrokerNamespaceIsolationData>();
        this.asyncGetRequest(path, new InvocationCallback<BrokerNamespaceIsolationData>(){

            @Override
            public void completed(BrokerNamespaceIsolationData brokerNamespaceIsolationData) {
                future.complete(brokerNamespaceIsolationData);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(ClustersImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void createNamespaceIsolationPolicy(String cluster, String policyName, NamespaceIsolationData namespaceIsolationData) throws PulsarAdminException {
        this.setNamespaceIsolationPolicy(cluster, policyName, namespaceIsolationData);
    }

    @Override
    public CompletableFuture<Void> createNamespaceIsolationPolicyAsync(String cluster, String policyName, NamespaceIsolationData namespaceIsolationData) {
        return this.setNamespaceIsolationPolicyAsync(cluster, policyName, namespaceIsolationData);
    }

    @Override
    public void updateNamespaceIsolationPolicy(String cluster, String policyName, NamespaceIsolationData namespaceIsolationData) throws PulsarAdminException {
        this.setNamespaceIsolationPolicy(cluster, policyName, namespaceIsolationData);
    }

    @Override
    public CompletableFuture<Void> updateNamespaceIsolationPolicyAsync(String cluster, String policyName, NamespaceIsolationData namespaceIsolationData) {
        return this.setNamespaceIsolationPolicyAsync(cluster, policyName, namespaceIsolationData);
    }

    @Override
    public void deleteNamespaceIsolationPolicy(String cluster, String policyName) throws PulsarAdminException {
        try {
            this.deleteNamespaceIsolationPolicyAsync(cluster, policyName).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<Void> deleteNamespaceIsolationPolicyAsync(String cluster, String policyName) {
        WebTarget path = this.adminClusters.path(cluster).path("namespaceIsolationPolicies").path(policyName);
        return this.asyncDeleteRequest(path);
    }

    private void setNamespaceIsolationPolicy(String cluster, String policyName, NamespaceIsolationData namespaceIsolationData) throws PulsarAdminException {
        try {
            this.setNamespaceIsolationPolicyAsync(cluster, policyName, namespaceIsolationData).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    private CompletableFuture<Void> setNamespaceIsolationPolicyAsync(String cluster, String policyName, NamespaceIsolationData namespaceIsolationData) {
        WebTarget path = this.adminClusters.path(cluster).path("namespaceIsolationPolicies").path(policyName);
        return this.asyncPostRequest(path, Entity.entity(namespaceIsolationData, "application/json"));
    }

    @Override
    public NamespaceIsolationData getNamespaceIsolationPolicy(String cluster, String policyName) throws PulsarAdminException {
        try {
            return this.getNamespaceIsolationPolicyAsync(cluster, policyName).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<NamespaceIsolationData> getNamespaceIsolationPolicyAsync(String cluster, String policyName) {
        WebTarget path = this.adminClusters.path(cluster).path("namespaceIsolationPolicies").path(policyName);
        final CompletableFuture<NamespaceIsolationData> future = new CompletableFuture<NamespaceIsolationData>();
        this.asyncGetRequest(path, new InvocationCallback<NamespaceIsolationData>(){

            @Override
            public void completed(NamespaceIsolationData namespaceIsolationData) {
                future.complete(namespaceIsolationData);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(ClustersImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void createFailureDomain(String cluster, String domainName, FailureDomain domain) throws PulsarAdminException {
        this.setDomain(cluster, domainName, domain);
    }

    @Override
    public CompletableFuture<Void> createFailureDomainAsync(String cluster, String domainName, FailureDomain domain) {
        return this.setDomainAsync(cluster, domainName, domain);
    }

    @Override
    public void updateFailureDomain(String cluster, String domainName, FailureDomain domain) throws PulsarAdminException {
        this.setDomain(cluster, domainName, domain);
    }

    @Override
    public CompletableFuture<Void> updateFailureDomainAsync(String cluster, String domainName, FailureDomain domain) {
        return this.setDomainAsync(cluster, domainName, domain);
    }

    @Override
    public void deleteFailureDomain(String cluster, String domainName) throws PulsarAdminException {
        try {
            this.deleteFailureDomainAsync(cluster, domainName).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<Void> deleteFailureDomainAsync(String cluster, String domainName) {
        WebTarget path = this.adminClusters.path(cluster).path("failureDomains").path(domainName);
        return this.asyncDeleteRequest(path);
    }

    @Override
    public Map<String, FailureDomain> getFailureDomains(String cluster) throws PulsarAdminException {
        try {
            return this.getFailureDomainsAsync(cluster).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<Map<String, FailureDomain>> getFailureDomainsAsync(String cluster) {
        WebTarget path = this.adminClusters.path(cluster).path("failureDomains");
        final CompletableFuture<Map<String, FailureDomain>> future = new CompletableFuture<Map<String, FailureDomain>>();
        this.asyncGetRequest(path, new InvocationCallback<Map<String, FailureDomain>>(){

            @Override
            public void completed(Map<String, FailureDomain> failureDomains) {
                future.complete(failureDomains);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(ClustersImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public FailureDomain getFailureDomain(String cluster, String domainName) throws PulsarAdminException {
        try {
            return this.getFailureDomainAsync(cluster, domainName).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<FailureDomain> getFailureDomainAsync(String cluster, String domainName) {
        WebTarget path = this.adminClusters.path(cluster).path("failureDomains").path(domainName);
        final CompletableFuture<FailureDomain> future = new CompletableFuture<FailureDomain>();
        this.asyncGetRequest(path, new InvocationCallback<FailureDomain>(){

            @Override
            public void completed(FailureDomain failureDomain) {
                future.complete(failureDomain);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(ClustersImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    private void setDomain(String cluster, String domainName, FailureDomain domain) throws PulsarAdminException {
        try {
            this.setDomainAsync(cluster, domainName, domain).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    private CompletableFuture<Void> setDomainAsync(String cluster, String domainName, FailureDomain domain) {
        WebTarget path = this.adminClusters.path(cluster).path("failureDomains").path(domainName);
        return this.asyncPostRequest(path, Entity.entity(domain, "application/json"));
    }
}

