/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import com.google.gson.Gson;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.admin.Functions;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.ComponentResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.functions.FunctionConfig;
import org.apache.pulsar.common.functions.FunctionState;
import org.apache.pulsar.common.functions.UpdateOptions;
import org.apache.pulsar.common.functions.WorkerInfo;
import org.apache.pulsar.common.io.ConnectorDefinition;
import org.apache.pulsar.common.policies.data.FunctionStats;
import org.apache.pulsar.common.policies.data.FunctionStatus;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.request.body.multipart.ByteArrayPart;
import org.asynchttpclient.request.body.multipart.FilePart;
import org.asynchttpclient.request.body.multipart.Part;
import org.asynchttpclient.request.body.multipart.StringPart;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionsImpl
extends ComponentResource
implements Functions {
    private static final Logger log = LoggerFactory.getLogger(FunctionsImpl.class);
    private final WebTarget functions;
    private final AsyncHttpClient asyncHttpClient;

    public FunctionsImpl(WebTarget web, Authentication auth, AsyncHttpClient asyncHttpClient, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.functions = web.path("/admin/v3/functions");
        this.asyncHttpClient = asyncHttpClient;
    }

    public List<String> getFunctions(String tenant, String namespace) throws PulsarAdminException {
        try {
            return this.getFunctionsAsync(tenant, namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            this.handlePulsarAdminException(e);
            throw new PulsarAdminException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<List<String>> getFunctionsAsync(String tenant, String namespace) {
        WebTarget path = this.functions.path(tenant).path(namespace);
        final CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            public void completed(Response response) {
                if (!response.getStatusInfo().equals(Response.Status.OK)) {
                    future.completeExceptionally(FunctionsImpl.this.getApiException(response));
                } else {
                    List functions = (List)response.readEntity((GenericType)new GenericType<List<String>>(){});
                    future.complete(functions);
                }
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(FunctionsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public FunctionConfig getFunction(String tenant, String namespace, String function) throws PulsarAdminException {
        try {
            return this.getFunctionAsync(tenant, namespace, function).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            this.handlePulsarAdminException(e);
            throw new PulsarAdminException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<FunctionConfig> getFunctionAsync(String tenant, String namespace, String function) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function);
        final CompletableFuture<FunctionConfig> future = new CompletableFuture<FunctionConfig>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            public void completed(Response response) {
                if (!response.getStatusInfo().equals(Response.Status.OK)) {
                    future.completeExceptionally(FunctionsImpl.this.getApiException(response));
                } else {
                    future.complete(response.readEntity(FunctionConfig.class));
                }
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(FunctionsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public FunctionStatus getFunctionStatus(String tenant, String namespace, String function) throws PulsarAdminException {
        try {
            return this.getFunctionStatusAsync(tenant, namespace, function).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            this.handlePulsarAdminException(e);
            throw new PulsarAdminException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<FunctionStatus> getFunctionStatusAsync(String tenant, String namespace, String function) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function).path("status");
        final CompletableFuture<FunctionStatus> future = new CompletableFuture<FunctionStatus>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            public void completed(Response response) {
                if (!response.getStatusInfo().equals(Response.Status.OK)) {
                    future.completeExceptionally(FunctionsImpl.this.getApiException(response));
                } else {
                    future.complete(response.readEntity(FunctionStatus.class));
                }
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(FunctionsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData getFunctionStatus(String tenant, String namespace, String function, int id) throws PulsarAdminException {
        try {
            return this.getFunctionStatusAsync(tenant, namespace, function, id).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            this.handlePulsarAdminException(e);
            throw new PulsarAdminException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData> getFunctionStatusAsync(String tenant, String namespace, String function, int id) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function).path(Integer.toString(id)).path("status");
        final CompletableFuture<FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData> future = new CompletableFuture<FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            public void completed(Response response) {
                if (!response.getStatusInfo().equals(Response.Status.OK)) {
                    future.completeExceptionally(FunctionsImpl.this.getApiException(response));
                } else {
                    future.complete(response.readEntity(FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData.class));
                }
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(FunctionsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public FunctionStats.FunctionInstanceStats.FunctionInstanceStatsData getFunctionStats(String tenant, String namespace, String function, int id) throws PulsarAdminException {
        try {
            return this.getFunctionStatsAsync(tenant, namespace, function, id).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            this.handlePulsarAdminException(e);
            throw new PulsarAdminException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<FunctionStats.FunctionInstanceStats.FunctionInstanceStatsData> getFunctionStatsAsync(String tenant, String namespace, String function, int id) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function).path(Integer.toString(id)).path("stats");
        final CompletableFuture<FunctionStats.FunctionInstanceStats.FunctionInstanceStatsData> future = new CompletableFuture<FunctionStats.FunctionInstanceStats.FunctionInstanceStatsData>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            public void completed(Response response) {
                if (!response.getStatusInfo().equals(Response.Status.OK)) {
                    future.completeExceptionally(FunctionsImpl.this.getApiException(response));
                } else {
                    future.complete(response.readEntity(FunctionStats.FunctionInstanceStats.FunctionInstanceStatsData.class));
                }
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(FunctionsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public FunctionStats getFunctionStats(String tenant, String namespace, String function) throws PulsarAdminException {
        try {
            return this.getFunctionStatsAsync(tenant, namespace, function).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            this.handlePulsarAdminException(e);
            throw new PulsarAdminException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<FunctionStats> getFunctionStatsAsync(String tenant, String namespace, String function) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function).path("stats");
        final CompletableFuture<FunctionStats> future = new CompletableFuture<FunctionStats>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            public void completed(Response response) {
                if (!response.getStatusInfo().equals(Response.Status.OK)) {
                    future.completeExceptionally(FunctionsImpl.this.getApiException(response));
                } else {
                    future.complete(response.readEntity(FunctionStats.class));
                }
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(FunctionsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void createFunction(FunctionConfig functionConfig, String fileName) throws PulsarAdminException {
        try {
            this.createFunctionAsync(functionConfig, fileName).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            this.handlePulsarAdminException(e);
            throw new PulsarAdminException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> createFunctionAsync(FunctionConfig functionConfig, String fileName) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            RequestBuilder builder = (RequestBuilder)Dsl.post((String)this.functions.path(functionConfig.getTenant()).path(functionConfig.getNamespace()).path(functionConfig.getName()).getUri().toASCIIString()).addBodyPart((Part)new StringPart("functionConfig", ObjectMapperFactory.getThreadLocal().writeValueAsString((Object)functionConfig), "application/json"));
            if (fileName != null && !fileName.startsWith("builtin://")) {
                builder.addBodyPart((Part)new FilePart("data", new File(fileName), "application/octet-stream"));
            }
            ((CompletableFuture)this.asyncHttpClient.executeRequest(this.addAuthHeaders(this.functions, builder).build()).toCompletableFuture().thenAccept(response -> {
                if (response.getStatusCode() < 200 || response.getStatusCode() >= 300) {
                    future.completeExceptionally(this.getApiException(Response.status((int)response.getStatusCode()).entity((Object)response.getResponseBody()).build()));
                } else {
                    future.complete(null);
                }
            })).exceptionally(throwable -> {
                future.completeExceptionally(this.getApiException((Throwable)throwable));
                return null;
            });
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public void createFunctionWithUrl(FunctionConfig functionConfig, String pkgUrl) throws PulsarAdminException {
        try {
            this.createFunctionWithUrlAsync(functionConfig, pkgUrl).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            this.handlePulsarAdminException(e);
            throw new PulsarAdminException((Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> createFunctionWithUrlAsync(FunctionConfig functionConfig, String pkgUrl) {
        WebTarget path = this.functions.path(functionConfig.getTenant()).path(functionConfig.getNamespace()).path(functionConfig.getName());
        FormDataMultiPart mp = new FormDataMultiPart();
        mp.bodyPart((BodyPart)new FormDataBodyPart("url", (Object)pkgUrl, MediaType.TEXT_PLAIN_TYPE));
        mp.bodyPart((BodyPart)new FormDataBodyPart("functionConfig", (Object)new Gson().toJson((Object)functionConfig), MediaType.APPLICATION_JSON_TYPE));
        return this.asyncPostRequest(path, Entity.entity((Object)mp, (String)"multipart/form-data"));
    }

    public void deleteFunction(String cluster, String namespace, String function) throws PulsarAdminException {
        try {
            this.deleteFunctionAsync(cluster, namespace, function).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            this.handlePulsarAdminException(e);
            throw new PulsarAdminException((Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> deleteFunctionAsync(String tenant, String namespace, String function) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function);
        return this.asyncDeleteRequest(path);
    }

    public void updateFunction(FunctionConfig functionConfig, String fileName) throws PulsarAdminException {
        this.updateFunction(functionConfig, fileName, null);
    }

    public CompletableFuture<Void> updateFunctionAsync(FunctionConfig functionConfig, String fileName) {
        return this.updateFunctionAsync(functionConfig, fileName, null);
    }

    public void updateFunction(FunctionConfig functionConfig, String fileName, UpdateOptions updateOptions) throws PulsarAdminException {
        try {
            this.updateFunctionAsync(functionConfig, fileName, updateOptions).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            this.handlePulsarAdminException(e);
            throw new PulsarAdminException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> updateFunctionAsync(FunctionConfig functionConfig, String fileName, UpdateOptions updateOptions) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            RequestBuilder builder = (RequestBuilder)Dsl.put((String)this.functions.path(functionConfig.getTenant()).path(functionConfig.getNamespace()).path(functionConfig.getName()).getUri().toASCIIString()).addBodyPart((Part)new StringPart("functionConfig", ObjectMapperFactory.getThreadLocal().writeValueAsString((Object)functionConfig), "application/json"));
            if (updateOptions != null) {
                builder.addBodyPart((Part)new StringPart("updateOptions", ObjectMapperFactory.getThreadLocal().writeValueAsString((Object)updateOptions), "application/json"));
            }
            if (fileName != null && !fileName.startsWith("builtin://")) {
                builder.addBodyPart((Part)new FilePart("data", new File(fileName), "application/octet-stream"));
            }
            ((CompletableFuture)this.asyncHttpClient.executeRequest(this.addAuthHeaders(this.functions, builder).build()).toCompletableFuture().thenAccept(response -> {
                if (response.getStatusCode() < 200 || response.getStatusCode() >= 300) {
                    future.completeExceptionally(this.getApiException(Response.status((int)response.getStatusCode()).entity((Object)response.getResponseBody()).build()));
                } else {
                    future.complete(null);
                }
            })).exceptionally(throwable -> {
                future.completeExceptionally(this.getApiException((Throwable)throwable));
                return null;
            });
        }
        catch (Exception e) {
            future.completeExceptionally(this.getApiException(e));
        }
        return future;
    }

    public void updateFunctionWithUrl(FunctionConfig functionConfig, String pkgUrl, UpdateOptions updateOptions) throws PulsarAdminException {
        try {
            this.updateFunctionWithUrlAsync(functionConfig, pkgUrl, updateOptions).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            this.handlePulsarAdminException(e);
            throw new PulsarAdminException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> updateFunctionWithUrlAsync(FunctionConfig functionConfig, String pkgUrl, UpdateOptions updateOptions) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            FormDataMultiPart mp = new FormDataMultiPart();
            mp.bodyPart((BodyPart)new FormDataBodyPart("url", (Object)pkgUrl, MediaType.TEXT_PLAIN_TYPE));
            mp.bodyPart((BodyPart)new FormDataBodyPart("functionConfig", (Object)ObjectMapperFactory.getThreadLocal().writeValueAsString((Object)functionConfig), MediaType.APPLICATION_JSON_TYPE));
            if (updateOptions != null) {
                mp.bodyPart((BodyPart)new FormDataBodyPart("updateOptions", (Object)ObjectMapperFactory.getThreadLocal().writeValueAsString((Object)updateOptions), MediaType.APPLICATION_JSON_TYPE));
            }
            WebTarget path = this.functions.path(functionConfig.getTenant()).path(functionConfig.getNamespace()).path(functionConfig.getName());
            return this.asyncPutRequest(path, Entity.entity((Object)mp, (String)"multipart/form-data"));
        }
        catch (Exception e) {
            future.completeExceptionally(this.getApiException(e));
            return future;
        }
    }

    public void updateFunctionWithUrl(FunctionConfig functionConfig, String pkgUrl) throws PulsarAdminException {
        this.updateFunctionWithUrl(functionConfig, pkgUrl, null);
    }

    public CompletableFuture<Void> updateFunctionWithUrlAsync(FunctionConfig functionConfig, String pkgUrl) {
        return this.updateFunctionWithUrlAsync(functionConfig, pkgUrl, null);
    }

    public String triggerFunction(String tenant, String namespace, String functionName, String topic, String triggerValue, String triggerFile) throws PulsarAdminException {
        try {
            return this.triggerFunctionAsync(tenant, namespace, functionName, topic, triggerValue, triggerFile).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            this.handlePulsarAdminException(e);
            throw new PulsarAdminException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    private void handlePulsarAdminException(ExecutionException e) throws PulsarAdminException {
        if (e.getCause() instanceof PulsarAdminException) {
            throw (PulsarAdminException)e.getCause();
        }
    }

    public CompletableFuture<String> triggerFunctionAsync(String tenant, String namespace, String function, String topic, String triggerValue, String triggerFile) {
        FormDataMultiPart mp = new FormDataMultiPart();
        if (triggerFile != null) {
            mp.bodyPart((BodyPart)new FileDataBodyPart("dataStream", new File(triggerFile), MediaType.APPLICATION_OCTET_STREAM_TYPE));
        }
        if (triggerValue != null) {
            mp.bodyPart((BodyPart)new FormDataBodyPart("data", (Object)triggerValue, MediaType.TEXT_PLAIN_TYPE));
        }
        if (topic != null && !topic.isEmpty()) {
            mp.bodyPart((BodyPart)new FormDataBodyPart("topic", (Object)topic, MediaType.TEXT_PLAIN_TYPE));
        }
        final WebTarget path = this.functions.path(tenant).path(namespace).path(function).path("trigger");
        final CompletableFuture<String> future = new CompletableFuture<String>();
        try {
            this.request(path).async().post(Entity.entity((Object)mp, (String)"multipart/form-data"), (InvocationCallback)new InvocationCallback<String>(){

                public void completed(String response) {
                    future.complete(response);
                }

                public void failed(Throwable throwable) {
                    log.warn("[{}] Failed to perform http post request: {}", (Object)path.getUri(), (Object)throwable.getMessage());
                    future.completeExceptionally(FunctionsImpl.this.getApiException(throwable.getCause()));
                }
            });
        }
        catch (PulsarAdminException cae) {
            future.completeExceptionally(cae);
        }
        return future;
    }

    public void restartFunction(String tenant, String namespace, String functionName, int instanceId) throws PulsarAdminException {
        try {
            this.restartFunctionAsync(tenant, namespace, functionName, instanceId).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            this.handlePulsarAdminException(e);
            throw new PulsarAdminException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> restartFunctionAsync(String tenant, String namespace, String function, int instanceId) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function).path(Integer.toString(instanceId)).path("restart");
        return this.asyncPostRequest(path, Entity.entity((Object)"", (String)"application/json"));
    }

    public void restartFunction(String tenant, String namespace, String functionName) throws PulsarAdminException {
        try {
            this.restartFunctionAsync(tenant, namespace, functionName).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            this.handlePulsarAdminException(e);
            throw new PulsarAdminException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> restartFunctionAsync(String tenant, String namespace, String function) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function).path("restart");
        return this.asyncPostRequest(path, Entity.entity((Object)"", (String)"application/json"));
    }

    public void stopFunction(String tenant, String namespace, String functionName, int instanceId) throws PulsarAdminException {
        try {
            this.stopFunctionAsync(tenant, namespace, functionName, instanceId).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            this.handlePulsarAdminException(e);
            throw new PulsarAdminException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> stopFunctionAsync(String tenant, String namespace, String function, int instanceId) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function).path(Integer.toString(instanceId)).path("stop");
        return this.asyncPostRequest(path, Entity.entity((Object)"", (String)"application/json"));
    }

    public void stopFunction(String tenant, String namespace, String functionName) throws PulsarAdminException {
        try {
            this.stopFunctionAsync(tenant, namespace, functionName).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            this.handlePulsarAdminException(e);
            throw new PulsarAdminException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> stopFunctionAsync(String tenant, String namespace, String function) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function).path("stop");
        return this.asyncPostRequest(path, Entity.entity((Object)"", (String)"application/json"));
    }

    public void startFunction(String tenant, String namespace, String functionName, int instanceId) throws PulsarAdminException {
        try {
            this.startFunctionAsync(tenant, namespace, functionName, instanceId).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            this.handlePulsarAdminException(e);
            throw new PulsarAdminException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> startFunctionAsync(String tenant, String namespace, String function, int instanceId) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function).path(Integer.toString(instanceId)).path("start");
        return this.asyncPostRequest(path, Entity.entity((Object)"", (String)"application/json"));
    }

    public void startFunction(String tenant, String namespace, String functionName) throws PulsarAdminException {
        try {
            this.startFunctionAsync(tenant, namespace, functionName).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            this.handlePulsarAdminException(e);
            throw new PulsarAdminException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> startFunctionAsync(String tenant, String namespace, String function) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function).path("start");
        return this.asyncPostRequest(path, Entity.entity((Object)"", (String)"application/json"));
    }

    public void uploadFunction(String sourceFile, String path) throws PulsarAdminException {
        try {
            this.uploadFunctionAsync(sourceFile, path).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            this.handlePulsarAdminException(e);
            throw new PulsarAdminException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> uploadFunctionAsync(String sourceFile, String path) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            RequestBuilder builder = (RequestBuilder)((RequestBuilder)Dsl.post((String)this.functions.path("upload").getUri().toASCIIString()).addBodyPart((Part)new FilePart("data", new File(sourceFile), "application/octet-stream"))).addBodyPart((Part)new StringPart("path", path, "text/plain"));
            ((CompletableFuture)this.asyncHttpClient.executeRequest(this.addAuthHeaders(this.functions, builder).build()).toCompletableFuture().thenAccept(response -> {
                if (response.getStatusCode() < 200 || response.getStatusCode() >= 300) {
                    future.completeExceptionally(this.getApiException(Response.status((int)response.getStatusCode()).entity((Object)response.getResponseBody()).build()));
                } else {
                    future.complete(null);
                }
            })).exceptionally(throwable -> {
                future.completeExceptionally(this.getApiException((Throwable)throwable));
                return null;
            });
        }
        catch (Exception e) {
            future.completeExceptionally(this.getApiException(e));
        }
        return future;
    }

    public void downloadFunction(String destinationPath, String tenant, String namespace, String functionName) throws PulsarAdminException {
        this.downloadFile(destinationPath, this.functions.path(tenant).path(namespace).path(functionName).path("download"));
    }

    public CompletableFuture<Void> downloadFunctionAsync(String destinationPath, String tenant, String namespace, String functionName) {
        return this.downloadFileAsync(destinationPath, this.functions.path(tenant).path(namespace).path(functionName).path("download"));
    }

    public void downloadFunction(String destinationPath, String path) throws PulsarAdminException {
        this.downloadFile(destinationPath, this.functions.path("download").queryParam("path", new Object[]{path}));
    }

    public CompletableFuture<Void> downloadFunctionAsync(String destinationFile, String path) {
        return this.downloadFileAsync(destinationFile, this.functions.path("download").queryParam("path", new Object[]{path}));
    }

    private void downloadFile(String destinationPath, WebTarget target) throws PulsarAdminException {
        try {
            this.downloadFileAsync(destinationPath, target).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            this.handlePulsarAdminException(e);
            throw new PulsarAdminException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    private CompletableFuture<Void> downloadFileAsync(String destinationPath, WebTarget target) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            File file = new File(destinationPath);
            if (!file.exists()) {
                if (file.getParentFile() != null && !file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                file.createNewFile();
            }
            final FileChannel os = new FileOutputStream(new File(destinationPath)).getChannel();
            RequestBuilder builder = Dsl.get((String)target.getUri().toASCIIString());
            CompletableFuture statusFuture = this.asyncHttpClient.executeRequest(this.addAuthHeaders(this.functions, builder).build(), (AsyncHandler)new AsyncHandler<HttpResponseStatus>(){
                private HttpResponseStatus status;

                public AsyncHandler.State onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
                    this.status = responseStatus;
                    if (this.status.getStatusCode() != Response.Status.OK.getStatusCode()) {
                        return AsyncHandler.State.ABORT;
                    }
                    return AsyncHandler.State.CONTINUE;
                }

                public AsyncHandler.State onHeadersReceived(HttpHeaders headers) throws Exception {
                    return AsyncHandler.State.CONTINUE;
                }

                public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
                    os.write(bodyPart.getBodyByteBuffer());
                    return AsyncHandler.State.CONTINUE;
                }

                public HttpResponseStatus onCompleted() throws Exception {
                    return this.status;
                }

                public void onThrowable(Throwable t) {
                }
            }).toCompletableFuture();
            ((CompletableFuture)statusFuture.thenAccept(status -> {
                try {
                    os.close();
                }
                catch (Exception e) {
                    future.completeExceptionally(this.getApiException(e));
                    return;
                }
                if (status.getStatusCode() < 200 || status.getStatusCode() >= 300) {
                    future.completeExceptionally(this.getApiException(Response.status((int)status.getStatusCode()).entity((Object)status.getStatusText()).build()));
                } else {
                    future.complete(null);
                }
            })).exceptionally(throwable -> {
                future.completeExceptionally(this.getApiException((Throwable)throwable));
                return null;
            });
        }
        catch (Exception e) {
            future.completeExceptionally(this.getApiException(e));
        }
        return future;
    }

    public List<ConnectorDefinition> getConnectorsList() throws PulsarAdminException {
        try {
            Response response = this.request(this.functions.path("connectors")).get();
            if (!response.getStatusInfo().equals(Response.Status.OK)) {
                throw this.getApiException(response);
            }
            return (List)response.readEntity((GenericType)new GenericType<List<ConnectorDefinition>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    public Set<String> getSources() throws PulsarAdminException {
        return this.getConnectorsList().stream().filter(c -> !StringUtils.isEmpty((CharSequence)c.getSourceClass())).map(ConnectorDefinition::getName).collect(Collectors.toSet());
    }

    public Set<String> getSinks() throws PulsarAdminException {
        return this.getConnectorsList().stream().filter(c -> !StringUtils.isEmpty((CharSequence)c.getSinkClass())).map(ConnectorDefinition::getName).collect(Collectors.toSet());
    }

    public List<WorkerInfo> getCluster() throws PulsarAdminException {
        try {
            return (List)this.request(this.functions.path("cluster")).get((GenericType)new GenericType<List<WorkerInfo>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    public FunctionState getFunctionState(String tenant, String namespace, String function, String key) throws PulsarAdminException {
        try {
            return this.getFunctionStateAsync(tenant, namespace, function, key).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            this.handlePulsarAdminException(e);
            throw new PulsarAdminException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<FunctionState> getFunctionStateAsync(String tenant, String namespace, String function, String key) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function).path("state").path(key);
        final CompletableFuture<FunctionState> future = new CompletableFuture<FunctionState>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            public void completed(Response response) {
                if (!response.getStatusInfo().equals(Response.Status.OK)) {
                    future.completeExceptionally(FunctionsImpl.this.getApiException(response));
                } else {
                    future.complete(response.readEntity(FunctionState.class));
                }
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(FunctionsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void putFunctionState(String tenant, String namespace, String function, FunctionState state) throws PulsarAdminException {
        try {
            this.putFunctionStateAsync(tenant, namespace, function, state).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            this.handlePulsarAdminException(e);
            throw new PulsarAdminException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> putFunctionStateAsync(String tenant, String namespace, String function, FunctionState state) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            RequestBuilder builder = Dsl.post((String)this.functions.path(tenant).path(namespace).path(function).path("state").path(state.getKey()).getUri().toASCIIString());
            builder.addBodyPart((Part)new StringPart("state", ObjectMapperFactory.getThreadLocal().writeValueAsString((Object)state), "application/json"));
            ((CompletableFuture)this.asyncHttpClient.executeRequest(this.addAuthHeaders(this.functions, builder).build()).toCompletableFuture().thenAccept(response -> {
                if (response.getStatusCode() < 200 || response.getStatusCode() >= 300) {
                    future.completeExceptionally(this.getApiException(Response.status((int)response.getStatusCode()).entity((Object)response.getResponseBody()).build()));
                } else {
                    future.complete(null);
                }
            })).exceptionally(throwable -> {
                future.completeExceptionally(this.getApiException((Throwable)throwable));
                return null;
            });
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public void updateOnWorkerLeader(String tenant, String namespace, String function, byte[] functionMetaData, boolean delete) throws PulsarAdminException {
        try {
            this.updateOnWorkerLeaderAsync(tenant, namespace, function, functionMetaData, delete).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            this.handlePulsarAdminException(e);
            throw new PulsarAdminException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> updateOnWorkerLeaderAsync(String tenant, String namespace, String function, byte[] functionMetaData, boolean delete) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            RequestBuilder builder = (RequestBuilder)((RequestBuilder)Dsl.put((String)this.functions.path("leader").path(tenant).path(namespace).path(function).getUri().toASCIIString()).addBodyPart((Part)new ByteArrayPart("functionMetaData", functionMetaData))).addBodyPart((Part)new StringPart("delete", Boolean.toString(delete)));
            ((CompletableFuture)this.asyncHttpClient.executeRequest(this.addAuthHeaders(this.functions, builder).build()).toCompletableFuture().thenAccept(response -> {
                if (response.getStatusCode() < 200 || response.getStatusCode() >= 300) {
                    future.completeExceptionally(this.getApiException(Response.status((int)response.getStatusCode()).entity((Object)response.getResponseBody()).build()));
                } else {
                    future.complete(null);
                }
            })).exceptionally(throwable -> {
                future.completeExceptionally(this.getApiException((Throwable)throwable));
                return null;
            });
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }
}

