/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.TopicPolicies;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.admin.internal.WebTargets;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.DelayedDeliveryPolicies;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.policies.data.ErrorData;
import org.apache.pulsar.common.policies.data.InactiveTopicPolicies;
import org.apache.pulsar.common.policies.data.OffloadPolicies;
import org.apache.pulsar.common.policies.data.OffloadPoliciesImpl;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SubscribeRate;

public class TopicPoliciesImpl
extends BaseResource
implements TopicPolicies {
    private final WebTarget adminTopics;
    private final WebTarget adminV2Topics;
    private final boolean isGlobal;

    protected TopicPoliciesImpl(WebTarget web, Authentication auth, long readTimeoutMs, boolean isGlobal) {
        super(auth, readTimeoutMs);
        this.adminTopics = web.path("/admin");
        this.adminV2Topics = web.path("/admin/v2");
        this.isGlobal = isGlobal;
    }

    public WebTarget addGlobalIfNeeded(WebTarget path) {
        return this.isGlobal ? path.queryParam("isGlobal", new Object[]{true}) : path;
    }

    public Map<BacklogQuota.BacklogQuotaType, BacklogQuota> getBacklogQuotaMap(String topic) throws PulsarAdminException {
        return this.getBacklogQuotaMap(topic, false);
    }

    public Map<BacklogQuota.BacklogQuotaType, BacklogQuota> getBacklogQuotaMap(String topic, boolean applied) throws PulsarAdminException {
        try {
            TopicName tn = this.validateTopic(topic);
            WebTarget path = this.topicPath(tn, "backlogQuotaMap");
            path = path.queryParam("applied", new Object[]{applied});
            return (Map)this.request(path).get((GenericType)new GenericType<Map<BacklogQuota.BacklogQuotaType, BacklogQuota>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    public void setBacklogQuota(String topic, BacklogQuota backlogQuota, BacklogQuota.BacklogQuotaType backlogQuotaType) throws PulsarAdminException {
        try {
            TopicName tn = this.validateTopic(topic);
            WebTarget path = this.topicPath(tn, "backlogQuota");
            this.request(path.queryParam("backlogQuotaType", new Object[]{backlogQuotaType.toString()})).post(Entity.entity((Object)backlogQuota, (String)"application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    public void removeBacklogQuota(String topic, BacklogQuota.BacklogQuotaType backlogQuotaType) throws PulsarAdminException {
        try {
            TopicName tn = this.validateTopic(topic);
            WebTarget path = this.topicPath(tn, "backlogQuota");
            this.request(path.queryParam("backlogQuotaType", new Object[]{backlogQuotaType.toString()})).delete(ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    public Integer getMaxUnackedMessagesOnConsumer(String topic) throws PulsarAdminException {
        return this.getMaxUnackedMessagesOnConsumer(topic, false);
    }

    public CompletableFuture<Integer> getMaxUnackedMessagesOnConsumerAsync(String topic) {
        return this.getMaxUnackedMessagesOnConsumerAsync(topic, false);
    }

    public Integer getMaxUnackedMessagesOnConsumer(String topic, boolean applied) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getMaxUnackedMessagesOnConsumerAsync(topic, applied));
    }

    public CompletableFuture<Integer> getMaxUnackedMessagesOnConsumerAsync(String topic, boolean applied) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "maxUnackedMessagesOnConsumer");
        path = path.queryParam("applied", new Object[]{applied});
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            public void completed(Integer maxNum) {
                future.complete(maxNum);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public CompletableFuture<Void> setMaxUnackedMessagesOnConsumerAsync(String topic, int maxNum) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "maxUnackedMessagesOnConsumer");
        return this.asyncPostRequest(path, Entity.entity((Object)maxNum, (String)"application/json"));
    }

    public void setMaxUnackedMessagesOnConsumer(String topic, int maxNum) throws PulsarAdminException {
        this.sync(() -> this.setMaxUnackedMessagesOnConsumerAsync(topic, maxNum));
    }

    public CompletableFuture<Void> removeMaxUnackedMessagesOnConsumerAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "maxUnackedMessagesOnConsumer");
        return this.asyncDeleteRequest(path);
    }

    public void removeMaxUnackedMessagesOnConsumer(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeMaxUnackedMessagesOnConsumerAsync(topic));
    }

    public InactiveTopicPolicies getInactiveTopicPolicies(String topic, boolean applied) throws PulsarAdminException {
        return (InactiveTopicPolicies)this.sync(() -> this.getInactiveTopicPoliciesAsync(topic, applied));
    }

    public CompletableFuture<InactiveTopicPolicies> getInactiveTopicPoliciesAsync(String topic, boolean applied) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "inactiveTopicPolicies");
        path = path.queryParam("applied", new Object[]{applied});
        final CompletableFuture<InactiveTopicPolicies> future = new CompletableFuture<InactiveTopicPolicies>();
        this.asyncGetRequest(path, new InvocationCallback<InactiveTopicPolicies>(){

            public void completed(InactiveTopicPolicies inactiveTopicPolicies) {
                future.complete(inactiveTopicPolicies);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public InactiveTopicPolicies getInactiveTopicPolicies(String topic) throws PulsarAdminException {
        return this.getInactiveTopicPolicies(topic, false);
    }

    public CompletableFuture<InactiveTopicPolicies> getInactiveTopicPoliciesAsync(String topic) {
        return this.getInactiveTopicPoliciesAsync(topic, false);
    }

    public CompletableFuture<Void> setInactiveTopicPoliciesAsync(String topic, InactiveTopicPolicies inactiveTopicPolicies) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "inactiveTopicPolicies");
        return this.asyncPostRequest(path, Entity.entity((Object)inactiveTopicPolicies, (String)"application/json"));
    }

    public void setInactiveTopicPolicies(String topic, InactiveTopicPolicies inactiveTopicPolicies) throws PulsarAdminException {
        this.sync(() -> this.setInactiveTopicPoliciesAsync(topic, inactiveTopicPolicies));
    }

    public CompletableFuture<Void> removeInactiveTopicPoliciesAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "inactiveTopicPolicies");
        return this.asyncDeleteRequest(path);
    }

    public void removeInactiveTopicPolicies(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeInactiveTopicPoliciesAsync(topic));
    }

    public DelayedDeliveryPolicies getDelayedDeliveryPolicy(String topic, boolean applied) throws PulsarAdminException {
        return (DelayedDeliveryPolicies)this.sync(() -> this.getDelayedDeliveryPolicyAsync(topic, applied));
    }

    public CompletableFuture<DelayedDeliveryPolicies> getDelayedDeliveryPolicyAsync(String topic, boolean applied) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "delayedDelivery");
        path = path.queryParam("applied", new Object[]{applied});
        final CompletableFuture<DelayedDeliveryPolicies> future = new CompletableFuture<DelayedDeliveryPolicies>();
        this.asyncGetRequest(path, new InvocationCallback<DelayedDeliveryPolicies>(){

            public void completed(DelayedDeliveryPolicies delayedDeliveryPolicies) {
                future.complete(delayedDeliveryPolicies);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public DelayedDeliveryPolicies getDelayedDeliveryPolicy(String topic) throws PulsarAdminException {
        return this.getDelayedDeliveryPolicy(topic, false);
    }

    public CompletableFuture<DelayedDeliveryPolicies> getDelayedDeliveryPolicyAsync(String topic) {
        return this.getDelayedDeliveryPolicyAsync(topic, false);
    }

    public CompletableFuture<Void> removeDelayedDeliveryPolicyAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "delayedDelivery");
        return this.asyncDeleteRequest(path);
    }

    public void removeDelayedDeliveryPolicy(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeDelayedDeliveryPolicyAsync(topic));
    }

    public CompletableFuture<Void> setDelayedDeliveryPolicyAsync(String topic, DelayedDeliveryPolicies delayedDeliveryPolicies) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "delayedDelivery");
        return this.asyncPostRequest(path, Entity.entity((Object)delayedDeliveryPolicies, (String)"application/json"));
    }

    public void setDelayedDeliveryPolicy(String topic, DelayedDeliveryPolicies delayedDeliveryPolicies) throws PulsarAdminException {
        this.sync(() -> this.setDelayedDeliveryPolicyAsync(topic, delayedDeliveryPolicies));
    }

    public Boolean getDeduplicationStatus(String topic) throws PulsarAdminException {
        return this.getDeduplicationStatus(topic, false);
    }

    public CompletableFuture<Boolean> getDeduplicationStatusAsync(String topic) {
        return this.getDeduplicationStatusAsync(topic, false);
    }

    public Boolean getDeduplicationStatus(String topic, boolean applied) throws PulsarAdminException {
        return (Boolean)this.sync(() -> this.getDeduplicationStatusAsync(topic, applied));
    }

    public CompletableFuture<Boolean> getDeduplicationStatusAsync(String topic, boolean applied) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "deduplicationEnabled");
        path = path.queryParam("applied", new Object[]{applied});
        final CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.asyncGetRequest(path, new InvocationCallback<Boolean>(){

            public void completed(Boolean enabled) {
                future.complete(enabled);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    private CompletableFuture<Void> enableDeduplicationAsync(String topic, boolean enabled) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "deduplicationEnabled");
        return this.asyncPostRequest(path, Entity.entity((Object)enabled, (String)"application/json"));
    }

    public void setDeduplicationStatus(String topic, boolean enabled) throws PulsarAdminException {
        this.sync(() -> this.enableDeduplicationAsync(topic, enabled));
    }

    public CompletableFuture<Void> setDeduplicationStatusAsync(String topic, boolean enabled) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "deduplicationEnabled");
        return this.asyncPostRequest(path, Entity.entity((Object)enabled, (String)"application/json"));
    }

    public void removeDeduplicationStatus(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeDeduplicationStatusAsync(topic));
    }

    public CompletableFuture<Void> removeDeduplicationStatusAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "deduplicationEnabled");
        return this.asyncDeleteRequest(path);
    }

    public OffloadPolicies getOffloadPolicies(String topic) throws PulsarAdminException {
        return this.getOffloadPolicies(topic, false);
    }

    public CompletableFuture<OffloadPolicies> getOffloadPoliciesAsync(String topic) {
        return this.getOffloadPoliciesAsync(topic, false);
    }

    public OffloadPolicies getOffloadPolicies(String topic, boolean applied) throws PulsarAdminException {
        return (OffloadPolicies)this.sync(() -> this.getOffloadPoliciesAsync(topic, applied));
    }

    public CompletableFuture<OffloadPolicies> getOffloadPoliciesAsync(String topic, boolean applied) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "offloadPolicies");
        path = path.queryParam("applied", new Object[]{applied});
        final CompletableFuture<OffloadPolicies> future = new CompletableFuture<OffloadPolicies>();
        this.asyncGetRequest(path, new InvocationCallback<OffloadPoliciesImpl>(){

            public void completed(OffloadPoliciesImpl offloadPolicies) {
                future.complete(offloadPolicies);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setOffloadPolicies(String topic, OffloadPolicies offloadPolicies) throws PulsarAdminException {
        this.sync(() -> this.setOffloadPoliciesAsync(topic, offloadPolicies));
    }

    public CompletableFuture<Void> setOffloadPoliciesAsync(String topic, OffloadPolicies offloadPolicies) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "offloadPolicies");
        return this.asyncPostRequest(path, Entity.entity((Object)((OffloadPoliciesImpl)offloadPolicies), (String)"application/json"));
    }

    public void removeOffloadPolicies(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeOffloadPoliciesAsync(topic));
    }

    public CompletableFuture<Void> removeOffloadPoliciesAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "offloadPolicies");
        return this.asyncDeleteRequest(path);
    }

    public Integer getMaxUnackedMessagesOnSubscription(String topic) throws PulsarAdminException {
        return this.getMaxUnackedMessagesOnSubscription(topic, false);
    }

    public CompletableFuture<Integer> getMaxUnackedMessagesOnSubscriptionAsync(String topic) {
        return this.getMaxUnackedMessagesOnSubscriptionAsync(topic, false);
    }

    public Integer getMaxUnackedMessagesOnSubscription(String topic, boolean applied) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getMaxUnackedMessagesOnSubscriptionAsync(topic, applied));
    }

    public CompletableFuture<Integer> getMaxUnackedMessagesOnSubscriptionAsync(String topic, boolean applied) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "maxUnackedMessagesOnSubscription");
        path = path.queryParam("applied", new Object[]{applied});
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            public void completed(Integer maxNum) {
                future.complete(maxNum);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setMaxUnackedMessagesOnSubscription(String topic, int maxNum) throws PulsarAdminException {
        this.sync(() -> this.setMaxUnackedMessagesOnSubscriptionAsync(topic, maxNum));
    }

    public CompletableFuture<Void> setMaxUnackedMessagesOnSubscriptionAsync(String topic, int maxNum) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "maxUnackedMessagesOnSubscription");
        return this.asyncPostRequest(path, Entity.entity((Object)maxNum, (String)"application/json"));
    }

    public void removeMaxUnackedMessagesOnSubscription(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeMaxUnackedMessagesOnSubscriptionAsync(topic));
    }

    public CompletableFuture<Void> removeMaxUnackedMessagesOnSubscriptionAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "maxUnackedMessagesOnSubscription");
        return this.asyncDeleteRequest(path);
    }

    public void setMessageTTL(String topic, int messageTTLInSecond) throws PulsarAdminException {
        try {
            TopicName topicName = this.validateTopic(topic);
            WebTarget path = this.topicPath(topicName, "messageTTL");
            this.request(path.queryParam("messageTTL", new Object[]{messageTTLInSecond})).post(Entity.entity((Object)"", (String)"application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    public Integer getMessageTTL(String topic) throws PulsarAdminException {
        return this.getMessageTTL(topic, false);
    }

    public Integer getMessageTTL(String topic, boolean applied) throws PulsarAdminException {
        try {
            TopicName topicName = this.validateTopic(topic);
            WebTarget path = this.topicPath(topicName, "messageTTL");
            path = path.queryParam("applied", new Object[]{applied});
            return (Integer)this.request(path).get((GenericType)new GenericType<Integer>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    public void removeMessageTTL(String topic) throws PulsarAdminException {
        try {
            TopicName topicName = this.validateTopic(topic);
            WebTarget path = this.topicPath(topicName, "messageTTL");
            this.request(path.queryParam("messageTTL", new Object[]{0})).delete(ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    public void setRetention(String topic, RetentionPolicies retention) throws PulsarAdminException {
        this.sync(() -> this.setRetentionAsync(topic, retention));
    }

    public CompletableFuture<Void> setRetentionAsync(String topic, RetentionPolicies retention) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "retention");
        return this.asyncPostRequest(path, Entity.entity((Object)retention, (String)"application/json"));
    }

    public RetentionPolicies getRetention(String topic) throws PulsarAdminException {
        return this.getRetention(topic, false);
    }

    public CompletableFuture<RetentionPolicies> getRetentionAsync(String topic) {
        return this.getRetentionAsync(topic, false);
    }

    public RetentionPolicies getRetention(String topic, boolean applied) throws PulsarAdminException {
        return (RetentionPolicies)this.sync(() -> this.getRetentionAsync(topic, applied));
    }

    public CompletableFuture<RetentionPolicies> getRetentionAsync(String topic, boolean applied) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "retention");
        path = path.queryParam("applied", new Object[]{applied});
        final CompletableFuture<RetentionPolicies> future = new CompletableFuture<RetentionPolicies>();
        this.asyncGetRequest(path, new InvocationCallback<RetentionPolicies>(){

            public void completed(RetentionPolicies retentionPolicies) {
                future.complete(retentionPolicies);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void removeRetention(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeRetentionAsync(topic));
    }

    public CompletableFuture<Void> removeRetentionAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "retention");
        return this.asyncDeleteRequest(path);
    }

    public void setPersistence(String topic, PersistencePolicies persistencePolicies) throws PulsarAdminException {
        this.sync(() -> this.setPersistenceAsync(topic, persistencePolicies));
    }

    public CompletableFuture<Void> setPersistenceAsync(String topic, PersistencePolicies persistencePolicies) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "persistence");
        return this.asyncPostRequest(path, Entity.entity((Object)persistencePolicies, (String)"application/json"));
    }

    public PersistencePolicies getPersistence(String topic) throws PulsarAdminException {
        return this.getPersistence(topic, false);
    }

    public CompletableFuture<PersistencePolicies> getPersistenceAsync(String topic) {
        return this.getPersistenceAsync(topic, false);
    }

    public PersistencePolicies getPersistence(String topic, boolean applied) throws PulsarAdminException {
        return (PersistencePolicies)this.sync(() -> this.getPersistenceAsync(topic, applied));
    }

    public CompletableFuture<PersistencePolicies> getPersistenceAsync(String topic, boolean applied) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "persistence");
        path = path.queryParam("applied", new Object[]{applied});
        final CompletableFuture<PersistencePolicies> future = new CompletableFuture<PersistencePolicies>();
        this.asyncGetRequest(path, new InvocationCallback<PersistencePolicies>(){

            public void completed(PersistencePolicies persistencePolicies) {
                future.complete(persistencePolicies);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void removePersistence(String topic) throws PulsarAdminException {
        this.sync(() -> this.removePersistenceAsync(topic));
    }

    public CompletableFuture<Void> removePersistenceAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "persistence");
        return this.asyncDeleteRequest(path);
    }

    public DispatchRate getDispatchRate(String topic, boolean applied) throws PulsarAdminException {
        return (DispatchRate)this.sync(() -> this.getDispatchRateAsync(topic, applied));
    }

    public CompletableFuture<DispatchRate> getDispatchRateAsync(String topic, boolean applied) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "dispatchRate");
        path = path.queryParam("applied", new Object[]{applied});
        final CompletableFuture<DispatchRate> future = new CompletableFuture<DispatchRate>();
        this.asyncGetRequest(path, new InvocationCallback<DispatchRate>(){

            public void completed(DispatchRate dispatchRate) {
                future.complete(dispatchRate);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public DispatchRate getDispatchRate(String topic) throws PulsarAdminException {
        return this.getDispatchRate(topic, false);
    }

    public CompletableFuture<DispatchRate> getDispatchRateAsync(String topic) {
        return this.getDispatchRateAsync(topic, false);
    }

    public void setDispatchRate(String topic, DispatchRate dispatchRate) throws PulsarAdminException {
        this.sync(() -> this.setDispatchRateAsync(topic, dispatchRate));
    }

    public CompletableFuture<Void> setDispatchRateAsync(String topic, DispatchRate dispatchRate) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "dispatchRate");
        return this.asyncPostRequest(path, Entity.entity((Object)dispatchRate, (String)"application/json"));
    }

    public void removeDispatchRate(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeDispatchRateAsync(topic));
    }

    public CompletableFuture<Void> removeDispatchRateAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "dispatchRate");
        return this.asyncDeleteRequest(path);
    }

    public DispatchRate getSubscriptionDispatchRate(String topic, boolean applied) throws PulsarAdminException {
        return (DispatchRate)this.sync(() -> this.getSubscriptionDispatchRateAsync(topic, applied));
    }

    public CompletableFuture<DispatchRate> getSubscriptionDispatchRateAsync(String topic, boolean applied) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "subscriptionDispatchRate");
        path = path.queryParam("applied", new Object[]{applied});
        final CompletableFuture<DispatchRate> future = new CompletableFuture<DispatchRate>();
        this.asyncGetRequest(path, new InvocationCallback<DispatchRate>(){

            public void completed(DispatchRate dispatchRate) {
                future.complete(dispatchRate);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public DispatchRate getSubscriptionDispatchRate(String topic) throws PulsarAdminException {
        return this.getSubscriptionDispatchRate(topic, false);
    }

    public CompletableFuture<DispatchRate> getSubscriptionDispatchRateAsync(String topic) {
        return this.getSubscriptionDispatchRateAsync(topic, false);
    }

    public void setSubscriptionDispatchRate(String topic, DispatchRate dispatchRate) throws PulsarAdminException {
        this.sync(() -> this.setSubscriptionDispatchRateAsync(topic, dispatchRate));
    }

    public CompletableFuture<Void> setSubscriptionDispatchRateAsync(String topic, DispatchRate dispatchRate) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "subscriptionDispatchRate");
        return this.asyncPostRequest(path, Entity.entity((Object)dispatchRate, (String)"application/json"));
    }

    public void removeSubscriptionDispatchRate(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeSubscriptionDispatchRateAsync(topic));
    }

    public CompletableFuture<Void> removeSubscriptionDispatchRateAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "subscriptionDispatchRate");
        return this.asyncDeleteRequest(path);
    }

    public void setSubscriptionDispatchRate(String topic, String subscriptionName, DispatchRate dispatchRate) throws PulsarAdminException {
        this.sync(() -> this.setSubscriptionDispatchRateAsync(topic, subscriptionName, dispatchRate));
    }

    public CompletableFuture<Void> setSubscriptionDispatchRateAsync(String topic, String subscriptionName, DispatchRate dispatchRate) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, subscriptionName, "dispatchRate");
        return this.asyncPostRequest(path, Entity.entity((Object)dispatchRate, (String)"application/json"));
    }

    public DispatchRate getSubscriptionDispatchRate(String topic, String subscriptionName, boolean applied) throws PulsarAdminException {
        return (DispatchRate)this.sync(() -> this.getSubscriptionDispatchRateAsync(topic, subscriptionName, applied));
    }

    public CompletableFuture<DispatchRate> getSubscriptionDispatchRateAsync(String topic, String subscriptionName, boolean applied) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, subscriptionName, "dispatchRate");
        path = path.queryParam("applied", new Object[]{applied});
        final CompletableFuture<DispatchRate> future = new CompletableFuture<DispatchRate>();
        this.asyncGetRequest(path, new InvocationCallback<DispatchRate>(){

            public void completed(DispatchRate dispatchRate) {
                future.complete(dispatchRate);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public DispatchRate getSubscriptionDispatchRate(String topic, String subscriptionName) throws PulsarAdminException {
        return (DispatchRate)this.sync(() -> this.getSubscriptionDispatchRateAsync(topic, subscriptionName));
    }

    public CompletableFuture<DispatchRate> getSubscriptionDispatchRateAsync(String topic, String subscriptionName) {
        return this.getSubscriptionDispatchRateAsync(topic, subscriptionName, false);
    }

    public void removeSubscriptionDispatchRate(String topic, String subscriptionName) throws PulsarAdminException {
        this.sync(() -> this.removeSubscriptionDispatchRateAsync(topic, subscriptionName));
    }

    public CompletableFuture<Void> removeSubscriptionDispatchRateAsync(String topic, String subscriptionName) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, subscriptionName, "dispatchRate");
        return this.asyncDeleteRequest(path);
    }

    public Long getCompactionThreshold(String topic) throws PulsarAdminException {
        return this.getCompactionThreshold(topic, false);
    }

    public CompletableFuture<Long> getCompactionThresholdAsync(String topic) {
        return this.getCompactionThresholdAsync(topic, false);
    }

    public Long getCompactionThreshold(String topic, boolean applied) throws PulsarAdminException {
        return (Long)this.sync(() -> this.getCompactionThresholdAsync(topic, applied));
    }

    public CompletableFuture<Long> getCompactionThresholdAsync(String topic, boolean applied) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "compactionThreshold");
        path = path.queryParam("applied", new Object[]{applied});
        final CompletableFuture<Long> future = new CompletableFuture<Long>();
        this.asyncGetRequest(path, new InvocationCallback<Long>(){

            public void completed(Long compactionThreshold) {
                future.complete(compactionThreshold);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setCompactionThreshold(String topic, long compactionThreshold) throws PulsarAdminException {
        this.sync(() -> this.setCompactionThresholdAsync(topic, compactionThreshold));
    }

    public CompletableFuture<Void> setCompactionThresholdAsync(String topic, long compactionThreshold) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "compactionThreshold");
        return this.asyncPostRequest(path, Entity.entity((Object)compactionThreshold, (String)"application/json"));
    }

    public void removeCompactionThreshold(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeCompactionThresholdAsync(topic));
    }

    public CompletableFuture<Void> removeCompactionThresholdAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "compactionThreshold");
        return this.asyncDeleteRequest(path);
    }

    public PublishRate getPublishRate(String topic) throws PulsarAdminException {
        return (PublishRate)this.sync(() -> this.getPublishRateAsync(topic));
    }

    public CompletableFuture<PublishRate> getPublishRateAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "publishRate");
        final CompletableFuture<PublishRate> future = new CompletableFuture<PublishRate>();
        this.asyncGetRequest(path, new InvocationCallback<PublishRate>(){

            public void completed(PublishRate publishRate) {
                future.complete(publishRate);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setPublishRate(String topic, PublishRate publishRate) throws PulsarAdminException {
        this.sync(() -> this.setPublishRateAsync(topic, publishRate));
    }

    public CompletableFuture<Void> setPublishRateAsync(String topic, PublishRate publishRate) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "publishRate");
        return this.asyncPostRequest(path, Entity.entity((Object)publishRate, (String)"application/json"));
    }

    public void removePublishRate(String topic) throws PulsarAdminException {
        this.sync(() -> this.removePublishRateAsync(topic));
    }

    public CompletableFuture<Void> removePublishRateAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "publishRate");
        return this.asyncDeleteRequest(path);
    }

    public Integer getMaxConsumersPerSubscription(String topic) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getMaxConsumersPerSubscriptionAsync(topic));
    }

    public CompletableFuture<Integer> getMaxConsumersPerSubscriptionAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "maxConsumersPerSubscription");
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            public void completed(Integer maxConsumersPerSubscription) {
                future.complete(maxConsumersPerSubscription);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setMaxConsumersPerSubscription(String topic, int maxConsumersPerSubscription) throws PulsarAdminException {
        this.sync(() -> this.setMaxConsumersPerSubscriptionAsync(topic, maxConsumersPerSubscription));
    }

    public CompletableFuture<Void> setMaxConsumersPerSubscriptionAsync(String topic, int maxConsumersPerSubscription) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "maxConsumersPerSubscription");
        return this.asyncPostRequest(path, Entity.entity((Object)maxConsumersPerSubscription, (String)"application/json"));
    }

    public void removeMaxConsumersPerSubscription(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeMaxConsumersPerSubscriptionAsync(topic));
    }

    public CompletableFuture<Void> removeMaxConsumersPerSubscriptionAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "maxConsumersPerSubscription");
        return this.asyncDeleteRequest(path);
    }

    public Integer getMaxProducers(String topic) throws PulsarAdminException {
        return this.getMaxProducers(topic, false);
    }

    public CompletableFuture<Integer> getMaxProducersAsync(String topic) {
        return this.getMaxProducersAsync(topic, false);
    }

    public Integer getMaxProducers(String topic, boolean applied) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getMaxProducersAsync(topic, applied));
    }

    public CompletableFuture<Integer> getMaxProducersAsync(String topic, boolean applied) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxProducers");
        path = path.queryParam("applied", new Object[]{applied});
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            public void completed(Integer maxProducers) {
                future.complete(maxProducers);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setMaxProducers(String topic, int maxProducers) throws PulsarAdminException {
        this.sync(() -> this.setMaxProducersAsync(topic, maxProducers));
    }

    public CompletableFuture<Void> setMaxProducersAsync(String topic, int maxProducers) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxProducers");
        return this.asyncPostRequest(path, Entity.entity((Object)maxProducers, (String)"application/json"));
    }

    public void removeMaxProducers(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeMaxProducersAsync(topic));
    }

    public CompletableFuture<Void> removeMaxProducersAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxProducers");
        return this.asyncDeleteRequest(path);
    }

    public Integer getMaxSubscriptionsPerTopic(String topic) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getMaxSubscriptionsPerTopicAsync(topic));
    }

    public CompletableFuture<Integer> getMaxSubscriptionsPerTopicAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxSubscriptionsPerTopic");
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            public void completed(Integer maxSubscriptionsPerTopic) {
                future.complete(maxSubscriptionsPerTopic);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setMaxSubscriptionsPerTopic(String topic, int maxSubscriptionsPerTopic) throws PulsarAdminException {
        this.sync(() -> this.setMaxSubscriptionsPerTopicAsync(topic, maxSubscriptionsPerTopic));
    }

    public CompletableFuture<Void> setMaxSubscriptionsPerTopicAsync(String topic, int maxSubscriptionsPerTopic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxSubscriptionsPerTopic");
        return this.asyncPostRequest(path, Entity.entity((Object)maxSubscriptionsPerTopic, (String)"application/json"));
    }

    public void removeMaxSubscriptionsPerTopic(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeMaxSubscriptionsPerTopicAsync(topic));
    }

    public CompletableFuture<Void> removeMaxSubscriptionsPerTopicAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxSubscriptionsPerTopic");
        return this.asyncDeleteRequest(path);
    }

    public Integer getMaxMessageSize(String topic) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getMaxMessageSizeAsync(topic));
    }

    public CompletableFuture<Integer> getMaxMessageSizeAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxMessageSize");
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            public void completed(Integer maxMessageSize) {
                future.complete(maxMessageSize);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setMaxMessageSize(String topic, int maxMessageSize) throws PulsarAdminException {
        this.sync(() -> this.setMaxMessageSizeAsync(topic, maxMessageSize));
    }

    public CompletableFuture<Void> setMaxMessageSizeAsync(String topic, int maxMessageSize) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxMessageSize");
        return this.asyncPostRequest(path, Entity.entity((Object)maxMessageSize, (String)"application/json"));
    }

    public void removeMaxMessageSize(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeMaxMessageSizeAsync(topic));
    }

    public CompletableFuture<Void> removeMaxMessageSizeAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxMessageSize");
        return this.asyncDeleteRequest(path);
    }

    public Integer getMaxConsumers(String topic) throws PulsarAdminException {
        return this.getMaxConsumers(topic, false);
    }

    public CompletableFuture<Integer> getMaxConsumersAsync(String topic) {
        return this.getMaxConsumersAsync(topic, false);
    }

    public Integer getMaxConsumers(String topic, boolean applied) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getMaxConsumersAsync(topic, applied));
    }

    public CompletableFuture<Integer> getMaxConsumersAsync(String topic, boolean applied) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxConsumers");
        path = path.queryParam("applied", new Object[]{applied});
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            public void completed(Integer maxProducers) {
                future.complete(maxProducers);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setMaxConsumers(String topic, int maxConsumers) throws PulsarAdminException {
        this.sync(() -> this.setMaxConsumersAsync(topic, maxConsumers));
    }

    public CompletableFuture<Void> setMaxConsumersAsync(String topic, int maxConsumers) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxConsumers");
        return this.asyncPostRequest(path, Entity.entity((Object)maxConsumers, (String)"application/json"));
    }

    public void removeMaxConsumers(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeMaxConsumersAsync(topic));
    }

    public CompletableFuture<Void> removeMaxConsumersAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxConsumers");
        return this.asyncDeleteRequest(path);
    }

    public Integer getDeduplicationSnapshotInterval(String topic) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getDeduplicationSnapshotIntervalAsync(topic));
    }

    public CompletableFuture<Integer> getDeduplicationSnapshotIntervalAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "deduplicationSnapshotInterval");
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            public void completed(Integer interval) {
                future.complete(interval);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setDeduplicationSnapshotInterval(String topic, int interval) throws PulsarAdminException {
        this.sync(() -> this.setDeduplicationSnapshotIntervalAsync(topic, interval));
    }

    public CompletableFuture<Void> setDeduplicationSnapshotIntervalAsync(String topic, int interval) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "deduplicationSnapshotInterval");
        return this.asyncPostRequest(path, Entity.entity((Object)interval, (String)"application/json"));
    }

    public void removeDeduplicationSnapshotInterval(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeDeduplicationSnapshotIntervalAsync(topic));
    }

    public CompletableFuture<Void> removeDeduplicationSnapshotIntervalAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "deduplicationSnapshotInterval");
        return this.asyncDeleteRequest(path);
    }

    public void setSubscriptionTypesEnabled(String topic, Set<SubscriptionType> subscriptionTypesEnabled) throws PulsarAdminException {
        this.sync(() -> this.setSubscriptionTypesEnabledAsync(topic, subscriptionTypesEnabled));
    }

    public CompletableFuture<Void> setSubscriptionTypesEnabledAsync(String topic, Set<SubscriptionType> subscriptionTypesEnabled) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "subscriptionTypesEnabled");
        return this.asyncPostRequest(path, Entity.entity(subscriptionTypesEnabled, (String)"application/json"));
    }

    public Set<SubscriptionType> getSubscriptionTypesEnabled(String topic) throws PulsarAdminException {
        return (Set)this.sync(() -> this.getSubscriptionTypesEnabledAsync(topic));
    }

    public CompletableFuture<Set<SubscriptionType>> getSubscriptionTypesEnabledAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "subscriptionTypesEnabled");
        final CompletableFuture<Set<SubscriptionType>> future = new CompletableFuture<Set<SubscriptionType>>();
        this.asyncGetRequest(path, new InvocationCallback<Set<SubscriptionType>>(){

            public void completed(Set<SubscriptionType> subscriptionTypesEnabled) {
                future.complete(subscriptionTypesEnabled);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void removeSubscriptionTypesEnabled(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeSubscriptionTypesEnabledAsync(topic));
    }

    public CompletableFuture<Void> removeSubscriptionTypesEnabledAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "subscriptionTypesEnabled");
        return this.asyncDeleteRequest(path);
    }

    public SubscribeRate getSubscribeRate(String topic) throws PulsarAdminException {
        return this.getSubscribeRate(topic, false);
    }

    public CompletableFuture<SubscribeRate> getSubscribeRateAsync(String topic) {
        return this.getSubscribeRateAsync(topic, false);
    }

    public SubscribeRate getSubscribeRate(String topic, boolean applied) throws PulsarAdminException {
        return (SubscribeRate)this.sync(() -> this.getSubscribeRateAsync(topic, applied));
    }

    public CompletableFuture<SubscribeRate> getSubscribeRateAsync(String topic, boolean applied) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "subscribeRate");
        path = path.queryParam("applied", new Object[]{applied});
        final CompletableFuture<SubscribeRate> future = new CompletableFuture<SubscribeRate>();
        this.asyncGetRequest(path, new InvocationCallback<SubscribeRate>(){

            public void completed(SubscribeRate subscribeRate) {
                future.complete(subscribeRate);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setSubscribeRate(String topic, SubscribeRate subscribeRate) throws PulsarAdminException {
        this.sync(() -> this.setSubscribeRateAsync(topic, subscribeRate));
    }

    public CompletableFuture<Void> setSubscribeRateAsync(String topic, SubscribeRate subscribeRate) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "subscribeRate");
        return this.asyncPostRequest(path, Entity.entity((Object)subscribeRate, (String)"application/json"));
    }

    public void removeSubscribeRate(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeSubscribeRateAsync(topic));
    }

    public CompletableFuture<Void> removeSubscribeRateAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "subscribeRate");
        return this.asyncDeleteRequest(path);
    }

    public DispatchRate getReplicatorDispatchRate(String topic) throws PulsarAdminException {
        return this.getReplicatorDispatchRate(topic, false);
    }

    public CompletableFuture<DispatchRate> getReplicatorDispatchRateAsync(String topic) {
        return this.getReplicatorDispatchRateAsync(topic, false);
    }

    public DispatchRate getReplicatorDispatchRate(String topic, boolean applied) throws PulsarAdminException {
        return (DispatchRate)this.sync(() -> this.getReplicatorDispatchRateAsync(topic, applied));
    }

    public CompletableFuture<DispatchRate> getReplicatorDispatchRateAsync(String topic, boolean applied) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "replicatorDispatchRate");
        path = path.queryParam("applied", new Object[]{applied});
        final CompletableFuture<DispatchRate> future = new CompletableFuture<DispatchRate>();
        this.asyncGetRequest(path, new InvocationCallback<DispatchRate>(){

            public void completed(DispatchRate dispatchRate) {
                future.complete(dispatchRate);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setReplicatorDispatchRate(String topic, DispatchRate dispatchRate) throws PulsarAdminException {
        this.sync(() -> this.setReplicatorDispatchRateAsync(topic, dispatchRate));
    }

    public CompletableFuture<Void> setReplicatorDispatchRateAsync(String topic, DispatchRate dispatchRate) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "replicatorDispatchRate");
        return this.asyncPostRequest(path, Entity.entity((Object)dispatchRate, (String)"application/json"));
    }

    public void removeReplicatorDispatchRate(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeReplicatorDispatchRateAsync(topic));
    }

    public CompletableFuture<Void> removeReplicatorDispatchRateAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "replicatorDispatchRate");
        return this.asyncDeleteRequest(path);
    }

    public SchemaCompatibilityStrategy getSchemaCompatibilityStrategy(String topic, boolean applied) throws PulsarAdminException {
        return (SchemaCompatibilityStrategy)this.sync(() -> this.getSchemaCompatibilityStrategyAsync(topic, applied));
    }

    public CompletableFuture<SchemaCompatibilityStrategy> getSchemaCompatibilityStrategyAsync(String topic, boolean applied) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "schemaCompatibilityStrategy");
        path = path.queryParam("applied", new Object[]{applied});
        final CompletableFuture<SchemaCompatibilityStrategy> future = new CompletableFuture<SchemaCompatibilityStrategy>();
        this.asyncGetRequest(path, new InvocationCallback<SchemaCompatibilityStrategy>(){

            public void completed(SchemaCompatibilityStrategy schemaCompatibilityStrategy) {
                future.complete(schemaCompatibilityStrategy);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setSchemaCompatibilityStrategy(String topic, SchemaCompatibilityStrategy strategy) throws PulsarAdminException {
        this.sync(() -> this.setSchemaCompatibilityStrategyAsync(topic, strategy));
    }

    public CompletableFuture<Void> setSchemaCompatibilityStrategyAsync(String topic, SchemaCompatibilityStrategy strategy) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "schemaCompatibilityStrategy");
        return this.asyncPutRequest(path, Entity.entity((Object)strategy, (String)"application/json"));
    }

    public void removeSchemaCompatibilityStrategy(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeSchemaCompatibilityStrategyAsync(topic));
    }

    public CompletableFuture<Void> removeSchemaCompatibilityStrategyAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "schemaCompatibilityStrategy");
        return this.asyncDeleteRequest(path);
    }

    private TopicName validateTopic(String topic) {
        return TopicName.get((String)topic);
    }

    private WebTarget topicPath(TopicName topic, String ... parts) {
        WebTarget base = topic.isV2() ? this.adminV2Topics : this.adminTopics;
        WebTarget topicPath = base.path(topic.getRestPath());
        topicPath = WebTargets.addParts(topicPath, parts);
        topicPath = this.addGlobalIfNeeded(topicPath);
        return topicPath;
    }
}

