/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Parameters(commandDescription="Generate documentation automatically.")
public class CmdGenerateDocs {
    @Parameter(names={"-h", "--help"}, description="Display help information")
    public boolean help;
    @Parameter(names={"-n", "--command-names"}, description="List of command names")
    private List<String> commandNames = new ArrayList<String>();
    private static final String name = "gen-doc";
    private final JCommander jcommander = new JCommander((Object)this);

    public CmdGenerateDocs(String cmdName) {
        this.jcommander.setProgramName(cmdName);
    }

    public CmdGenerateDocs addCommand(String name, Object command) {
        this.jcommander.addCommand(name, command);
        return this;
    }

    public boolean run(String[] args) {
        JCommander tmpCmd = new JCommander((Object)this);
        tmpCmd.setProgramName(this.jcommander.getProgramName() + " " + name);
        try {
            if (args == null) {
                args = new String[]{};
            }
            tmpCmd.parse(args);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.err.println();
            tmpCmd.usage();
            return false;
        }
        if (this.help) {
            tmpCmd.usage();
            return true;
        }
        if (this.commandNames.size() == 0) {
            for (Map.Entry cmd : this.jcommander.getCommands().entrySet()) {
                if (((String)cmd.getKey()).equals(name)) continue;
                System.out.println(this.generateDocument((String)cmd.getKey(), this.jcommander));
            }
        } else {
            for (String commandName : this.commandNames) {
                if (commandName.equals(name) || !this.jcommander.getCommands().keySet().contains(commandName)) continue;
                System.out.println(this.generateDocument(commandName, this.jcommander));
            }
        }
        return true;
    }

    private String generateDocument(String module, JCommander commander) {
        JCommander cmd = (JCommander)commander.getCommands().get(module);
        StringBuilder sb = new StringBuilder();
        sb.append("# ").append(module).append("\n\n");
        String desc = commander.getUsageFormatter().getCommandDescription(module);
        if (null != desc && !desc.isEmpty()) {
            sb.append(desc).append("\n");
        }
        sb.append("\n\n```shell\n").append("$ ");
        if (null != this.jcommander.getProgramName() && !this.jcommander.getProgramName().isEmpty()) {
            sb.append(this.jcommander.getProgramName()).append(" ");
        }
        sb.append(module);
        if (cmd.getObjects().size() > 0 && cmd.getObjects().get(0).getClass().getName().equals("com.beust.jcommander.JCommander")) {
            JCommander cmdObj = (JCommander)cmd.getObjects().get(0);
            sb.append(" subcommand").append("\n```").append("\n\n");
            cmdObj.getCommands().forEach((subK, subV) -> {
                if (!subK.equals(name)) {
                    sb.append("\n\n## <em>").append((String)subK).append("</em>\n\n");
                    String subDesc = cmdObj.getUsageFormatter().getCommandDescription(subK);
                    if (null != subDesc && !subDesc.isEmpty()) {
                        sb.append(subDesc).append("\n");
                    }
                    sb.append("```shell\n$ ");
                    if (null != this.jcommander.getProgramName() && !this.jcommander.getProgramName().isEmpty()) {
                        sb.append(this.jcommander.getProgramName()).append(" ");
                    }
                    sb.append(module).append(" ").append((String)subK).append(" options").append("\n```\n\n");
                    List options = ((JCommander)cmdObj.getCommands().get(subK)).getParameters();
                    if (options.size() > 0) {
                        sb.append("|Flag|Description|Default|\n");
                        sb.append("|---|---|---|\n");
                    }
                    options.forEach(option -> sb.append("| `").append(option.getNames()).append("` | ").append(option.getDescription().replace("\n", " ")).append("|").append(option.getDefault()).append("|\n"));
                }
            });
        } else {
            sb.append(" options").append("\n```").append("\n\n");
            sb.append("|Flag|Description|Default|\n");
            sb.append("|---|---|---|\n");
            List options = cmd.getParameters();
            options.forEach(option -> sb.append("| `").append(option.getNames()).append("` | ").append(option.getDescription().replace("\n", " ")).append("|").append(option.getDefault()).append("|\n"));
        }
        return sb.toString();
    }

    public boolean isHelp() {
        return this.help;
    }

    public List<String> getCommandNames() {
        return this.commandNames;
    }

    public JCommander getJcommander() {
        return this.jcommander;
    }

    public void setHelp(boolean help) {
        this.help = help;
    }

    public void setCommandNames(List<String> commandNames) {
        this.commandNames = commandNames;
    }
}

