/*
 * Decompiled with CFR 0.152.
 */
package com.scurrilous.circe.checksum;

import com.scurrilous.circe.checksum.IntHash;
import com.scurrilous.circe.checksum.Java8IntHash;
import com.scurrilous.circe.checksum.Java9IntHash;
import com.scurrilous.circe.checksum.JniIntHash;
import com.scurrilous.circe.crc.Sse42Crc32C;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;

public class Crc32cIntChecksum {
    private static final IntHash CRC32C_HASH = Sse42Crc32C.isSupported() ? new JniIntHash() : (Java9IntHash.HAS_JAVA9_CRC32C ? new Java9IntHash() : new Java8IntHash());

    public static int computeChecksum(ByteBuf payload) {
        return CRC32C_HASH.calculate(payload);
    }

    public static int computeChecksum(ByteBuf payload, int offset, int len) {
        return CRC32C_HASH.calculate(payload, offset, len);
    }

    public static int resumeChecksum(int previousChecksum, ByteBuf payload) {
        return CRC32C_HASH.resume(previousChecksum, payload);
    }

    public static int resumeChecksum(int previousChecksum, ByteBuf payload, int offset, int len) {
        return CRC32C_HASH.resume(previousChecksum, payload, offset, len);
    }
}

