/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessageV3;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.impl.schema.AvroBaseStructSchema;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.client.impl.schema.reader.ProtobufReader;
import org.apache.pulsar.client.impl.schema.writer.ProtobufWriter;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.pulsar.shade.org.apache.avro.Schema;
import org.apache.pulsar.shade.org.apache.avro.protobuf.ProtobufData;

public class ProtobufSchema<T extends GeneratedMessageV3>
extends AvroBaseStructSchema<T> {
    public static final String PARSING_INFO_PROPERTY = "__PARSING_INFO__";

    private static <T> Schema createProtobufAvroSchema(Class<T> pojo) {
        return ProtobufData.get().getSchema(pojo);
    }

    private ProtobufSchema(SchemaInfo schemaInfo, T protoMessageInstance) {
        super(schemaInfo);
        this.setReader(new ProtobufReader<T>(protoMessageInstance));
        this.setWriter(new ProtobufWriter());
        HashMap<String, String> allProperties = new HashMap<String, String>(schemaInfo.getProperties());
        allProperties.put(PARSING_INFO_PROPERTY, this.getParsingInfo(protoMessageInstance));
        ((SchemaInfoImpl)schemaInfo).setProperties(allProperties);
    }

    private String getParsingInfo(T protoMessageInstance) {
        final LinkedList protoBufParsingInfos = new LinkedList();
        protoMessageInstance.getDescriptorForType().getFields().forEach(new Consumer<Descriptors.FieldDescriptor>(){

            @Override
            public void accept(Descriptors.FieldDescriptor fieldDescriptor) {
                protoBufParsingInfos.add(new ProtoBufParsingInfo(fieldDescriptor.getNumber(), fieldDescriptor.getName(), fieldDescriptor.getType().name(), fieldDescriptor.toProto().getLabel().name(), null));
            }
        });
        try {
            return ObjectMapperFactory.getMapperWithIncludeAlways().writer().writeValueAsString(protoBufParsingInfos);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends GeneratedMessageV3> ProtobufSchema<T> of(Class<T> pojo) {
        return ProtobufSchema.of(pojo, new HashMap<String, String>());
    }

    public static <T> ProtobufSchema ofGenericClass(Class<T> pojo, Map<String, String> properties) {
        SchemaDefinition schemaDefinition = SchemaDefinition.builder().withPojo(pojo).withProperties(properties).build();
        return ProtobufSchema.of(schemaDefinition);
    }

    public static <T> ProtobufSchema of(SchemaDefinition<T> schemaDefinition) {
        Class<T> pojo = schemaDefinition.getPojo();
        if (!GeneratedMessageV3.class.isAssignableFrom(pojo)) {
            throw new IllegalArgumentException(GeneratedMessageV3.class.getName() + " is not assignable from " + pojo.getName());
        }
        SchemaInfoImpl schemaInfo = SchemaInfoImpl.builder().schema(ProtobufSchema.createProtobufAvroSchema(schemaDefinition.getPojo()).toString().getBytes(StandardCharsets.UTF_8)).type(SchemaType.PROTOBUF).name("").properties(schemaDefinition.getProperties()).build();
        try {
            return new ProtobufSchema<GeneratedMessageV3>(schemaInfo, (GeneratedMessageV3)pojo.getMethod("getDefaultInstance", new Class[0]).invoke(null, new Object[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T extends GeneratedMessageV3> ProtobufSchema<T> of(Class pojo, Map<String, String> properties) {
        return ProtobufSchema.ofGenericClass(pojo, properties);
    }

    public static class ProtoBufParsingInfo {
        private final int number;
        private final String name;
        private final String type;
        private final String label;
        private final Map<String, Object> definition;

        public int getNumber() {
            return this.number;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getLabel() {
            return this.label;
        }

        public Map<String, Object> getDefinition() {
            return this.definition;
        }

        public ProtoBufParsingInfo(int number, String name, String type, String label, Map<String, Object> definition) {
            this.number = number;
            this.name = name;
            this.type = type;
            this.label = label;
            this.definition = definition;
        }
    }
}

