/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.auth;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.pulsar.client.api.AuthenticationDataProvider;

public class AuthenticationDataToken
implements AuthenticationDataProvider {
    public static final String HTTP_HEADER_NAME = "Authorization";
    private final Supplier<String> tokenSupplier;
    private Map<String, String> headers = new HashMap<String, String>();

    public AuthenticationDataToken(Supplier<String> tokenSupplier) {
        this.tokenSupplier = tokenSupplier;
        this.headers.put("X-Pulsar-Auth-Method-Name", "token");
        this.headers.put(HTTP_HEADER_NAME, "Bearer " + this.getToken());
        this.headers = Collections.unmodifiableMap(this.headers);
    }

    @Override
    public boolean hasDataForHttp() {
        return true;
    }

    @Override
    public Set<Map.Entry<String, String>> getHttpHeaders() {
        return this.headers.entrySet();
    }

    @Override
    public boolean hasDataFromCommand() {
        return true;
    }

    @Override
    public String getCommandData() {
        return this.getToken();
    }

    private String getToken() {
        try {
            return this.tokenSupplier.get();
        }
        catch (Throwable t2) {
            throw new RuntimeException("failed to get client token", t2);
        }
    }
}

