/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.transaction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.pulsar.client.api.transaction.TransactionCoordinatorClient;
import org.apache.pulsar.client.api.transaction.TransactionCoordinatorClientException;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.TransactionMetaStoreHandler;
import org.apache.pulsar.client.util.MathUtils;
import org.apache.pulsar.common.api.proto.Subscription;
import org.apache.pulsar.common.api.proto.TxnAction;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.collections.ConcurrentLongHashMap;
import org.apache.pulsar.shade.client.api.v2.PulsarClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionCoordinatorClientImpl
implements TransactionCoordinatorClient {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionCoordinatorClientImpl.class);
    private final PulsarClientImpl pulsarClient;
    private TransactionMetaStoreHandler[] handlers;
    private ConcurrentLongHashMap<TransactionMetaStoreHandler> handlerMap = new ConcurrentLongHashMap(16, 1);
    private final AtomicLong epoch = new AtomicLong(0L);
    private static final AtomicReferenceFieldUpdater<TransactionCoordinatorClientImpl, TransactionCoordinatorClient.State> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(TransactionCoordinatorClientImpl.class, TransactionCoordinatorClient.State.class, "state");
    private volatile TransactionCoordinatorClient.State state = TransactionCoordinatorClient.State.NONE;

    public TransactionCoordinatorClientImpl(PulsarClient pulsarClient) {
        this.pulsarClient = (PulsarClientImpl)pulsarClient;
    }

    @Override
    public void start() throws TransactionCoordinatorClientException {
        try {
            this.startAsync().get();
        }
        catch (Exception e) {
            throw TransactionCoordinatorClientException.unwrap(e);
        }
    }

    @Override
    public CompletableFuture<Void> startAsync() {
        if (STATE_UPDATER.compareAndSet(this, TransactionCoordinatorClient.State.NONE, TransactionCoordinatorClient.State.STARTING)) {
            return this.pulsarClient.getLookup().getPartitionedTopicMetadata(TopicName.TRANSACTION_COORDINATOR_ASSIGN).thenCompose(partitionMeta -> {
                ArrayList<CompletableFuture<Void>> connectFutureList = new ArrayList<CompletableFuture<Void>>();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Transaction meta store assign partition is {}.", (Object)partitionMeta.partitions);
                }
                if (partitionMeta.partitions > 0) {
                    this.handlers = new TransactionMetaStoreHandler[partitionMeta.partitions];
                    for (int i = 0; i < partitionMeta.partitions; ++i) {
                        TransactionMetaStoreHandler handler;
                        CompletableFuture<Void> connectFuture = new CompletableFuture<Void>();
                        connectFutureList.add(connectFuture);
                        this.handlers[i] = handler = new TransactionMetaStoreHandler(i, this.pulsarClient, this.getTCAssignTopicName(i), connectFuture);
                        this.handlerMap.put(i, handler);
                    }
                } else {
                    TransactionMetaStoreHandler handler;
                    this.handlers = new TransactionMetaStoreHandler[1];
                    CompletableFuture<Void> connectFuture = new CompletableFuture<Void>();
                    connectFutureList.add(connectFuture);
                    this.handlers[0] = handler = new TransactionMetaStoreHandler(0L, this.pulsarClient, this.getTCAssignTopicName(-1), connectFuture);
                    this.handlerMap.put(0L, handler);
                }
                STATE_UPDATER.set(this, TransactionCoordinatorClient.State.READY);
                return FutureUtil.waitForAll(connectFutureList);
            });
        }
        return FutureUtil.failedFuture(new TransactionCoordinatorClientException.CoordinatorClientStateException("Can not start while current state is " + (Object)((Object)this.state)));
    }

    private String getTCAssignTopicName(int partition) {
        if (partition >= 0) {
            return TopicName.TRANSACTION_COORDINATOR_ASSIGN.toString() + "-partition-" + partition;
        }
        return TopicName.TRANSACTION_COORDINATOR_ASSIGN.toString();
    }

    @Override
    public void close() throws TransactionCoordinatorClientException {
        try {
            this.closeAsync().get();
        }
        catch (Exception e) {
            throw TransactionCoordinatorClientException.unwrap(e);
        }
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        if (this.getState() == TransactionCoordinatorClient.State.CLOSING || this.getState() == TransactionCoordinatorClient.State.CLOSED) {
            LOG.warn("The transaction meta store is closing or closed, doing nothing.");
            result.complete(null);
        } else {
            if (this.handlers != null) {
                for (TransactionMetaStoreHandler handler : this.handlers) {
                    try {
                        handler.close();
                    }
                    catch (IOException e) {
                        LOG.warn("Close transaction meta store handler error", (Throwable)e);
                    }
                }
            }
            this.handlers = null;
            result.complete(null);
        }
        return result;
    }

    @Override
    public TxnID newTransaction() throws TransactionCoordinatorClientException {
        try {
            return this.newTransactionAsync().get();
        }
        catch (Exception e) {
            throw TransactionCoordinatorClientException.unwrap(e);
        }
    }

    @Override
    public CompletableFuture<TxnID> newTransactionAsync() {
        return this.newTransactionAsync(60000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public TxnID newTransaction(long timeout, TimeUnit unit) throws TransactionCoordinatorClientException {
        try {
            return this.newTransactionAsync(timeout, unit).get();
        }
        catch (Exception e) {
            throw TransactionCoordinatorClientException.unwrap(e);
        }
    }

    @Override
    public CompletableFuture<TxnID> newTransactionAsync(long timeout, TimeUnit unit) {
        return this.nextHandler().newTransactionAsync(timeout, unit);
    }

    @Override
    public void addPublishPartitionToTxn(TxnID txnID, List<String> partitions) throws TransactionCoordinatorClientException {
        try {
            this.addPublishPartitionToTxnAsync(txnID, partitions).get();
        }
        catch (Exception e) {
            throw TransactionCoordinatorClientException.unwrap(e);
        }
    }

    @Override
    public CompletableFuture<Void> addPublishPartitionToTxnAsync(TxnID txnID, List<String> partitions) {
        TransactionMetaStoreHandler handler = this.handlerMap.get(txnID.getMostSigBits());
        if (handler == null) {
            return FutureUtil.failedFuture(new TransactionCoordinatorClientException.MetaStoreHandlerNotExistsException(txnID.getMostSigBits()));
        }
        return handler.addPublishPartitionToTxnAsync(txnID, partitions);
    }

    @Override
    public void addSubscriptionToTxn(TxnID txnID, String topic, String subscription) throws TransactionCoordinatorClientException {
        try {
            this.addSubscriptionToTxnAsync(txnID, topic, subscription).get();
        }
        catch (Exception e) {
            throw TransactionCoordinatorClientException.unwrap(e);
        }
    }

    @Override
    public CompletableFuture<Void> addSubscriptionToTxnAsync(TxnID txnID, String topic, String subscription) {
        TransactionMetaStoreHandler handler = this.handlerMap.get(txnID.getMostSigBits());
        if (handler == null) {
            return FutureUtil.failedFuture(new TransactionCoordinatorClientException.MetaStoreHandlerNotExistsException(txnID.getMostSigBits()));
        }
        Subscription sub = new Subscription().setTopic(topic).setSubscription(subscription);
        return handler.addSubscriptionToTxn(txnID, Collections.singletonList(sub));
    }

    @Override
    public void commit(TxnID txnID) throws TransactionCoordinatorClientException {
        try {
            this.commitAsync(txnID).get();
        }
        catch (Exception e) {
            throw TransactionCoordinatorClientException.unwrap(e);
        }
    }

    @Override
    public CompletableFuture<Void> commitAsync(TxnID txnID) {
        TransactionMetaStoreHandler handler = this.handlerMap.get(txnID.getMostSigBits());
        if (handler == null) {
            return FutureUtil.failedFuture(new TransactionCoordinatorClientException.MetaStoreHandlerNotExistsException(txnID.getMostSigBits()));
        }
        return handler.endTxnAsync(txnID, TxnAction.COMMIT);
    }

    @Override
    public void abort(TxnID txnID) throws TransactionCoordinatorClientException {
        try {
            this.abortAsync(txnID).get();
        }
        catch (Exception e) {
            throw TransactionCoordinatorClientException.unwrap(e);
        }
    }

    @Override
    public CompletableFuture<Void> abortAsync(TxnID txnID) {
        TransactionMetaStoreHandler handler = this.handlerMap.get(txnID.getMostSigBits());
        if (handler == null) {
            return FutureUtil.failedFuture(new TransactionCoordinatorClientException.MetaStoreHandlerNotExistsException(txnID.getMostSigBits()));
        }
        return handler.endTxnAsync(txnID, TxnAction.ABORT);
    }

    @Override
    public TransactionCoordinatorClient.State getState() {
        return this.state;
    }

    private TransactionMetaStoreHandler nextHandler() {
        int index = MathUtils.signSafeMod(this.epoch.incrementAndGet(), this.handlers.length);
        return this.handlers[index];
    }
}

