/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.util.Objects;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;

public abstract class AbstractSchema<T>
implements Schema<T> {
    void validate(ByteBuf byteBuf) {
        throw new SchemaSerializationException("This method is not supported");
    }

    public abstract T decode(ByteBuf var1);

    public T decode(ByteBuf byteBuf, byte[] schemaVersion) {
        return this.decode(byteBuf);
    }

    @Override
    public Schema<T> clone() {
        return this;
    }

    public Schema<?> atSchemaVersion(byte[] schemaVersion) throws SchemaSerializationException {
        Objects.requireNonNull(schemaVersion);
        if (!this.supportSchemaVersioning()) {
            return this;
        }
        throw new SchemaSerializationException("Not implemented for " + this.getClass());
    }
}

