/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.io.airlift.compress.zstd;

import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteOrder;
import org.apache.pulsar.shade.io.airlift.compress.IncompatibleJvmException;
import sun.misc.Unsafe;

final class UnsafeUtil {
    public static final Unsafe UNSAFE;
    private static final Field ADDRESS_ACCESSOR;

    private UnsafeUtil() {
    }

    public static long getAddress(Buffer buffer) {
        try {
            return (Long)ADDRESS_ACCESSOR.get(buffer);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        ByteOrder order = ByteOrder.nativeOrder();
        if (!order.equals(ByteOrder.LITTLE_ENDIAN)) {
            throw new IncompatibleJvmException(String.format("Zstandard requires a little endian platform (found %s)", order));
        }
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            UNSAFE = (Unsafe)theUnsafe.get(null);
        }
        catch (Exception e) {
            throw new IncompatibleJvmException("Zstandard requires access to sun.misc.Unsafe");
        }
        try {
            Field field = Buffer.class.getDeclaredField("address");
            field.setAccessible(true);
            ADDRESS_ACCESSOR = field;
        }
        catch (Exception e) {
            throw new IncompatibleJvmException("Zstandard requires access to java.nio.Buffer raw address field");
        }
    }
}

