/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.apache.pulsar.client.impl.schema.AbstractSchema;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;

public class LocalDateTimeSchema
extends AbstractSchema<LocalDateTime> {
    private static final LocalDateTimeSchema INSTANCE;
    private static final SchemaInfo SCHEMA_INFO;
    public static final String DELIMITER = ":";

    public static LocalDateTimeSchema of() {
        return INSTANCE;
    }

    @Override
    public byte[] encode(LocalDateTime message) {
        if (null == message) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putLong(message.toLocalDate().toEpochDay());
        buffer.putLong(message.toLocalTime().toNanoOfDay());
        return buffer.array();
    }

    @Override
    public LocalDateTime decode(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        long epochDay = buffer.getLong();
        long nanoOfDay = buffer.getLong();
        return LocalDateTime.of(LocalDate.ofEpochDay(epochDay), LocalTime.ofNanoOfDay(nanoOfDay));
    }

    @Override
    public LocalDateTime decode(ByteBuf byteBuf) {
        if (null == byteBuf) {
            return null;
        }
        long epochDay = byteBuf.getLong(0);
        long nanoOfDay = byteBuf.getLong(8);
        return LocalDateTime.of(LocalDate.ofEpochDay(epochDay), LocalTime.ofNanoOfDay(nanoOfDay));
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }

    static {
        SCHEMA_INFO = new SchemaInfo().setName("LocalDateTime").setType(SchemaType.LOCAL_DATE_TIME).setSchema(new byte[0]);
        INSTANCE = new LocalDateTimeSchema();
    }
}

