/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import java.util.LinkedHashSet;
import java.util.Objects;
import org.apache.pulsar.client.api.ProxyProtocol;
import org.apache.pulsar.shade.com.google.common.base.MoreObjects;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.io.swagger.annotations.ApiModel;
import org.apache.pulsar.shade.io.swagger.annotations.ApiModelProperty;

@ApiModel(value="ClusterData", description="The configuration data for a cluster")
public class ClusterData {
    @ApiModelProperty(name="serviceUrl", value="The HTTP rest service URL (for admin operations)", example="http://pulsar.example.com:8080")
    private String serviceUrl;
    @ApiModelProperty(name="serviceUrlTls", value="The HTTPS rest service URL (for admin operations)", example="https://pulsar.example.com:8443")
    private String serviceUrlTls;
    @ApiModelProperty(name="brokerServiceUrl", value="The broker service url (for produce and consume operations)", example="pulsar://pulsar.example.com:6650")
    private String brokerServiceUrl;
    @ApiModelProperty(name="brokerServiceUrlTls", value="The secured broker service url (for produce and consume operations)", example="pulsar+ssl://pulsar.example.com:6651")
    private String brokerServiceUrlTls;
    @ApiModelProperty(name="proxyServiceUrl", value="Proxy-service url when client would like to connect to broker via proxy.", example="pulsar+ssl://ats-proxy.example.com:4443 or pulsar://ats-proxy.example.com:4080")
    private String proxyServiceUrl;
    @ApiModelProperty(name="authenticationPlugin", value="Authentication plugin when client would like to connect to cluster.", example="org.apache.pulsar.client.impl.auth.AuthenticationToken")
    private String authenticationPlugin;
    @ApiModelProperty(name="authenticationParameters", value="Authentication parameters when client would like to connect to cluster.")
    private String authenticationParameters;
    @ApiModelProperty(name="proxyProtocol", value="protocol to decide type of proxy routing eg: SNI-routing", example="SNI")
    private ProxyProtocol proxyProtocol;
    @ApiModelProperty(name="peerClusterNames", value="A set of peer cluster names")
    private LinkedHashSet<String> peerClusterNames;
    @ApiModelProperty(name="brokerClientTlsEnabled", value="Enable TLS when talking with other brokers in the same cluster (admin operation) or different clusters (replication)")
    private boolean brokerClientTlsEnabled = false;
    @ApiModelProperty(name="tlsAllowInsecureConnection", value="Allow TLS connections to servers whose certificate cannot be be verified to have been signed by a trusted certificate authority.")
    private boolean tlsAllowInsecureConnection = false;
    @ApiModelProperty(name="brokerClientTlsEnabledWithKeyStore", value="Whether internal client use KeyStore type to authenticate with other Pulsar brokers")
    private boolean brokerClientTlsEnabledWithKeyStore = false;
    @ApiModelProperty(name="brokerClientTlsTrustStoreType", value="TLS TrustStore type configuration for internal client: JKS, PKCS12 used by the internal client to authenticate with Pulsar brokers", example="JKS")
    private String brokerClientTlsTrustStoreType = "JKS";
    @ApiModelProperty(name="brokerClientTlsTrustStore", value="TLS TrustStore path for internal client used by the internal client to authenticate with Pulsar brokers")
    private String brokerClientTlsTrustStore;
    @ApiModelProperty(name="brokerClientTlsTrustStorePassword", value="TLS TrustStore password for internal client used by the internal client to authenticate with Pulsar brokers")
    private String brokerClientTlsTrustStorePassword;
    @ApiModelProperty(name="brokerClientTrustCertsFilePath", value="Path for the trusted TLS certificate file for outgoing connection to a server (broker)")
    private String brokerClientTrustCertsFilePath;

    public ClusterData(String serviceUrl) {
        this(serviceUrl, "");
    }

    public ClusterData(String serviceUrl, String serviceUrlTls) {
        this.serviceUrl = serviceUrl;
        this.serviceUrlTls = serviceUrlTls;
    }

    public ClusterData(String serviceUrl, String serviceUrlTls, String brokerServiceUrl, String brokerServiceUrlTls) {
        this.serviceUrl = serviceUrl;
        this.serviceUrlTls = serviceUrlTls;
        this.brokerServiceUrl = brokerServiceUrl;
        this.brokerServiceUrlTls = brokerServiceUrlTls;
    }

    public ClusterData(String serviceUrl, String serviceUrlTls, String brokerServiceUrl, String brokerServiceUrlTls, String authenticationPlugin, String authenticationParameters) {
        this.serviceUrl = serviceUrl;
        this.serviceUrlTls = serviceUrlTls;
        this.brokerServiceUrl = brokerServiceUrl;
        this.brokerServiceUrlTls = brokerServiceUrlTls;
        this.authenticationPlugin = authenticationPlugin;
        this.authenticationParameters = authenticationParameters;
    }

    public ClusterData(String serviceUrl, String serviceUrlTls, String brokerServiceUrl, String brokerServiceUrlTls, String proxyServiceUrl, String authenticationPlugin, String authenticationParameters, ProxyProtocol proxyProtocol) {
        this.serviceUrl = serviceUrl;
        this.serviceUrlTls = serviceUrlTls;
        this.brokerServiceUrl = brokerServiceUrl;
        this.brokerServiceUrlTls = brokerServiceUrlTls;
        this.authenticationPlugin = authenticationPlugin;
        this.authenticationParameters = authenticationParameters;
        this.proxyServiceUrl = proxyServiceUrl;
        this.proxyProtocol = proxyProtocol;
    }

    public void update(ClusterData other) {
        Preconditions.checkNotNull(other);
        this.serviceUrl = other.serviceUrl;
        this.serviceUrlTls = other.serviceUrlTls;
        this.brokerServiceUrl = other.brokerServiceUrl;
        this.brokerServiceUrlTls = other.brokerServiceUrlTls;
        this.proxyServiceUrl = other.proxyServiceUrl;
        this.proxyProtocol = other.proxyProtocol;
        this.authenticationPlugin = other.authenticationPlugin;
        this.authenticationParameters = other.authenticationParameters;
        this.brokerClientTlsEnabled = other.brokerClientTlsEnabled;
        this.tlsAllowInsecureConnection = other.tlsAllowInsecureConnection;
        this.brokerClientTlsEnabledWithKeyStore = other.brokerClientTlsEnabledWithKeyStore;
        this.brokerClientTlsTrustStoreType = other.brokerClientTlsTrustStoreType;
        this.brokerClientTlsTrustStore = other.brokerClientTlsTrustStore;
        this.brokerClientTlsTrustStorePassword = other.brokerClientTlsTrustStorePassword;
        this.brokerClientTrustCertsFilePath = other.brokerClientTrustCertsFilePath;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClusterData) {
            ClusterData other = (ClusterData)obj;
            return Objects.equals(this.serviceUrl, other.serviceUrl) && Objects.equals(this.serviceUrlTls, other.serviceUrlTls) && Objects.equals(this.brokerServiceUrl, other.brokerServiceUrl) && Objects.equals(this.brokerServiceUrlTls, other.brokerServiceUrlTls) && Objects.equals(this.proxyServiceUrl, other.proxyServiceUrl) && Objects.equals((Object)this.proxyProtocol, (Object)other.proxyProtocol) && Objects.equals(this.authenticationPlugin, other.authenticationPlugin) && Objects.equals(this.authenticationParameters, other.authenticationParameters) && Objects.equals(this.brokerClientTlsEnabled, other.brokerClientTlsEnabled) && Objects.equals(this.tlsAllowInsecureConnection, other.tlsAllowInsecureConnection) && Objects.equals(this.brokerClientTlsEnabledWithKeyStore, other.brokerClientTlsEnabledWithKeyStore) && Objects.equals(this.brokerClientTlsTrustStoreType, other.brokerClientTlsTrustStoreType) && Objects.equals(this.brokerClientTlsTrustStore, other.brokerClientTlsTrustStore) && Objects.equals(this.brokerClientTlsTrustStorePassword, other.brokerClientTlsTrustStorePassword) && Objects.equals(this.brokerClientTrustCertsFilePath, other.brokerClientTrustCertsFilePath);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.toString());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("serviceUrl", this.serviceUrl).add("serviceUrlTls", this.serviceUrlTls).add("brokerServiceUrl", this.brokerServiceUrl).add("brokerServiceUrlTls", this.brokerServiceUrlTls).add("proxyServiceUrl", this.proxyServiceUrl).add("proxyProtocol", (Object)this.proxyProtocol).add("peerClusterNames", this.peerClusterNames).add("authenticationPlugin", this.authenticationPlugin).add("authenticationParameters", this.authenticationParameters).add("brokerClientTlsEnabled", this.brokerClientTlsEnabled).add("tlsAllowInsecureConnection", this.tlsAllowInsecureConnection).add("brokerClientTlsEnabledWithKeyStore", this.brokerClientTlsEnabledWithKeyStore).add("brokerClientTlsTrustStoreType", this.brokerClientTlsTrustStoreType).add("brokerClientTlsTrustStore", this.brokerClientTlsTrustStore).add("brokerClientTlsTrustStorePassword", this.brokerClientTlsTrustStorePassword).add("brokerClientTrustCertsFilePath", this.brokerClientTrustCertsFilePath).toString();
    }

    public static ClusterDataBuilder builder() {
        return new ClusterDataBuilder();
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getServiceUrlTls() {
        return this.serviceUrlTls;
    }

    public String getBrokerServiceUrl() {
        return this.brokerServiceUrl;
    }

    public String getBrokerServiceUrlTls() {
        return this.brokerServiceUrlTls;
    }

    public String getProxyServiceUrl() {
        return this.proxyServiceUrl;
    }

    public String getAuthenticationPlugin() {
        return this.authenticationPlugin;
    }

    public String getAuthenticationParameters() {
        return this.authenticationParameters;
    }

    public ProxyProtocol getProxyProtocol() {
        return this.proxyProtocol;
    }

    public LinkedHashSet<String> getPeerClusterNames() {
        return this.peerClusterNames;
    }

    public boolean isBrokerClientTlsEnabled() {
        return this.brokerClientTlsEnabled;
    }

    public boolean isTlsAllowInsecureConnection() {
        return this.tlsAllowInsecureConnection;
    }

    public boolean isBrokerClientTlsEnabledWithKeyStore() {
        return this.brokerClientTlsEnabledWithKeyStore;
    }

    public String getBrokerClientTlsTrustStoreType() {
        return this.brokerClientTlsTrustStoreType;
    }

    public String getBrokerClientTlsTrustStore() {
        return this.brokerClientTlsTrustStore;
    }

    public String getBrokerClientTlsTrustStorePassword() {
        return this.brokerClientTlsTrustStorePassword;
    }

    public String getBrokerClientTrustCertsFilePath() {
        return this.brokerClientTrustCertsFilePath;
    }

    public ClusterData setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
        return this;
    }

    public ClusterData setServiceUrlTls(String serviceUrlTls) {
        this.serviceUrlTls = serviceUrlTls;
        return this;
    }

    public ClusterData setBrokerServiceUrl(String brokerServiceUrl) {
        this.brokerServiceUrl = brokerServiceUrl;
        return this;
    }

    public ClusterData setBrokerServiceUrlTls(String brokerServiceUrlTls) {
        this.brokerServiceUrlTls = brokerServiceUrlTls;
        return this;
    }

    public ClusterData setProxyServiceUrl(String proxyServiceUrl) {
        this.proxyServiceUrl = proxyServiceUrl;
        return this;
    }

    public ClusterData setAuthenticationPlugin(String authenticationPlugin) {
        this.authenticationPlugin = authenticationPlugin;
        return this;
    }

    public ClusterData setAuthenticationParameters(String authenticationParameters) {
        this.authenticationParameters = authenticationParameters;
        return this;
    }

    public ClusterData setProxyProtocol(ProxyProtocol proxyProtocol) {
        this.proxyProtocol = proxyProtocol;
        return this;
    }

    public ClusterData setPeerClusterNames(LinkedHashSet<String> peerClusterNames) {
        this.peerClusterNames = peerClusterNames;
        return this;
    }

    public ClusterData setBrokerClientTlsEnabled(boolean brokerClientTlsEnabled) {
        this.brokerClientTlsEnabled = brokerClientTlsEnabled;
        return this;
    }

    public ClusterData setTlsAllowInsecureConnection(boolean tlsAllowInsecureConnection) {
        this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
        return this;
    }

    public ClusterData setBrokerClientTlsEnabledWithKeyStore(boolean brokerClientTlsEnabledWithKeyStore) {
        this.brokerClientTlsEnabledWithKeyStore = brokerClientTlsEnabledWithKeyStore;
        return this;
    }

    public ClusterData setBrokerClientTlsTrustStoreType(String brokerClientTlsTrustStoreType) {
        this.brokerClientTlsTrustStoreType = brokerClientTlsTrustStoreType;
        return this;
    }

    public ClusterData setBrokerClientTlsTrustStore(String brokerClientTlsTrustStore) {
        this.brokerClientTlsTrustStore = brokerClientTlsTrustStore;
        return this;
    }

    public ClusterData setBrokerClientTlsTrustStorePassword(String brokerClientTlsTrustStorePassword) {
        this.brokerClientTlsTrustStorePassword = brokerClientTlsTrustStorePassword;
        return this;
    }

    public ClusterData setBrokerClientTrustCertsFilePath(String brokerClientTrustCertsFilePath) {
        this.brokerClientTrustCertsFilePath = brokerClientTrustCertsFilePath;
        return this;
    }

    public ClusterData(String serviceUrl, String serviceUrlTls, String brokerServiceUrl, String brokerServiceUrlTls, String proxyServiceUrl, String authenticationPlugin, String authenticationParameters, ProxyProtocol proxyProtocol, LinkedHashSet<String> peerClusterNames, boolean brokerClientTlsEnabled, boolean tlsAllowInsecureConnection, boolean brokerClientTlsEnabledWithKeyStore, String brokerClientTlsTrustStoreType, String brokerClientTlsTrustStore, String brokerClientTlsTrustStorePassword, String brokerClientTrustCertsFilePath) {
        this.serviceUrl = serviceUrl;
        this.serviceUrlTls = serviceUrlTls;
        this.brokerServiceUrl = brokerServiceUrl;
        this.brokerServiceUrlTls = brokerServiceUrlTls;
        this.proxyServiceUrl = proxyServiceUrl;
        this.authenticationPlugin = authenticationPlugin;
        this.authenticationParameters = authenticationParameters;
        this.proxyProtocol = proxyProtocol;
        this.peerClusterNames = peerClusterNames;
        this.brokerClientTlsEnabled = brokerClientTlsEnabled;
        this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
        this.brokerClientTlsEnabledWithKeyStore = brokerClientTlsEnabledWithKeyStore;
        this.brokerClientTlsTrustStoreType = brokerClientTlsTrustStoreType;
        this.brokerClientTlsTrustStore = brokerClientTlsTrustStore;
        this.brokerClientTlsTrustStorePassword = brokerClientTlsTrustStorePassword;
        this.brokerClientTrustCertsFilePath = brokerClientTrustCertsFilePath;
    }

    public ClusterData() {
    }

    public static class ClusterDataBuilder {
        private String serviceUrl;
        private String serviceUrlTls;
        private String brokerServiceUrl;
        private String brokerServiceUrlTls;
        private String proxyServiceUrl;
        private String authenticationPlugin;
        private String authenticationParameters;
        private ProxyProtocol proxyProtocol;
        private LinkedHashSet<String> peerClusterNames;
        private boolean brokerClientTlsEnabled;
        private boolean tlsAllowInsecureConnection;
        private boolean brokerClientTlsEnabledWithKeyStore;
        private String brokerClientTlsTrustStoreType;
        private String brokerClientTlsTrustStore;
        private String brokerClientTlsTrustStorePassword;
        private String brokerClientTrustCertsFilePath;

        ClusterDataBuilder() {
        }

        public ClusterDataBuilder serviceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
            return this;
        }

        public ClusterDataBuilder serviceUrlTls(String serviceUrlTls) {
            this.serviceUrlTls = serviceUrlTls;
            return this;
        }

        public ClusterDataBuilder brokerServiceUrl(String brokerServiceUrl) {
            this.brokerServiceUrl = brokerServiceUrl;
            return this;
        }

        public ClusterDataBuilder brokerServiceUrlTls(String brokerServiceUrlTls) {
            this.brokerServiceUrlTls = brokerServiceUrlTls;
            return this;
        }

        public ClusterDataBuilder proxyServiceUrl(String proxyServiceUrl) {
            this.proxyServiceUrl = proxyServiceUrl;
            return this;
        }

        public ClusterDataBuilder authenticationPlugin(String authenticationPlugin) {
            this.authenticationPlugin = authenticationPlugin;
            return this;
        }

        public ClusterDataBuilder authenticationParameters(String authenticationParameters) {
            this.authenticationParameters = authenticationParameters;
            return this;
        }

        public ClusterDataBuilder proxyProtocol(ProxyProtocol proxyProtocol) {
            this.proxyProtocol = proxyProtocol;
            return this;
        }

        public ClusterDataBuilder peerClusterNames(LinkedHashSet<String> peerClusterNames) {
            this.peerClusterNames = peerClusterNames;
            return this;
        }

        public ClusterDataBuilder brokerClientTlsEnabled(boolean brokerClientTlsEnabled) {
            this.brokerClientTlsEnabled = brokerClientTlsEnabled;
            return this;
        }

        public ClusterDataBuilder tlsAllowInsecureConnection(boolean tlsAllowInsecureConnection) {
            this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
            return this;
        }

        public ClusterDataBuilder brokerClientTlsEnabledWithKeyStore(boolean brokerClientTlsEnabledWithKeyStore) {
            this.brokerClientTlsEnabledWithKeyStore = brokerClientTlsEnabledWithKeyStore;
            return this;
        }

        public ClusterDataBuilder brokerClientTlsTrustStoreType(String brokerClientTlsTrustStoreType) {
            this.brokerClientTlsTrustStoreType = brokerClientTlsTrustStoreType;
            return this;
        }

        public ClusterDataBuilder brokerClientTlsTrustStore(String brokerClientTlsTrustStore) {
            this.brokerClientTlsTrustStore = brokerClientTlsTrustStore;
            return this;
        }

        public ClusterDataBuilder brokerClientTlsTrustStorePassword(String brokerClientTlsTrustStorePassword) {
            this.brokerClientTlsTrustStorePassword = brokerClientTlsTrustStorePassword;
            return this;
        }

        public ClusterDataBuilder brokerClientTrustCertsFilePath(String brokerClientTrustCertsFilePath) {
            this.brokerClientTrustCertsFilePath = brokerClientTrustCertsFilePath;
            return this;
        }

        public ClusterData build() {
            return new ClusterData(this.serviceUrl, this.serviceUrlTls, this.brokerServiceUrl, this.brokerServiceUrlTls, this.proxyServiceUrl, this.authenticationPlugin, this.authenticationParameters, this.proxyProtocol, this.peerClusterNames, this.brokerClientTlsEnabled, this.tlsAllowInsecureConnection, this.brokerClientTlsEnabledWithKeyStore, this.brokerClientTlsTrustStoreType, this.brokerClientTlsTrustStore, this.brokerClientTlsTrustStorePassword, this.brokerClientTrustCertsFilePath);
        }

        public String toString() {
            return "ClusterData.ClusterDataBuilder(serviceUrl=" + this.serviceUrl + ", serviceUrlTls=" + this.serviceUrlTls + ", brokerServiceUrl=" + this.brokerServiceUrl + ", brokerServiceUrlTls=" + this.brokerServiceUrlTls + ", proxyServiceUrl=" + this.proxyServiceUrl + ", authenticationPlugin=" + this.authenticationPlugin + ", authenticationParameters=" + this.authenticationParameters + ", proxyProtocol=" + (Object)((Object)this.proxyProtocol) + ", peerClusterNames=" + this.peerClusterNames + ", brokerClientTlsEnabled=" + this.brokerClientTlsEnabled + ", tlsAllowInsecureConnection=" + this.tlsAllowInsecureConnection + ", brokerClientTlsEnabledWithKeyStore=" + this.brokerClientTlsEnabledWithKeyStore + ", brokerClientTlsTrustStoreType=" + this.brokerClientTlsTrustStoreType + ", brokerClientTlsTrustStore=" + this.brokerClientTlsTrustStore + ", brokerClientTlsTrustStorePassword=" + this.brokerClientTlsTrustStorePassword + ", brokerClientTrustCertsFilePath=" + this.brokerClientTrustCertsFilePath + ")";
        }
    }
}

