/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.policies.data.loadbalancer;

public class ResourceUsage {
    public double usage;
    public double limit;

    public ResourceUsage(double usage, double limit) {
        this.usage = usage;
        this.limit = limit;
    }

    public ResourceUsage(ResourceUsage that) {
        this.usage = that.usage;
        this.limit = that.limit;
    }

    public ResourceUsage() {
    }

    public void reset() {
        this.usage = -1.0;
        this.limit = -1.0;
    }

    public int compareTo(ResourceUsage o) {
        double required = o.limit - o.usage;
        double available = this.limit - this.usage;
        return Double.compare(available, required);
    }

    public float percentUsage() {
        float proportion = 0.0f;
        if (this.limit > 0.0) {
            proportion = (float)this.usage / (float)this.limit;
        }
        return proportion * 100.0f;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceUsage)) {
            return false;
        }
        ResourceUsage other = (ResourceUsage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.usage, other.usage) != 0) {
            return false;
        }
        return Double.compare(this.limit, other.limit) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResourceUsage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $usage = Double.doubleToLongBits(this.usage);
        result = result * 59 + (int)($usage >>> 32 ^ $usage);
        long $limit = Double.doubleToLongBits(this.limit);
        result = result * 59 + (int)($limit >>> 32 ^ $limit);
        return result;
    }
}

