/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.impl;

import java.util.SortedSet;
import org.apache.pulsar.common.policies.AutoFailoverPolicy;
import org.apache.pulsar.common.policies.data.AutoFailoverPolicyData;
import org.apache.pulsar.common.policies.data.AutoFailoverPolicyType;
import org.apache.pulsar.common.policies.data.BrokerStatus;
import org.apache.pulsar.shade.com.google.common.base.Objects;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;

public class MinAvailablePolicy
extends AutoFailoverPolicy {
    private static final String MIN_LIMIT_KEY = "min_limit";
    private static final String USAGE_THRESHOLD_KEY = "usage_threshold";
    private static final int MAX_USAGE_THRESHOLD = 100;
    public int min_limit;
    public int usage_threshold;

    MinAvailablePolicy(int minLimit, int usageThreshold) {
        this.min_limit = minLimit;
        this.usage_threshold = usageThreshold;
    }

    public MinAvailablePolicy(AutoFailoverPolicyData policyData) {
        Preconditions.checkArgument(policyData.policy_type.equals((Object)AutoFailoverPolicyType.min_available));
        Preconditions.checkArgument(policyData.parameters.containsKey(MIN_LIMIT_KEY));
        Preconditions.checkArgument(policyData.parameters.containsKey(USAGE_THRESHOLD_KEY));
        this.min_limit = Integer.parseInt(policyData.parameters.get(MIN_LIMIT_KEY));
        this.usage_threshold = Integer.parseInt(policyData.parameters.get(USAGE_THRESHOLD_KEY));
    }

    public int hashCode() {
        return Objects.hashCode(this.min_limit, this.usage_threshold);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MinAvailablePolicy) {
            MinAvailablePolicy other = (MinAvailablePolicy)obj;
            return Objects.equal(this.min_limit, other.min_limit) && Objects.equal(this.usage_threshold, other.usage_threshold);
        }
        return false;
    }

    @Override
    public boolean isBrokerAvailable(BrokerStatus brokerStatus) {
        return brokerStatus.isActive() && (this.usage_threshold == 100 || brokerStatus.getLoadFactor() < this.usage_threshold);
    }

    @Override
    public boolean shouldFailoverToSecondary(SortedSet<BrokerStatus> primaryCandidates) {
        int numAvailablePrimaryBrokers = 0;
        for (BrokerStatus brkStatus : primaryCandidates) {
            if (!this.isBrokerAvailable(brkStatus)) continue;
            ++numAvailablePrimaryBrokers;
        }
        return numAvailablePrimaryBrokers < this.min_limit;
    }

    @Override
    public boolean shouldFailoverToSecondary(int totalPrimaryCandidates) {
        return totalPrimaryCandidates < this.min_limit;
    }

    public String toString() {
        return String.format("[policy_type=min_available min_limit=%s usage_threshold=%s]", this.min_limit, this.usage_threshold);
    }
}

