/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.functions;

import org.apache.pulsar.common.functions.CryptoConfig;

public class ProducerConfig {
    private Integer maxPendingMessages;
    private Integer maxPendingMessagesAcrossPartitions;
    private Boolean useThreadLocalProducers;
    private CryptoConfig cryptoConfig;
    private String batchBuilder;

    public static ProducerConfigBuilder builder() {
        return new ProducerConfigBuilder();
    }

    public Integer getMaxPendingMessages() {
        return this.maxPendingMessages;
    }

    public Integer getMaxPendingMessagesAcrossPartitions() {
        return this.maxPendingMessagesAcrossPartitions;
    }

    public Boolean getUseThreadLocalProducers() {
        return this.useThreadLocalProducers;
    }

    public CryptoConfig getCryptoConfig() {
        return this.cryptoConfig;
    }

    public String getBatchBuilder() {
        return this.batchBuilder;
    }

    public void setMaxPendingMessages(Integer maxPendingMessages) {
        this.maxPendingMessages = maxPendingMessages;
    }

    public void setMaxPendingMessagesAcrossPartitions(Integer maxPendingMessagesAcrossPartitions) {
        this.maxPendingMessagesAcrossPartitions = maxPendingMessagesAcrossPartitions;
    }

    public void setUseThreadLocalProducers(Boolean useThreadLocalProducers) {
        this.useThreadLocalProducers = useThreadLocalProducers;
    }

    public void setCryptoConfig(CryptoConfig cryptoConfig) {
        this.cryptoConfig = cryptoConfig;
    }

    public void setBatchBuilder(String batchBuilder) {
        this.batchBuilder = batchBuilder;
    }

    public String toString() {
        return "ProducerConfig(maxPendingMessages=" + this.getMaxPendingMessages() + ", maxPendingMessagesAcrossPartitions=" + this.getMaxPendingMessagesAcrossPartitions() + ", useThreadLocalProducers=" + this.getUseThreadLocalProducers() + ", cryptoConfig=" + this.getCryptoConfig() + ", batchBuilder=" + this.getBatchBuilder() + ")";
    }

    public ProducerConfig() {
    }

    public ProducerConfig(Integer maxPendingMessages, Integer maxPendingMessagesAcrossPartitions, Boolean useThreadLocalProducers, CryptoConfig cryptoConfig, String batchBuilder) {
        this.maxPendingMessages = maxPendingMessages;
        this.maxPendingMessagesAcrossPartitions = maxPendingMessagesAcrossPartitions;
        this.useThreadLocalProducers = useThreadLocalProducers;
        this.cryptoConfig = cryptoConfig;
        this.batchBuilder = batchBuilder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProducerConfig)) {
            return false;
        }
        ProducerConfig other = (ProducerConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$maxPendingMessages = this.getMaxPendingMessages();
        Integer other$maxPendingMessages = other.getMaxPendingMessages();
        if (this$maxPendingMessages == null ? other$maxPendingMessages != null : !((Object)this$maxPendingMessages).equals(other$maxPendingMessages)) {
            return false;
        }
        Integer this$maxPendingMessagesAcrossPartitions = this.getMaxPendingMessagesAcrossPartitions();
        Integer other$maxPendingMessagesAcrossPartitions = other.getMaxPendingMessagesAcrossPartitions();
        if (this$maxPendingMessagesAcrossPartitions == null ? other$maxPendingMessagesAcrossPartitions != null : !((Object)this$maxPendingMessagesAcrossPartitions).equals(other$maxPendingMessagesAcrossPartitions)) {
            return false;
        }
        Boolean this$useThreadLocalProducers = this.getUseThreadLocalProducers();
        Boolean other$useThreadLocalProducers = other.getUseThreadLocalProducers();
        if (this$useThreadLocalProducers == null ? other$useThreadLocalProducers != null : !((Object)this$useThreadLocalProducers).equals(other$useThreadLocalProducers)) {
            return false;
        }
        CryptoConfig this$cryptoConfig = this.getCryptoConfig();
        CryptoConfig other$cryptoConfig = other.getCryptoConfig();
        if (this$cryptoConfig == null ? other$cryptoConfig != null : !((Object)this$cryptoConfig).equals(other$cryptoConfig)) {
            return false;
        }
        String this$batchBuilder = this.getBatchBuilder();
        String other$batchBuilder = other.getBatchBuilder();
        return !(this$batchBuilder == null ? other$batchBuilder != null : !this$batchBuilder.equals(other$batchBuilder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProducerConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $maxPendingMessages = this.getMaxPendingMessages();
        result = result * 59 + ($maxPendingMessages == null ? 43 : ((Object)$maxPendingMessages).hashCode());
        Integer $maxPendingMessagesAcrossPartitions = this.getMaxPendingMessagesAcrossPartitions();
        result = result * 59 + ($maxPendingMessagesAcrossPartitions == null ? 43 : ((Object)$maxPendingMessagesAcrossPartitions).hashCode());
        Boolean $useThreadLocalProducers = this.getUseThreadLocalProducers();
        result = result * 59 + ($useThreadLocalProducers == null ? 43 : ((Object)$useThreadLocalProducers).hashCode());
        CryptoConfig $cryptoConfig = this.getCryptoConfig();
        result = result * 59 + ($cryptoConfig == null ? 43 : ((Object)$cryptoConfig).hashCode());
        String $batchBuilder = this.getBatchBuilder();
        result = result * 59 + ($batchBuilder == null ? 43 : $batchBuilder.hashCode());
        return result;
    }

    public static class ProducerConfigBuilder {
        private Integer maxPendingMessages;
        private Integer maxPendingMessagesAcrossPartitions;
        private Boolean useThreadLocalProducers;
        private CryptoConfig cryptoConfig;
        private String batchBuilder;

        ProducerConfigBuilder() {
        }

        public ProducerConfigBuilder maxPendingMessages(Integer maxPendingMessages) {
            this.maxPendingMessages = maxPendingMessages;
            return this;
        }

        public ProducerConfigBuilder maxPendingMessagesAcrossPartitions(Integer maxPendingMessagesAcrossPartitions) {
            this.maxPendingMessagesAcrossPartitions = maxPendingMessagesAcrossPartitions;
            return this;
        }

        public ProducerConfigBuilder useThreadLocalProducers(Boolean useThreadLocalProducers) {
            this.useThreadLocalProducers = useThreadLocalProducers;
            return this;
        }

        public ProducerConfigBuilder cryptoConfig(CryptoConfig cryptoConfig) {
            this.cryptoConfig = cryptoConfig;
            return this;
        }

        public ProducerConfigBuilder batchBuilder(String batchBuilder) {
            this.batchBuilder = batchBuilder;
            return this;
        }

        public ProducerConfig build() {
            return new ProducerConfig(this.maxPendingMessages, this.maxPendingMessagesAcrossPartitions, this.useThreadLocalProducers, this.cryptoConfig, this.batchBuilder);
        }

        public String toString() {
            return "ProducerConfig.ProducerConfigBuilder(maxPendingMessages=" + this.maxPendingMessages + ", maxPendingMessagesAcrossPartitions=" + this.maxPendingMessagesAcrossPartitions + ", useThreadLocalProducers=" + this.useThreadLocalProducers + ", cryptoConfig=" + this.cryptoConfig + ", batchBuilder=" + this.batchBuilder + ")";
        }
    }
}

