/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.api.schema.SchemaInfoProvider;
import org.apache.pulsar.client.impl.schema.AbstractSchema;
import org.apache.pulsar.client.impl.schema.BooleanSchema;
import org.apache.pulsar.client.impl.schema.ByteSchema;
import org.apache.pulsar.client.impl.schema.BytesSchema;
import org.apache.pulsar.client.impl.schema.DateSchema;
import org.apache.pulsar.client.impl.schema.DoubleSchema;
import org.apache.pulsar.client.impl.schema.FloatSchema;
import org.apache.pulsar.client.impl.schema.GenericObjectWrapper;
import org.apache.pulsar.client.impl.schema.InstantSchema;
import org.apache.pulsar.client.impl.schema.IntSchema;
import org.apache.pulsar.client.impl.schema.KeyValueSchema;
import org.apache.pulsar.client.impl.schema.KeyValueSchemaInfo;
import org.apache.pulsar.client.impl.schema.LocalDateSchema;
import org.apache.pulsar.client.impl.schema.LocalDateTimeSchema;
import org.apache.pulsar.client.impl.schema.LocalTimeSchema;
import org.apache.pulsar.client.impl.schema.LongSchema;
import org.apache.pulsar.client.impl.schema.ShortSchema;
import org.apache.pulsar.client.impl.schema.StringSchema;
import org.apache.pulsar.client.impl.schema.TimeSchema;
import org.apache.pulsar.client.impl.schema.TimestampSchema;
import org.apache.pulsar.client.impl.schema.generic.GenericProtobufNativeSchema;
import org.apache.pulsar.client.impl.schema.generic.GenericSchemaImpl;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoConsumeSchema
implements Schema<GenericRecord> {
    private static final Logger log = LoggerFactory.getLogger(AutoConsumeSchema.class);
    private Schema<?> schema;
    private String topicName;
    private String componentName;
    private SchemaInfoProvider schemaInfoProvider;

    public void setSchema(Schema<?> schema) {
        this.schema = schema;
    }

    private void ensureSchemaInitialized() {
        Preconditions.checkState(null != this.schema, "Schema is not initialized before used");
    }

    @Override
    public void validate(byte[] message) {
        this.ensureSchemaInitialized();
        this.schema.validate(message);
    }

    @Override
    public byte[] encode(GenericRecord message) {
        this.ensureSchemaInitialized();
        throw new UnsupportedOperationException("AutoConsumeSchema is not intended to be used for encoding");
    }

    @Override
    public boolean supportSchemaVersioning() {
        return this.schema == null || this.schema.supportSchemaVersioning();
    }

    public Schema<?> atSchemaVersion(byte[] schemaVersion) {
        this.fetchSchemaIfNeeded();
        this.ensureSchemaInitialized();
        if (this.schema.supportSchemaVersioning() && this.schema instanceof AbstractSchema) {
            return ((AbstractSchema)this.schema).atSchemaVersion(schemaVersion);
        }
        return this.schema;
    }

    @Override
    public GenericRecord decode(byte[] bytes, byte[] schemaVersion) {
        this.fetchSchemaIfNeeded();
        this.ensureSchemaInitialized();
        return this.adapt(this.schema.decode(bytes, schemaVersion), schemaVersion);
    }

    @Override
    public void setSchemaInfoProvider(SchemaInfoProvider schemaInfoProvider) {
        if (this.schema == null) {
            this.schemaInfoProvider = schemaInfoProvider;
        } else {
            this.schema.setSchemaInfoProvider(schemaInfoProvider);
        }
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        if (this.schema == null) {
            return null;
        }
        return this.schema.getSchemaInfo();
    }

    @Override
    public void configureSchemaInfo(String topicName, String componentName, SchemaInfo schemaInfo) {
        this.topicName = topicName;
        this.componentName = componentName;
        if (schemaInfo != null) {
            Schema<?> genericSchema = AutoConsumeSchema.generateSchema(schemaInfo);
            this.setSchema(genericSchema);
            log.info("Configure {} schema for topic {} : {}", new Object[]{componentName, topicName, schemaInfo.getSchemaDefinition()});
        }
    }

    @Override
    public Optional<Object> getNativeSchema() {
        this.ensureSchemaInitialized();
        if (this.schema == null) {
            return Optional.empty();
        }
        return this.schema.getNativeSchema();
    }

    private static Schema<?> generateSchema(SchemaInfo schemaInfo) {
        boolean useProvidedSchemaAsReaderSchema = false;
        switch (schemaInfo.getType()) {
            case JSON: 
            case AVRO: {
                return GenericSchemaImpl.of(schemaInfo, false);
            }
            case PROTOBUF_NATIVE: {
                return GenericProtobufNativeSchema.of(schemaInfo, false);
            }
        }
        return AutoConsumeSchema.getSchema(schemaInfo);
    }

    public static Schema<?> getSchema(SchemaInfo schemaInfo) {
        switch (schemaInfo.getType()) {
            case INT8: {
                return ByteSchema.of();
            }
            case INT16: {
                return ShortSchema.of();
            }
            case INT32: {
                return IntSchema.of();
            }
            case INT64: {
                return LongSchema.of();
            }
            case STRING: {
                return StringSchema.utf8();
            }
            case FLOAT: {
                return FloatSchema.of();
            }
            case DOUBLE: {
                return DoubleSchema.of();
            }
            case BOOLEAN: {
                return BooleanSchema.of();
            }
            case BYTES: 
            case NONE: {
                return BytesSchema.of();
            }
            case DATE: {
                return DateSchema.of();
            }
            case TIME: {
                return TimeSchema.of();
            }
            case TIMESTAMP: {
                return TimestampSchema.of();
            }
            case INSTANT: {
                return InstantSchema.of();
            }
            case LOCAL_DATE: {
                return LocalDateSchema.of();
            }
            case LOCAL_TIME: {
                return LocalTimeSchema.of();
            }
            case LOCAL_DATE_TIME: {
                return LocalDateTimeSchema.of();
            }
            case JSON: 
            case AVRO: {
                return GenericSchemaImpl.of(schemaInfo, false);
            }
            case PROTOBUF_NATIVE: {
                return GenericProtobufNativeSchema.of(schemaInfo);
            }
            case KEY_VALUE: {
                KeyValue<SchemaInfo, SchemaInfo> kvSchemaInfo = KeyValueSchemaInfo.decodeKeyValueSchemaInfo(schemaInfo);
                Schema<?> keySchema = AutoConsumeSchema.getSchema(kvSchemaInfo.getKey());
                Schema<?> valueSchema = AutoConsumeSchema.getSchema(kvSchemaInfo.getValue());
                return KeyValueSchema.of(keySchema, valueSchema, KeyValueSchemaInfo.decodeKeyValueEncodingType(schemaInfo));
            }
        }
        throw new IllegalArgumentException("Retrieve schema instance from schema info for type '" + (Object)((Object)schemaInfo.getType()) + "' is not supported yet");
    }

    @Override
    public Schema<GenericRecord> clone() {
        AutoConsumeSchema schema = new AutoConsumeSchema();
        if (this.schema != null) {
            schema.configureSchemaInfo(this.topicName, this.componentName, this.schema.getSchemaInfo());
        } else {
            schema.configureSchemaInfo(this.topicName, this.componentName, null);
        }
        if (this.schemaInfoProvider != null) {
            schema.setSchemaInfoProvider(this.schemaInfoProvider);
        }
        return schema;
    }

    @Override
    public boolean requireFetchingSchemaInfo() {
        return true;
    }

    protected GenericRecord adapt(Object value, byte[] schemaVersion) {
        if (value instanceof GenericRecord) {
            return (GenericRecord)value;
        }
        if (this.schema == null) {
            throw new IllegalStateException("Cannot decode a message without schema");
        }
        return AutoConsumeSchema.wrapPrimitiveObject(value, this.schema.getSchemaInfo().getType(), schemaVersion);
    }

    public static GenericRecord wrapPrimitiveObject(Object value, SchemaType type, byte[] schemaVersion) {
        return GenericObjectWrapper.of(value, type, schemaVersion);
    }

    public Schema<?> getInternalSchema() {
        return this.schema;
    }

    public void fetchSchemaIfNeeded() throws SchemaSerializationException {
        if (this.schema == null) {
            if (this.schemaInfoProvider == null) {
                throw new SchemaSerializationException("Can't get accurate schema information for topic " + this.topicName + "using AutoConsumeSchema because SchemaInfoProvider is not set yet");
            }
            SchemaInfo schemaInfo = null;
            try {
                schemaInfo = this.schemaInfoProvider.getLatestSchema().get();
                if (schemaInfo == null) {
                    schemaInfo = BytesSchema.of().getSchemaInfo();
                }
            }
            catch (InterruptedException | ExecutionException e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                log.error("Can't get last schema for topic {} using AutoConsumeSchema", (Object)this.topicName);
                throw new SchemaSerializationException(e.getCause());
            }
            this.schema = AutoConsumeSchema.generateSchema(schemaInfo);
            this.schema.setSchemaInfoProvider(this.schemaInfoProvider);
            log.info("Configure {} schema for topic {} : {}", new Object[]{this.componentName, this.topicName, schemaInfo.getSchemaDefinition()});
        }
    }

    public String toString() {
        if (this.schema != null && this.schema.getSchemaInfo() != null) {
            return "AUTO_CONSUME(schematype=" + (Object)((Object)this.schema.getSchemaInfo().getType()) + ")";
        }
        return "AUTO_CONSUME(uninitialized)";
    }
}

