/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util.keystoretls;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.common.util.keystoretls.SslContextFactoryWithAutoRefresh;
import org.apache.pulsar.shade.com.google.common.base.Strings;
import org.apache.pulsar.shade.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import org.apache.pulsar.shade.org.eclipse.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreSSLContext {
    private static final Logger log = LoggerFactory.getLogger(KeyStoreSSLContext.class);
    public static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    public static final String DEFAULT_SSL_PROTOCOL = "TLS";
    public static final String DEFAULT_SSL_ENABLED_PROTOCOLS = "TLSv1.2,TLSv1.1,TLSv1";
    public static final String DEFAULT_SSL_KEYMANGER_ALGORITHM = KeyManagerFactory.getDefaultAlgorithm();
    public static final String DEFAULT_SSL_TRUSTMANAGER_ALGORITHM = TrustManagerFactory.getDefaultAlgorithm();
    public static final Provider BC_PROVIDER = SecurityUtility.getProvider();
    private final Mode mode;
    private String sslProviderString;
    private String keyStoreTypeString;
    private String keyStorePath;
    private String keyStorePassword;
    private boolean allowInsecureConnection;
    private String trustStoreTypeString;
    private String trustStorePath;
    private String trustStorePassword;
    private boolean needClientAuth;
    private Set<String> ciphers;
    private Set<String> protocols;
    private SSLContext sslContext;
    private String protocol = "TLS";
    private String kmfAlgorithm = DEFAULT_SSL_KEYMANGER_ALGORITHM;
    private String tmfAlgorithm = DEFAULT_SSL_TRUSTMANAGER_ALGORITHM;

    public KeyStoreSSLContext(Mode mode, String sslProviderString, String keyStoreTypeString, String keyStorePath, String keyStorePassword, boolean allowInsecureConnection, String trustStoreTypeString, String trustStorePath, String trustStorePassword, boolean requireTrustedClientCertOnConnect, Set<String> ciphers, Set<String> protocols) {
        this.mode = mode;
        this.sslProviderString = sslProviderString;
        this.keyStoreTypeString = Strings.isNullOrEmpty(keyStoreTypeString) ? DEFAULT_KEYSTORE_TYPE : keyStoreTypeString;
        this.keyStorePath = keyStorePath;
        this.keyStorePassword = keyStorePassword;
        this.trustStoreTypeString = Strings.isNullOrEmpty(trustStoreTypeString) ? DEFAULT_KEYSTORE_TYPE : trustStoreTypeString;
        this.trustStorePath = trustStorePath;
        this.trustStorePassword = trustStorePassword;
        this.needClientAuth = requireTrustedClientCertOnConnect;
        this.ciphers = ciphers;
        this.protocols = protocols;
        this.protocols = protocols != null && protocols.size() > 0 ? protocols : new HashSet<String>(Arrays.asList(DEFAULT_SSL_ENABLED_PROTOCOLS.split("\\s*,\\s*")));
        this.ciphers = ciphers != null && ciphers.size() > 0 ? ciphers : null;
        this.allowInsecureConnection = allowInsecureConnection;
    }

    public SSLContext createSSLContext() throws GeneralSecurityException, IOException {
        TrustManagerFactory trustManagerFactory;
        char[] passwordChars;
        SSLContext sslContext = this.sslProviderString != null ? SSLContext.getInstance(this.protocol, this.sslProviderString) : SSLContext.getInstance(this.protocol);
        KeyManager[] keyManagers = null;
        if (!Strings.isNullOrEmpty(this.keyStorePath)) {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this.kmfAlgorithm);
            KeyStore keyStore = KeyStore.getInstance(this.keyStoreTypeString);
            passwordChars = this.keyStorePassword.toCharArray();
            keyStore.load(new FileInputStream(this.keyStorePath), passwordChars);
            keyManagerFactory.init(keyStore, passwordChars);
            keyManagers = keyManagerFactory.getKeyManagers();
        }
        if (this.allowInsecureConnection) {
            trustManagerFactory = InsecureTrustManagerFactory.INSTANCE;
        } else {
            trustManagerFactory = TrustManagerFactory.getInstance(this.tmfAlgorithm);
            KeyStore trustStore = KeyStore.getInstance(this.trustStoreTypeString);
            passwordChars = this.trustStorePassword.toCharArray();
            trustStore.load(new FileInputStream(this.trustStorePath), passwordChars);
            trustManagerFactory.init(trustStore);
        }
        sslContext.init(keyManagers, trustManagerFactory.getTrustManagers(), new SecureRandom());
        this.sslContext = sslContext;
        return sslContext;
    }

    public SSLEngine createSSLEngine() {
        return this.configureSSLEngine(this.sslContext.createSSLEngine());
    }

    public SSLEngine createSSLEngine(String peerHost, int peerPort) {
        return this.configureSSLEngine(this.sslContext.createSSLEngine(peerHost, peerPort));
    }

    private SSLEngine configureSSLEngine(SSLEngine sslEngine) {
        sslEngine.setEnabledProtocols(this.protocols.toArray(new String[0]));
        sslEngine.setEnabledCipherSuites(sslEngine.getSupportedCipherSuites());
        if (this.mode == Mode.SERVER) {
            sslEngine.setNeedClientAuth(this.needClientAuth);
            sslEngine.setUseClientMode(false);
        } else {
            sslEngine.setUseClientMode(true);
        }
        return sslEngine;
    }

    public static KeyStoreSSLContext createClientKeyStoreSslContext(String sslProviderString, String keyStoreTypeString, String keyStorePath, String keyStorePassword, boolean allowInsecureConnection, String trustStoreTypeString, String trustStorePath, String trustStorePassword, Set<String> ciphers, Set<String> protocols) throws GeneralSecurityException, SSLException, FileNotFoundException, IOException {
        KeyStoreSSLContext keyStoreSSLContext = new KeyStoreSSLContext(Mode.CLIENT, sslProviderString, keyStoreTypeString, keyStorePath, keyStorePassword, allowInsecureConnection, trustStoreTypeString, trustStorePath, trustStorePassword, false, ciphers, protocols);
        keyStoreSSLContext.createSSLContext();
        return keyStoreSSLContext;
    }

    public static KeyStoreSSLContext createServerKeyStoreSslContext(String sslProviderString, String keyStoreTypeString, String keyStorePath, String keyStorePassword, boolean allowInsecureConnection, String trustStoreTypeString, String trustStorePath, String trustStorePassword, boolean requireTrustedClientCertOnConnect, Set<String> ciphers, Set<String> protocols) throws GeneralSecurityException, SSLException, FileNotFoundException, IOException {
        KeyStoreSSLContext keyStoreSSLContext = new KeyStoreSSLContext(Mode.SERVER, sslProviderString, keyStoreTypeString, keyStorePath, keyStorePassword, allowInsecureConnection, trustStoreTypeString, trustStorePath, trustStorePassword, requireTrustedClientCertOnConnect, ciphers, protocols);
        keyStoreSSLContext.createSSLContext();
        return keyStoreSSLContext;
    }

    public static SSLContext createServerSslContext(String sslProviderString, String keyStoreTypeString, String keyStorePath, String keyStorePassword, boolean allowInsecureConnection, String trustStoreTypeString, String trustStorePath, String trustStorePassword, boolean requireTrustedClientCertOnConnect) throws GeneralSecurityException, SSLException, FileNotFoundException, IOException {
        return KeyStoreSSLContext.createServerKeyStoreSslContext(sslProviderString, keyStoreTypeString, keyStorePath, keyStorePassword, allowInsecureConnection, trustStoreTypeString, trustStorePath, trustStorePassword, requireTrustedClientCertOnConnect, null, null).getSslContext();
    }

    public static SSLContext createClientSslContext(String sslProviderString, String keyStoreTypeString, String keyStorePath, String keyStorePassword, boolean allowInsecureConnection, String trustStoreTypeString, String trustStorePath, String trustStorePassword, Set<String> ciphers, Set<String> protocol) throws GeneralSecurityException, SSLException, FileNotFoundException, IOException {
        KeyStoreSSLContext keyStoreSSLContext = new KeyStoreSSLContext(Mode.CLIENT, sslProviderString, keyStoreTypeString, keyStorePath, keyStorePassword, allowInsecureConnection, trustStoreTypeString, trustStorePath, trustStorePassword, false, ciphers, protocol);
        return keyStoreSSLContext.createSSLContext();
    }

    public static SSLContext createClientSslContext(String keyStoreTypeString, String keyStorePath, String keyStorePassword, String trustStoreTypeString, String trustStorePath, String trustStorePassword) throws GeneralSecurityException, SSLException, FileNotFoundException, IOException {
        KeyStoreSSLContext keyStoreSSLContext = new KeyStoreSSLContext(Mode.CLIENT, null, keyStoreTypeString, keyStorePath, keyStorePassword, false, trustStoreTypeString, trustStorePath, trustStorePassword, false, null, null);
        return keyStoreSSLContext.createSSLContext();
    }

    public static SslContextFactory createSslContextFactory(String sslProviderString, String keyStoreTypeString, String keyStore, String keyStorePassword, boolean allowInsecureConnection, String trustStoreTypeString, String trustStore, String trustStorePassword, boolean requireTrustedClientCertOnConnect, long certRefreshInSec) throws GeneralSecurityException, SSLException, FileNotFoundException, IOException {
        SslContextFactoryWithAutoRefresh sslCtxFactory = new SslContextFactoryWithAutoRefresh(sslProviderString, keyStoreTypeString, keyStore, keyStorePassword, allowInsecureConnection, trustStoreTypeString, trustStore, trustStorePassword, requireTrustedClientCertOnConnect, certRefreshInSec);
        if (requireTrustedClientCertOnConnect) {
            sslCtxFactory.setNeedClientAuth(true);
        } else {
            sslCtxFactory.setWantClientAuth(true);
        }
        sslCtxFactory.setTrustAll(true);
        return sslCtxFactory;
    }

    public Mode getMode() {
        return this.mode;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public static enum Mode {
        CLIENT,
        SERVER;

    }
}

