/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.protocol.schema;

import java.util.Optional;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.com.google.common.hash.HashCode;
import org.apache.pulsar.shade.com.google.common.hash.HashFunction;
import org.apache.pulsar.shade.com.google.common.hash.Hashing;

public class SchemaHash {
    private static HashFunction hashFunction = Hashing.sha256();
    private final HashCode hash;
    private final SchemaType schemaType;

    private SchemaHash(HashCode hash, SchemaType schemaType) {
        this.hash = hash;
        this.schemaType = schemaType;
    }

    public static SchemaHash of(Schema schema) {
        Optional<SchemaInfo> schemaInfo = Optional.ofNullable(schema).map(Schema::getSchemaInfo);
        return SchemaHash.of(schemaInfo.map(SchemaInfo::getSchema).orElseGet(() -> new byte[0]), schemaInfo.map(SchemaInfo::getType).orElse(null));
    }

    public static SchemaHash of(SchemaData schemaData) {
        return SchemaHash.of(schemaData.getData(), schemaData.getType());
    }

    public static SchemaHash of(SchemaInfo schemaInfo) {
        return SchemaHash.of(schemaInfo == null ? new byte[]{} : schemaInfo.getSchema(), schemaInfo == null ? null : schemaInfo.getType());
    }

    public static SchemaHash of(byte[] schemaBytes, SchemaType schemaType) {
        return new SchemaHash(hashFunction.hashBytes(schemaBytes), schemaType);
    }

    public byte[] asBytes() {
        return this.hash.asBytes();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchemaHash)) {
            return false;
        }
        SchemaHash other = (SchemaHash)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HashCode this$hash = this.hash;
        HashCode other$hash = other.hash;
        if (this$hash == null ? other$hash != null : !((Object)this$hash).equals(other$hash)) {
            return false;
        }
        SchemaType this$schemaType = this.schemaType;
        SchemaType other$schemaType = other.schemaType;
        return !(this$schemaType == null ? other$schemaType != null : !((Object)((Object)this$schemaType)).equals((Object)other$schemaType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SchemaHash;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HashCode $hash = this.hash;
        result = result * 59 + ($hash == null ? 43 : ((Object)$hash).hashCode());
        SchemaType $schemaType = this.schemaType;
        result = result * 59 + ($schemaType == null ? 43 : ((Object)((Object)$schemaType)).hashCode());
        return result;
    }
}

