/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.conf;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.ConsumerCryptoFailureAction;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Range;
import org.apache.pulsar.client.api.ReaderInterceptor;
import org.apache.pulsar.shade.client.api.v2.ReaderListener;
import org.apache.pulsar.shade.com.fasterxml.jackson.annotation.JsonIgnore;

public class ReaderConfigurationData<T>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private Set<String> topicNames = new HashSet<String>();
    @JsonIgnore
    private MessageId startMessageId;
    @JsonIgnore
    private long startMessageFromRollbackDurationInSec;
    private int receiverQueueSize = 1000;
    private ReaderListener<T> readerListener;
    private String readerName = null;
    private String subscriptionRolePrefix = null;
    private String subscriptionName = null;
    private CryptoKeyReader cryptoKeyReader = null;
    private ConsumerCryptoFailureAction cryptoFailureAction = ConsumerCryptoFailureAction.FAIL;
    private boolean readCompacted = false;
    private boolean resetIncludeHead = false;
    private transient List<Range> keyHashRanges;
    private boolean poolMessages = false;
    private boolean autoUpdatePartitions = true;
    private long autoUpdatePartitionsIntervalSeconds = 60L;
    private transient List<ReaderInterceptor<T>> readerInterceptorList;
    private int maxPendingChunkedMessage = 10;
    private boolean autoAckOldestChunkedMessageOnQueueFull = false;
    private long expireTimeOfIncompleteChunkedMessageMillis = TimeUnit.MINUTES.toMillis(1L);

    @JsonIgnore
    public String getTopicName() {
        if (this.topicNames.size() > 1) {
            throw new IllegalArgumentException("topicNames needs to be = 1");
        }
        return this.topicNames.iterator().next();
    }

    @JsonIgnore
    public void setTopicName(String topicNames) {
        this.topicNames.clear();
        this.topicNames.add(topicNames);
    }

    public ReaderConfigurationData<T> clone() {
        try {
            ReaderConfigurationData clone = (ReaderConfigurationData)super.clone();
            clone.setTopicNames(new HashSet<String>(clone.getTopicNames()));
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone ReaderConfigurationData");
        }
    }

    public Set<String> getTopicNames() {
        return this.topicNames;
    }

    public MessageId getStartMessageId() {
        return this.startMessageId;
    }

    public long getStartMessageFromRollbackDurationInSec() {
        return this.startMessageFromRollbackDurationInSec;
    }

    public int getReceiverQueueSize() {
        return this.receiverQueueSize;
    }

    public ReaderListener<T> getReaderListener() {
        return this.readerListener;
    }

    public String getReaderName() {
        return this.readerName;
    }

    public String getSubscriptionRolePrefix() {
        return this.subscriptionRolePrefix;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public CryptoKeyReader getCryptoKeyReader() {
        return this.cryptoKeyReader;
    }

    public ConsumerCryptoFailureAction getCryptoFailureAction() {
        return this.cryptoFailureAction;
    }

    public boolean isReadCompacted() {
        return this.readCompacted;
    }

    public boolean isResetIncludeHead() {
        return this.resetIncludeHead;
    }

    public List<Range> getKeyHashRanges() {
        return this.keyHashRanges;
    }

    public boolean isPoolMessages() {
        return this.poolMessages;
    }

    public boolean isAutoUpdatePartitions() {
        return this.autoUpdatePartitions;
    }

    public long getAutoUpdatePartitionsIntervalSeconds() {
        return this.autoUpdatePartitionsIntervalSeconds;
    }

    public List<ReaderInterceptor<T>> getReaderInterceptorList() {
        return this.readerInterceptorList;
    }

    public int getMaxPendingChunkedMessage() {
        return this.maxPendingChunkedMessage;
    }

    public boolean isAutoAckOldestChunkedMessageOnQueueFull() {
        return this.autoAckOldestChunkedMessageOnQueueFull;
    }

    public long getExpireTimeOfIncompleteChunkedMessageMillis() {
        return this.expireTimeOfIncompleteChunkedMessageMillis;
    }

    public void setTopicNames(Set<String> topicNames) {
        this.topicNames = topicNames;
    }

    @JsonIgnore
    public void setStartMessageId(MessageId startMessageId) {
        this.startMessageId = startMessageId;
    }

    @JsonIgnore
    public void setStartMessageFromRollbackDurationInSec(long startMessageFromRollbackDurationInSec) {
        this.startMessageFromRollbackDurationInSec = startMessageFromRollbackDurationInSec;
    }

    public void setReceiverQueueSize(int receiverQueueSize) {
        this.receiverQueueSize = receiverQueueSize;
    }

    public void setReaderListener(ReaderListener<T> readerListener) {
        this.readerListener = readerListener;
    }

    public void setReaderName(String readerName) {
        this.readerName = readerName;
    }

    public void setSubscriptionRolePrefix(String subscriptionRolePrefix) {
        this.subscriptionRolePrefix = subscriptionRolePrefix;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public void setCryptoKeyReader(CryptoKeyReader cryptoKeyReader) {
        this.cryptoKeyReader = cryptoKeyReader;
    }

    public void setCryptoFailureAction(ConsumerCryptoFailureAction cryptoFailureAction) {
        this.cryptoFailureAction = cryptoFailureAction;
    }

    public void setReadCompacted(boolean readCompacted) {
        this.readCompacted = readCompacted;
    }

    public void setResetIncludeHead(boolean resetIncludeHead) {
        this.resetIncludeHead = resetIncludeHead;
    }

    public void setKeyHashRanges(List<Range> keyHashRanges) {
        this.keyHashRanges = keyHashRanges;
    }

    public void setPoolMessages(boolean poolMessages) {
        this.poolMessages = poolMessages;
    }

    public void setAutoUpdatePartitions(boolean autoUpdatePartitions) {
        this.autoUpdatePartitions = autoUpdatePartitions;
    }

    public void setAutoUpdatePartitionsIntervalSeconds(long autoUpdatePartitionsIntervalSeconds) {
        this.autoUpdatePartitionsIntervalSeconds = autoUpdatePartitionsIntervalSeconds;
    }

    public void setReaderInterceptorList(List<ReaderInterceptor<T>> readerInterceptorList) {
        this.readerInterceptorList = readerInterceptorList;
    }

    public void setMaxPendingChunkedMessage(int maxPendingChunkedMessage) {
        this.maxPendingChunkedMessage = maxPendingChunkedMessage;
    }

    public void setAutoAckOldestChunkedMessageOnQueueFull(boolean autoAckOldestChunkedMessageOnQueueFull) {
        this.autoAckOldestChunkedMessageOnQueueFull = autoAckOldestChunkedMessageOnQueueFull;
    }

    public void setExpireTimeOfIncompleteChunkedMessageMillis(long expireTimeOfIncompleteChunkedMessageMillis) {
        this.expireTimeOfIncompleteChunkedMessageMillis = expireTimeOfIncompleteChunkedMessageMillis;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReaderConfigurationData)) {
            return false;
        }
        ReaderConfigurationData other = (ReaderConfigurationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStartMessageFromRollbackDurationInSec() != other.getStartMessageFromRollbackDurationInSec()) {
            return false;
        }
        if (this.getReceiverQueueSize() != other.getReceiverQueueSize()) {
            return false;
        }
        if (this.isReadCompacted() != other.isReadCompacted()) {
            return false;
        }
        if (this.isResetIncludeHead() != other.isResetIncludeHead()) {
            return false;
        }
        if (this.isPoolMessages() != other.isPoolMessages()) {
            return false;
        }
        if (this.isAutoUpdatePartitions() != other.isAutoUpdatePartitions()) {
            return false;
        }
        if (this.getAutoUpdatePartitionsIntervalSeconds() != other.getAutoUpdatePartitionsIntervalSeconds()) {
            return false;
        }
        if (this.getMaxPendingChunkedMessage() != other.getMaxPendingChunkedMessage()) {
            return false;
        }
        if (this.isAutoAckOldestChunkedMessageOnQueueFull() != other.isAutoAckOldestChunkedMessageOnQueueFull()) {
            return false;
        }
        if (this.getExpireTimeOfIncompleteChunkedMessageMillis() != other.getExpireTimeOfIncompleteChunkedMessageMillis()) {
            return false;
        }
        Set<String> this$topicNames = this.getTopicNames();
        Set<String> other$topicNames = other.getTopicNames();
        if (this$topicNames == null ? other$topicNames != null : !((Object)this$topicNames).equals(other$topicNames)) {
            return false;
        }
        MessageId this$startMessageId = this.getStartMessageId();
        MessageId other$startMessageId = other.getStartMessageId();
        if (this$startMessageId == null ? other$startMessageId != null : !this$startMessageId.equals(other$startMessageId)) {
            return false;
        }
        ReaderListener<T> this$readerListener = this.getReaderListener();
        ReaderListener<T> other$readerListener = other.getReaderListener();
        if (this$readerListener == null ? other$readerListener != null : !this$readerListener.equals(other$readerListener)) {
            return false;
        }
        String this$readerName = this.getReaderName();
        String other$readerName = other.getReaderName();
        if (this$readerName == null ? other$readerName != null : !this$readerName.equals(other$readerName)) {
            return false;
        }
        String this$subscriptionRolePrefix = this.getSubscriptionRolePrefix();
        String other$subscriptionRolePrefix = other.getSubscriptionRolePrefix();
        if (this$subscriptionRolePrefix == null ? other$subscriptionRolePrefix != null : !this$subscriptionRolePrefix.equals(other$subscriptionRolePrefix)) {
            return false;
        }
        String this$subscriptionName = this.getSubscriptionName();
        String other$subscriptionName = other.getSubscriptionName();
        if (this$subscriptionName == null ? other$subscriptionName != null : !this$subscriptionName.equals(other$subscriptionName)) {
            return false;
        }
        CryptoKeyReader this$cryptoKeyReader = this.getCryptoKeyReader();
        CryptoKeyReader other$cryptoKeyReader = other.getCryptoKeyReader();
        if (this$cryptoKeyReader == null ? other$cryptoKeyReader != null : !this$cryptoKeyReader.equals(other$cryptoKeyReader)) {
            return false;
        }
        ConsumerCryptoFailureAction this$cryptoFailureAction = this.getCryptoFailureAction();
        ConsumerCryptoFailureAction other$cryptoFailureAction = other.getCryptoFailureAction();
        return !(this$cryptoFailureAction == null ? other$cryptoFailureAction != null : !((Object)((Object)this$cryptoFailureAction)).equals((Object)other$cryptoFailureAction));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReaderConfigurationData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startMessageFromRollbackDurationInSec = this.getStartMessageFromRollbackDurationInSec();
        result = result * 59 + (int)($startMessageFromRollbackDurationInSec >>> 32 ^ $startMessageFromRollbackDurationInSec);
        result = result * 59 + this.getReceiverQueueSize();
        result = result * 59 + (this.isReadCompacted() ? 79 : 97);
        result = result * 59 + (this.isResetIncludeHead() ? 79 : 97);
        result = result * 59 + (this.isPoolMessages() ? 79 : 97);
        result = result * 59 + (this.isAutoUpdatePartitions() ? 79 : 97);
        long $autoUpdatePartitionsIntervalSeconds = this.getAutoUpdatePartitionsIntervalSeconds();
        result = result * 59 + (int)($autoUpdatePartitionsIntervalSeconds >>> 32 ^ $autoUpdatePartitionsIntervalSeconds);
        result = result * 59 + this.getMaxPendingChunkedMessage();
        result = result * 59 + (this.isAutoAckOldestChunkedMessageOnQueueFull() ? 79 : 97);
        long $expireTimeOfIncompleteChunkedMessageMillis = this.getExpireTimeOfIncompleteChunkedMessageMillis();
        result = result * 59 + (int)($expireTimeOfIncompleteChunkedMessageMillis >>> 32 ^ $expireTimeOfIncompleteChunkedMessageMillis);
        Set<String> $topicNames = this.getTopicNames();
        result = result * 59 + ($topicNames == null ? 43 : ((Object)$topicNames).hashCode());
        MessageId $startMessageId = this.getStartMessageId();
        result = result * 59 + ($startMessageId == null ? 43 : $startMessageId.hashCode());
        ReaderListener<T> $readerListener = this.getReaderListener();
        result = result * 59 + ($readerListener == null ? 43 : $readerListener.hashCode());
        String $readerName = this.getReaderName();
        result = result * 59 + ($readerName == null ? 43 : $readerName.hashCode());
        String $subscriptionRolePrefix = this.getSubscriptionRolePrefix();
        result = result * 59 + ($subscriptionRolePrefix == null ? 43 : $subscriptionRolePrefix.hashCode());
        String $subscriptionName = this.getSubscriptionName();
        result = result * 59 + ($subscriptionName == null ? 43 : $subscriptionName.hashCode());
        CryptoKeyReader $cryptoKeyReader = this.getCryptoKeyReader();
        result = result * 59 + ($cryptoKeyReader == null ? 43 : $cryptoKeyReader.hashCode());
        ConsumerCryptoFailureAction $cryptoFailureAction = this.getCryptoFailureAction();
        result = result * 59 + ($cryptoFailureAction == null ? 43 : ((Object)((Object)$cryptoFailureAction)).hashCode());
        return result;
    }

    public String toString() {
        return "ReaderConfigurationData(topicNames=" + this.getTopicNames() + ", startMessageId=" + this.getStartMessageId() + ", startMessageFromRollbackDurationInSec=" + this.getStartMessageFromRollbackDurationInSec() + ", receiverQueueSize=" + this.getReceiverQueueSize() + ", readerListener=" + this.getReaderListener() + ", readerName=" + this.getReaderName() + ", subscriptionRolePrefix=" + this.getSubscriptionRolePrefix() + ", subscriptionName=" + this.getSubscriptionName() + ", cryptoKeyReader=" + this.getCryptoKeyReader() + ", cryptoFailureAction=" + (Object)((Object)this.getCryptoFailureAction()) + ", readCompacted=" + this.isReadCompacted() + ", resetIncludeHead=" + this.isResetIncludeHead() + ", keyHashRanges=" + this.getKeyHashRanges() + ", poolMessages=" + this.isPoolMessages() + ", autoUpdatePartitions=" + this.isAutoUpdatePartitions() + ", autoUpdatePartitionsIntervalSeconds=" + this.getAutoUpdatePartitionsIntervalSeconds() + ", readerInterceptorList=" + this.getReaderInterceptorList() + ", maxPendingChunkedMessage=" + this.getMaxPendingChunkedMessage() + ", autoAckOldestChunkedMessageOnQueueFull=" + this.isAutoAckOldestChunkedMessageOnQueueFull() + ", expireTimeOfIncompleteChunkedMessageMillis=" + this.getExpireTimeOfIncompleteChunkedMessageMillis() + ")";
    }
}

