/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.util.Map;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.api.schema.SchemaReader;
import org.apache.pulsar.client.api.schema.SchemaWriter;
import org.apache.pulsar.client.impl.schema.AvroBaseStructSchema;
import org.apache.pulsar.client.impl.schema.reader.MultiVersionAvroReader;
import org.apache.pulsar.client.impl.schema.util.SchemaUtil;
import org.apache.pulsar.client.impl.schema.writer.AvroWriter;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.org.apache.avro.Conversion;
import org.apache.pulsar.shade.org.apache.avro.Conversions;
import org.apache.pulsar.shade.org.apache.avro.LogicalType;
import org.apache.pulsar.shade.org.apache.avro.LogicalTypes;
import org.apache.pulsar.shade.org.apache.avro.Schema;
import org.apache.pulsar.shade.org.apache.avro.data.TimeConversions;
import org.apache.pulsar.shade.org.apache.avro.reflect.ReflectData;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSchema<T>
extends AvroBaseStructSchema<T> {
    private static final Logger log = LoggerFactory.getLogger(AvroSchema.class);
    private static final Logger LOG = LoggerFactory.getLogger(AvroSchema.class);
    private boolean isCustomReaderAndWriter;
    private ClassLoader pojoClassLoader;

    private AvroSchema(SchemaInfo schemaInfo, ClassLoader pojoClassLoader) {
        super(schemaInfo);
        this.pojoClassLoader = pojoClassLoader;
        boolean jsr310ConversionEnabled = SchemaUtil.getJsr310ConversionEnabledFromSchemaInfo(schemaInfo);
        this.setReader(new MultiVersionAvroReader(this.schema, pojoClassLoader, SchemaUtil.getJsr310ConversionEnabledFromSchemaInfo(schemaInfo)));
        this.setWriter(new AvroWriter(this.schema, jsr310ConversionEnabled));
    }

    private AvroSchema(SchemaReader<T> reader, SchemaWriter<T> writer, SchemaInfo schemaInfo) {
        super(schemaInfo);
        this.setReader(reader);
        this.setWriter(writer);
        this.isCustomReaderAndWriter = true;
    }

    @Override
    public boolean supportSchemaVersioning() {
        return true;
    }

    @Override
    public org.apache.pulsar.client.api.Schema<T> clone() {
        if (this.isCustomReaderAndWriter) {
            return new AvroSchema<T>(this.reader, this.writer, this.schemaInfo);
        }
        AvroSchema<T> schema = new AvroSchema<T>(this.schemaInfo, this.pojoClassLoader);
        if (this.schemaInfoProvider != null) {
            schema.setSchemaInfoProvider(this.schemaInfoProvider);
        }
        return schema;
    }

    public static <T> AvroSchema<T> of(SchemaDefinition<T> schemaDefinition) {
        if (schemaDefinition.getSchemaReaderOpt().isPresent() && schemaDefinition.getSchemaWriterOpt().isPresent()) {
            return new AvroSchema<T>(schemaDefinition.getSchemaReaderOpt().get(), schemaDefinition.getSchemaWriterOpt().get(), SchemaUtil.parseSchemaInfo(schemaDefinition, SchemaType.AVRO));
        }
        ClassLoader pojoClassLoader = null;
        if (schemaDefinition.getPojo() != null) {
            pojoClassLoader = schemaDefinition.getPojo().getClassLoader();
        }
        return new AvroSchema<T>(SchemaUtil.parseSchemaInfo(schemaDefinition, SchemaType.AVRO), pojoClassLoader);
    }

    public static <T> AvroSchema<T> of(Class<T> pojo) {
        return AvroSchema.of(SchemaDefinition.builder().withPojo(pojo).build());
    }

    public static <T> AvroSchema<T> of(Class<T> pojo, Map<String, String> properties) {
        return AvroSchema.of(SchemaDefinition.builder().withPojo(pojo).withProperties(properties).build());
    }

    public static void addLogicalTypeConversions(ReflectData reflectData, boolean jsr310ConversionEnabled) {
        AvroSchema.addLogicalTypeConversions(reflectData, jsr310ConversionEnabled, true);
    }

    public static void addLogicalTypeConversions(ReflectData reflectData, boolean jsr310ConversionEnabled, boolean decimalConversionEnabled) {
        if (decimalConversionEnabled) {
            reflectData.addLogicalTypeConversion(new Conversions.DecimalConversion());
        }
        reflectData.addLogicalTypeConversion(new TimeConversions.DateConversion());
        reflectData.addLogicalTypeConversion(new TimeConversions.TimeMillisConversion());
        reflectData.addLogicalTypeConversion(new TimeConversions.TimeMicrosConversion());
        reflectData.addLogicalTypeConversion(new TimeConversions.TimestampMicrosConversion());
        if (jsr310ConversionEnabled) {
            reflectData.addLogicalTypeConversion(new TimeConversions.TimestampMillisConversion());
        } else {
            try {
                Class.forName("org.joda.time.DateTime");
                reflectData.addLogicalTypeConversion(new TimestampConversion());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        reflectData.addLogicalTypeConversion(new Conversions.UUIDConversion());
    }

    public static class TimestampConversion
    extends Conversion<DateTime> {
        @Override
        public Class<DateTime> getConvertedType() {
            return DateTime.class;
        }

        @Override
        public String getLogicalTypeName() {
            return "timestamp-millis";
        }

        @Override
        public DateTime fromLong(Long millisFromEpoch, Schema schema, LogicalType type) {
            return new DateTime((Object)millisFromEpoch, DateTimeZone.UTC);
        }

        @Override
        public Long toLong(DateTime timestamp, Schema schema, LogicalType type) {
            return timestamp.getMillis();
        }

        @Override
        public Schema getRecommendedSchema() {
            return LogicalTypes.timestampMillis().addToSchema(Schema.create(Schema.Type.LONG));
        }
    }
}

