/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.auth;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.pulsar.client.api.AuthenticationDataProvider;

public class AuthenticationDataToken
implements AuthenticationDataProvider {
    public static final String HTTP_HEADER_NAME = "Authorization";
    private final Supplier<String> tokenSupplier;

    public AuthenticationDataToken(Supplier<String> tokenSupplier) {
        this.tokenSupplier = tokenSupplier;
    }

    @Override
    public boolean hasDataForHttp() {
        return true;
    }

    @Override
    public Set<Map.Entry<String, String>> getHttpHeaders() {
        return Collections.singletonMap(HTTP_HEADER_NAME, "Bearer " + this.getToken()).entrySet();
    }

    @Override
    public boolean hasDataFromCommand() {
        return true;
    }

    @Override
    public String getCommandData() {
        return this.getToken();
    }

    private String getToken() {
        try {
            return this.tokenSupplier.get();
        }
        catch (Throwable t2) {
            throw new RuntimeException("failed to get client token", t2);
        }
    }
}

