/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.api.schema.SchemaReader;
import org.apache.pulsar.client.api.schema.SchemaWriter;

public class SchemaDefinitionImpl<T>
implements SchemaDefinition<T> {
    private Class<T> pojo;
    private final boolean alwaysAllowNull;
    private final Map<String, String> properties;
    private final String jsonDef;
    private final ClassLoader classLoader;
    private final boolean supportSchemaVersioning;
    private final boolean jsr310ConversionEnabled;
    private final SchemaReader<T> reader;
    private final SchemaWriter<T> writer;

    public SchemaDefinitionImpl(Class<T> pojo, String jsonDef, ClassLoader classLoader, boolean alwaysAllowNull, Map<String, String> properties, boolean supportSchemaVersioning, boolean jsr310ConversionEnabled, SchemaReader<T> reader, SchemaWriter<T> writer) {
        this.alwaysAllowNull = alwaysAllowNull;
        this.properties = properties;
        this.jsonDef = jsonDef;
        this.pojo = pojo;
        this.classLoader = classLoader;
        this.supportSchemaVersioning = supportSchemaVersioning;
        this.jsr310ConversionEnabled = jsr310ConversionEnabled;
        this.reader = reader;
        this.writer = writer;
    }

    @Override
    public boolean getAlwaysAllowNull() {
        return this.alwaysAllowNull;
    }

    @Override
    public boolean isJsr310ConversionEnabled() {
        return this.jsr310ConversionEnabled;
    }

    @Override
    public String getJsonDef() {
        return this.jsonDef;
    }

    @Override
    public Class<T> getPojo() {
        return this.pojo;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public boolean getSupportSchemaVersioning() {
        return this.supportSchemaVersioning;
    }

    @Override
    public Optional<SchemaReader<T>> getSchemaReaderOpt() {
        return Optional.ofNullable(this.reader);
    }

    @Override
    public Optional<SchemaWriter<T>> getSchemaWriterOpt() {
        return Optional.ofNullable(this.writer);
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }
}

