/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.impl.schema.AbstractSchema;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;

public class BooleanSchema
extends AbstractSchema<Boolean> {
    private static final BooleanSchema INSTANCE;
    private static final SchemaInfo SCHEMA_INFO;

    public static BooleanSchema of() {
        return INSTANCE;
    }

    @Override
    public void validate(byte[] message) {
        if (message.length != 1) {
            throw new SchemaSerializationException("Size of data received by BooleanSchema is not 1");
        }
    }

    @Override
    public byte[] encode(Boolean message) {
        if (null == message) {
            return null;
        }
        return new byte[]{(byte)(message != false ? 1 : 0)};
    }

    @Override
    public Boolean decode(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        this.validate(bytes);
        return bytes[0] != 0;
    }

    @Override
    public Boolean decode(ByteBuf byteBuf) {
        if (null == byteBuf) {
            return null;
        }
        return byteBuf.getBoolean(0);
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }

    static {
        SCHEMA_INFO = SchemaInfoImpl.builder().name("Boolean").type(SchemaType.BOOLEAN).schema(new byte[0]).build();
        INSTANCE = new BooleanSchema();
    }
}

