/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.impl.result;

import java.util.Collections;
import java.util.List;
import org.apache.pulsar.shade.io.netty.util.Recycler;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.impl.result.ResultImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.op.OpType;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.result.KeyValue;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.result.RangeResult;

public class RangeResultImpl<K, V>
extends ResultImpl<K, V, RangeResultImpl<K, V>>
implements RangeResult<K, V> {
    private List<KeyValue<K, V>> kvs = Collections.emptyList();
    private long count = 0L;
    private boolean more = false;

    RangeResultImpl(Recycler.Handle<RangeResultImpl<K, V>> handle) {
        super(OpType.RANGE, handle);
    }

    public RangeResultImpl<K, V> kvs(List<KeyValue<K, V>> kvs) {
        this.kvs.forEach(KeyValue::close);
        this.kvs.clear();
        this.kvs = kvs;
        return this;
    }

    @Override
    public List<KeyValue<K, V>> getKvsAndClear() {
        List<KeyValue<K, V>> kvsToReturn = this.kvs;
        this.kvs = Collections.emptyList();
        return kvsToReturn;
    }

    @Override
    protected void reset() {
        this.count = 0L;
        this.more = false;
        this.kvs.forEach(KeyValue::close);
        this.kvs = Collections.emptyList();
        super.reset();
    }

    @Override
    RangeResultImpl<K, V> asResult() {
        return this;
    }

    @Override
    public List<KeyValue<K, V>> kvs() {
        return this.kvs;
    }

    @Override
    public long count() {
        return this.count;
    }

    @Override
    public boolean more() {
        return this.more;
    }

    public RangeResultImpl<K, V> count(long count) {
        this.count = count;
        return this;
    }

    public RangeResultImpl<K, V> more(boolean more) {
        this.more = more;
        return this;
    }

    @Override
    public String toString() {
        return "RangeResultImpl(kvs=" + this.kvs() + ", count=" + this.count() + ", more=" + this.more() + ")";
    }
}

