/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.yahoo.sketches.theta;

import com.yahoo.memory.Memory;
import java.util.Arrays;
import org.apache.pulsar.shade.com.yahoo.sketches.Family;
import org.apache.pulsar.shade.com.yahoo.sketches.HashOperations;
import org.apache.pulsar.shade.com.yahoo.sketches.Util;
import org.apache.pulsar.shade.com.yahoo.sketches.theta.AnotB;
import org.apache.pulsar.shade.com.yahoo.sketches.theta.CompactSketch;
import org.apache.pulsar.shade.com.yahoo.sketches.theta.SetOperation;
import org.apache.pulsar.shade.com.yahoo.sketches.theta.Sketch;
import org.apache.pulsar.shade.com.yahoo.sketches.theta.UpdateSketch;

final class HeapAnotB
extends SetOperation
implements AnotB {
    private final short seedHash_;
    private Sketch a_;
    private Sketch b_;
    private long thetaLong_;
    private boolean empty_;
    private long[] cache_;
    private int curCount_ = 0;
    private int lgArrLongsHT_;
    private long[] bHashTable_;

    HeapAnotB(long seed) {
        this.seedHash_ = HeapAnotB.computeSeedHash(seed);
    }

    @Override
    public void update(Sketch a, Sketch b) {
        this.a_ = a;
        this.b_ = b;
        this.thetaLong_ = Long.MAX_VALUE;
        this.empty_ = true;
        this.cache_ = null;
        this.curCount_ = 0;
        this.lgArrLongsHT_ = 5;
        this.bHashTable_ = null;
        this.compute();
    }

    @Override
    public CompactSketch getResult(boolean dstOrdered, Memory dstMem) {
        long[] compactCache;
        long[] lArray = compactCache = this.curCount_ <= 0 ? new long[]{} : Arrays.copyOfRange(this.cache_, 0, this.curCount_);
        if (dstOrdered && this.curCount_ > 1) {
            Arrays.sort(compactCache);
        }
        CompactSketch comp = CompactSketch.createCompactSketch(compactCache, this.empty_, this.seedHash_, this.curCount_, this.thetaLong_, dstOrdered, dstMem);
        this.reset();
        return comp;
    }

    @Override
    public CompactSketch getResult() {
        return this.getResult(true, null);
    }

    @Override
    public Family getFamily() {
        return Family.A_NOT_B;
    }

    void compute() {
        int swA;
        int n = this.a_ == null ? 0 : (this.a_.isEmpty() ? 1 : (this.a_ instanceof UpdateSketch ? 4 : (swA = this.a_.isOrdered() ? 3 : 2)));
        int swB = this.b_ == null ? 0 : (this.b_.isEmpty() ? 1 : (this.b_ instanceof UpdateSketch ? 4 : (this.b_.isOrdered() ? 3 : 2)));
        int sw = swA * 8 | swB;
        switch (sw) {
            case 0: {
                this.thetaLong_ = Long.MAX_VALUE;
                this.empty_ = true;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                Util.checkSeedHashes(this.seedHash_, this.b_.getSeedHash());
                this.thetaLong_ = this.b_.getThetaLong();
                this.empty_ = true;
                break;
            }
            case 8: {
                Util.checkSeedHashes(this.seedHash_, this.a_.getSeedHash());
                this.thetaLong_ = this.a_.getThetaLong();
                this.empty_ = true;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                Util.checkSeedHashes(this.seedHash_, this.a_.getSeedHash());
                Util.checkSeedHashes(this.seedHash_, this.b_.getSeedHash());
                this.thetaLong_ = Math.min(this.a_.getThetaLong(), this.b_.getThetaLong());
                this.empty_ = true;
                break;
            }
            case 16: 
            case 24: 
            case 32: {
                Util.checkSeedHashes(this.seedHash_, this.a_.getSeedHash());
                this.thetaLong_ = this.a_.getThetaLong();
                this.empty_ = this.a_.isEmpty();
                this.curCount_ = this.a_.getRetainedEntries(true);
                this.cache_ = CompactSketch.compactCache(this.a_.getCache(), this.curCount_, this.thetaLong_, false);
                break;
            }
            case 17: 
            case 25: 
            case 33: {
                Util.checkSeedHashes(this.seedHash_, this.a_.getSeedHash());
                Util.checkSeedHashes(this.seedHash_, this.b_.getSeedHash());
                this.thetaLong_ = Math.min(this.a_.getThetaLong(), this.b_.getThetaLong());
                this.empty_ = this.a_.isEmpty();
                this.curCount_ = this.a_.getRetainedEntries(true);
                this.cache_ = CompactSketch.compactCache(this.a_.getCache(), this.curCount_, this.thetaLong_, false);
                break;
            }
            case 18: 
            case 19: 
            case 34: 
            case 35: {
                Util.checkSeedHashes(this.seedHash_, this.a_.getSeedHash());
                Util.checkSeedHashes(this.seedHash_, this.b_.getSeedHash());
                this.thetaLong_ = Math.min(this.a_.getThetaLong(), this.b_.getThetaLong());
                this.empty_ = this.a_.isEmpty();
                this.convertBtoHT();
                this.scanAllAsearchB();
                break;
            }
            case 26: 
            case 27: {
                Util.checkSeedHashes(this.seedHash_, this.a_.getSeedHash());
                Util.checkSeedHashes(this.seedHash_, this.b_.getSeedHash());
                this.thetaLong_ = Math.min(this.a_.getThetaLong(), this.b_.getThetaLong());
                this.empty_ = this.a_.isEmpty();
                this.convertBtoHT();
                this.scanEarlyStopAsearchB();
                break;
            }
            case 20: 
            case 36: {
                Util.checkSeedHashes(this.seedHash_, this.a_.getSeedHash());
                Util.checkSeedHashes(this.seedHash_, this.b_.getSeedHash());
                this.thetaLong_ = Math.min(this.a_.getThetaLong(), this.b_.getThetaLong());
                this.empty_ = this.a_.isEmpty();
                this.lgArrLongsHT_ = ((UpdateSketch)this.b_).getLgArrLongs();
                this.bHashTable_ = this.b_.getCache();
                this.scanAllAsearchB();
                break;
            }
            case 28: {
                Util.checkSeedHashes(this.seedHash_, this.a_.getSeedHash());
                Util.checkSeedHashes(this.seedHash_, this.b_.getSeedHash());
                this.thetaLong_ = Math.min(this.a_.getThetaLong(), this.b_.getThetaLong());
                this.empty_ = this.a_.isEmpty();
                this.lgArrLongsHT_ = ((UpdateSketch)this.b_).getLgArrLongs();
                this.bHashTable_ = this.b_.getCache();
                this.scanEarlyStopAsearchB();
            }
        }
    }

    private void convertBtoHT() {
        int curCountB = this.b_.getRetainedEntries(true);
        this.lgArrLongsHT_ = HeapAnotB.computeMinLgArrLongsFromCount(curCountB);
        this.bHashTable_ = new long[1 << this.lgArrLongsHT_];
        HashOperations.hashArrayInsert(this.b_.getCache(), this.bHashTable_, this.lgArrLongsHT_, this.thetaLong_);
    }

    private void scanAllAsearchB() {
        long[] scanAArr = this.a_.getCache();
        int arrLongsIn = scanAArr.length;
        this.cache_ = new long[arrLongsIn];
        for (int i = 0; i < arrLongsIn; ++i) {
            int foundIdx;
            long hashIn = scanAArr[i];
            if (hashIn <= 0L || hashIn >= this.thetaLong_ || (foundIdx = HashOperations.hashSearch(this.bHashTable_, this.lgArrLongsHT_, hashIn)) > -1) continue;
            this.cache_[this.curCount_++] = hashIn;
        }
    }

    private void scanEarlyStopAsearchB() {
        long[] scanAArr = this.a_.getCache();
        int arrLongsIn = scanAArr.length;
        this.cache_ = new long[arrLongsIn];
        for (int i = 0; i < arrLongsIn; ++i) {
            long hashIn = scanAArr[i];
            if (hashIn <= 0L) continue;
            if (hashIn >= this.thetaLong_) break;
            int foundIdx = HashOperations.hashSearch(this.bHashTable_, this.lgArrLongsHT_, hashIn);
            if (foundIdx > -1) continue;
            this.cache_[this.curCount_++] = hashIn;
        }
    }

    private void reset() {
        this.a_ = null;
        this.b_ = null;
        this.thetaLong_ = Long.MAX_VALUE;
        this.empty_ = true;
        this.cache_ = null;
        this.curCount_ = 0;
        this.lgArrLongsHT_ = 5;
        this.bHashTable_ = null;
    }
}

