/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.carrotsearch.hppc;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.pulsar.shade.com.carrotsearch.hppc.AbstractDoubleCollection;
import org.apache.pulsar.shade.com.carrotsearch.hppc.AbstractIterator;
import org.apache.pulsar.shade.com.carrotsearch.hppc.AbstractLongCollection;
import org.apache.pulsar.shade.com.carrotsearch.hppc.BitMixer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.BufferAllocationException;
import org.apache.pulsar.shade.com.carrotsearch.hppc.DoubleBufferVisualizer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.DoubleContainer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.DoubleLongAssociativeContainer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.DoubleLongMap;
import org.apache.pulsar.shade.com.carrotsearch.hppc.DoubleLookupContainer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.HashContainers;
import org.apache.pulsar.shade.com.carrotsearch.hppc.HashOrderMixing;
import org.apache.pulsar.shade.com.carrotsearch.hppc.HashOrderMixingStrategy;
import org.apache.pulsar.shade.com.carrotsearch.hppc.LongCollection;
import org.apache.pulsar.shade.com.carrotsearch.hppc.Preallocable;
import org.apache.pulsar.shade.com.carrotsearch.hppc.cursors.DoubleCursor;
import org.apache.pulsar.shade.com.carrotsearch.hppc.cursors.DoubleLongCursor;
import org.apache.pulsar.shade.com.carrotsearch.hppc.cursors.LongCursor;
import org.apache.pulsar.shade.com.carrotsearch.hppc.predicates.DoubleLongPredicate;
import org.apache.pulsar.shade.com.carrotsearch.hppc.predicates.DoublePredicate;
import org.apache.pulsar.shade.com.carrotsearch.hppc.predicates.LongPredicate;
import org.apache.pulsar.shade.com.carrotsearch.hppc.procedures.DoubleLongProcedure;
import org.apache.pulsar.shade.com.carrotsearch.hppc.procedures.DoubleProcedure;
import org.apache.pulsar.shade.com.carrotsearch.hppc.procedures.LongProcedure;

public class DoubleLongHashMap
implements DoubleLongMap,
Preallocable,
Cloneable {
    public double[] keys;
    public long[] values;
    protected int keyMixer;
    protected int assigned;
    protected int mask;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected HashOrderMixingStrategy orderMixer;

    public DoubleLongHashMap() {
        this(4);
    }

    public DoubleLongHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public DoubleLongHashMap(int expectedElements, double loadFactor) {
        this(expectedElements, loadFactor, HashOrderMixing.defaultStrategy());
    }

    public DoubleLongHashMap(int expectedElements, double loadFactor, HashOrderMixingStrategy orderMixer) {
        this.orderMixer = orderMixer;
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.ensureCapacity(expectedElements);
    }

    public DoubleLongHashMap(DoubleLongAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public long put(double key, long value) {
        double existing;
        assert (this.assigned < this.mask + 1);
        int mask = this.mask;
        if (Double.doubleToLongBits(key) == 0L) {
            this.hasEmptyKey = true;
            long previousValue = this.values[mask + 1];
            this.values[mask + 1] = value;
            return previousValue;
        }
        double[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(existing) == Double.doubleToLongBits(key)) {
                long previousValue = this.values[slot];
                this.values[slot] = value;
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key, value);
        } else {
            keys[slot] = key;
            this.values[slot] = value;
        }
        ++this.assigned;
        return 0L;
    }

    @Override
    public int putAll(DoubleLongAssociativeContainer container) {
        int count = this.size();
        for (DoubleLongCursor c : container) {
            this.put(c.key, c.value);
        }
        return this.size() - count;
    }

    @Override
    public int putAll(Iterable<? extends DoubleLongCursor> iterable) {
        int count = this.size();
        for (DoubleLongCursor doubleLongCursor : iterable) {
            this.put(doubleLongCursor.key, doubleLongCursor.value);
        }
        return this.size() - count;
    }

    public boolean putIfAbsent(double key, long value) {
        int keyIndex = this.indexOf(key);
        if (!this.indexExists(keyIndex)) {
            this.indexInsert(keyIndex, key, value);
            return true;
        }
        return false;
    }

    @Override
    public long putOrAdd(double key, long putValue, long incrementValue) {
        assert (this.assigned < this.mask + 1);
        int keyIndex = this.indexOf(key);
        if (this.indexExists(keyIndex)) {
            putValue = this.values[keyIndex] + incrementValue;
            this.indexReplace(keyIndex, putValue);
        } else {
            this.indexInsert(keyIndex, key, putValue);
        }
        return putValue;
    }

    @Override
    public long addTo(double key, long incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    @Override
    public long remove(double key) {
        double existing;
        int mask = this.mask;
        if (Double.doubleToLongBits(key) == 0L) {
            this.hasEmptyKey = false;
            long previousValue = this.values[mask + 1];
            this.values[mask + 1] = 0L;
            return previousValue;
        }
        double[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(existing) == Double.doubleToLongBits(key)) {
                long previousValue = this.values[slot];
                this.shiftConflictingKeys(slot);
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        return 0L;
    }

    @Override
    public int removeAll(DoubleContainer other) {
        int before = this.size();
        if (other.size() >= this.size() && other instanceof DoubleLookupContainer) {
            if (this.hasEmptyKey && other.contains(0.0)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = 0L;
            }
            double[] keys = this.keys;
            int slot = 0;
            int max = this.mask;
            while (slot <= max) {
                double existing = keys[slot];
                if (Double.doubleToLongBits(existing) != 0L && other.contains(existing)) {
                    this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
        } else {
            for (DoubleCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(DoubleLongPredicate predicate) {
        int before = this.size();
        int mask = this.mask;
        if (this.hasEmptyKey && predicate.apply(0.0, this.values[mask + 1])) {
            this.hasEmptyKey = false;
            this.values[mask + 1] = 0L;
        }
        double[] keys = this.keys;
        long[] values = this.values;
        int slot = 0;
        while (slot <= mask) {
            double existing = keys[slot];
            if (Double.doubleToLongBits(existing) != 0L && predicate.apply(existing, values[slot])) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(DoublePredicate predicate) {
        int before = this.size();
        if (this.hasEmptyKey && predicate.apply(0.0)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = 0L;
        }
        double[] keys = this.keys;
        int slot = 0;
        int max = this.mask;
        while (slot <= max) {
            double existing = keys[slot];
            if (Double.doubleToLongBits(existing) != 0L && predicate.apply(existing)) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public long get(double key) {
        double existing;
        if (Double.doubleToLongBits(key) == 0L) {
            return this.hasEmptyKey ? this.values[this.mask + 1] : 0L;
        }
        double[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(existing) == Double.doubleToLongBits(key)) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return 0L;
    }

    @Override
    public long getOrDefault(double key, long defaultValue) {
        double existing;
        if (Double.doubleToLongBits(key) == 0L) {
            return this.hasEmptyKey ? this.values[this.mask + 1] : defaultValue;
        }
        double[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(existing) == Double.doubleToLongBits(key)) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return defaultValue;
    }

    @Override
    public boolean containsKey(double key) {
        double existing;
        if (Double.doubleToLongBits(key) == 0L) {
            return this.hasEmptyKey;
        }
        double[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(existing) == Double.doubleToLongBits(key)) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public int indexOf(double key) {
        double existing;
        int mask = this.mask;
        if (Double.doubleToLongBits(key) == 0L) {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        double[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(existing) == Double.doubleToLongBits(key)) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    @Override
    public boolean indexExists(int index) {
        assert (index < 0 || index >= 0 && index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return index >= 0;
    }

    @Override
    public long indexGet(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return this.values[index];
    }

    @Override
    public long indexReplace(int index, long newValue) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        long previousValue = this.values[index];
        this.values[index] = newValue;
        return previousValue;
    }

    @Override
    public void indexInsert(int index, double key, long value) {
        assert (index < 0) : "The index must not point at an existing key.";
        index ^= 0xFFFFFFFF;
        if (Double.doubleToLongBits(key) == 0L) {
            assert (index == this.mask + 1);
            this.values[index] = value;
            this.hasEmptyKey = true;
        } else {
            assert (Double.doubleToLongBits(this.keys[index]) == 0L);
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index, key, value);
            } else {
                this.keys[index] = key;
                this.values[index] = value;
            }
            ++this.assigned;
        }
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0.0);
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        for (DoubleLongCursor c : this) {
            h += BitMixer.mix(c.key) + BitMixer.mix(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.equalElements((DoubleLongHashMap)this.getClass().cast(obj));
    }

    protected boolean equalElements(DoubleLongHashMap other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (DoubleLongCursor c : other) {
            double key = c.key;
            if (this.containsKey(key) && this.get(key) == c.value) continue;
            return false;
        }
        return true;
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            double[] prevKeys = this.keys;
            long[] prevValues = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    @Override
    public Iterator<DoubleLongCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends DoubleLongProcedure> T forEach(T procedure) {
        double[] keys = this.keys;
        long[] values = this.values;
        if (this.hasEmptyKey) {
            procedure.apply(0.0, values[this.mask + 1]);
        }
        int max = this.mask;
        for (int slot = 0; slot <= max; ++slot) {
            if (Double.doubleToLongBits(keys[slot]) == 0L) continue;
            procedure.apply(keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends DoubleLongPredicate> T forEach(T predicate) {
        double[] keys = this.keys;
        long[] values = this.values;
        if (this.hasEmptyKey && !predicate.apply(0.0, values[this.mask + 1])) {
            return predicate;
        }
        int max = this.mask;
        for (int slot = 0; slot <= max && (Double.doubleToLongBits(keys[slot]) == 0L || predicate.apply(keys[slot], values[slot])); ++slot) {
        }
        return predicate;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public LongCollection values() {
        return new ValuesContainer();
    }

    public DoubleLongHashMap clone() {
        try {
            DoubleLongHashMap cloned = (DoubleLongHashMap)super.clone();
            cloned.keys = (double[])this.keys.clone();
            cloned.values = (long[])this.values.clone();
            cloned.hasEmptyKey = cloned.hasEmptyKey;
            cloned.orderMixer = this.orderMixer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (DoubleLongCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return DoubleBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, characters);
    }

    public static DoubleLongHashMap from(double[] keys, long[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        DoubleLongHashMap map = new DoubleLongHashMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    protected int hashKey(double key) {
        assert (Double.doubleToLongBits(key) != 0L);
        return BitMixer.mix(key, this.keyMixer);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(double[] fromKeys, long[] fromValues) {
        assert (fromKeys.length == fromValues.length && HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        double[] keys = this.keys;
        long[] values = this.values;
        int mask = this.mask;
        int from = fromKeys.length - 1;
        keys[keys.length - 1] = fromKeys[from];
        values[values.length - 1] = fromValues[from];
        while (--from >= 0) {
            double existing = fromKeys[from];
            if (Double.doubleToLongBits(existing) == 0L) continue;
            int slot = this.hashKey(existing) & mask;
            while (Double.doubleToLongBits(keys[slot]) != 0L) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
            values[slot] = fromValues[from];
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        int newKeyMixer = this.orderMixer.newKeyMixer(arraySize);
        double[] prevKeys = this.keys;
        long[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new double[arraySize + emptyElementSlot];
            this.values = new long[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            this.values = prevValues;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.mask + 1, arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.keyMixer = newKeyMixer;
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, double pendingKey, long pendingValue) {
        assert (this.assigned == this.resizeAt && Double.doubleToLongBits(this.keys[slot]) == 0L && Double.doubleToLongBits(pendingKey) != 0L);
        double[] prevKeys = this.keys;
        long[] prevValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        double existing;
        double[] keys = this.keys;
        long[] values = this.values;
        int mask = this.mask;
        int distance = 0;
        while (Double.doubleToLongBits(existing = keys[slot = gapSlot + ++distance & mask]) != 0L) {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = values[slot];
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0.0;
        values[gapSlot] = 0L;
        --this.assigned;
    }

    private final class ValuesIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = DoubleLongHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new LongCursor();
        }

        @Override
        protected LongCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    if (Double.doubleToLongBits(DoubleLongHashMap.this.keys[this.slot]) != 0L) {
                        this.cursor.index = this.slot;
                        this.cursor.value = DoubleLongHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && DoubleLongHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = DoubleLongHashMap.this.values[this.max];
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractLongCollection {
        private final DoubleLongHashMap owner;

        private ValuesContainer() {
            this.owner = DoubleLongHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(long value) {
            for (DoubleLongCursor c : this.owner) {
                if (c.value != value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends LongProcedure> T forEach(T procedure) {
            for (DoubleLongCursor c : this.owner) {
                procedure.apply(c.value);
            }
            return procedure;
        }

        @Override
        public <T extends LongPredicate> T forEach(T predicate) {
            for (DoubleLongCursor c : this.owner) {
                if (predicate.apply(c.value)) continue;
                break;
            }
            return predicate;
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(final long e) {
            return this.owner.removeAll(new DoubleLongPredicate(){

                @Override
                public boolean apply(double key, long value) {
                    return value == e;
                }
            });
        }

        @Override
        public int removeAll(final LongPredicate predicate) {
            return this.owner.removeAll(new DoubleLongPredicate(){

                @Override
                public boolean apply(double key, long value) {
                    return predicate.apply(value);
                }
            });
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<DoubleCursor> {
        private final DoubleCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = DoubleLongHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new DoubleCursor();
        }

        @Override
        protected DoubleCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    double existing = DoubleLongHashMap.this.keys[this.slot];
                    if (Double.doubleToLongBits(existing) != 0L) {
                        this.cursor.index = this.slot;
                        this.cursor.value = existing;
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && DoubleLongHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = 0.0;
                return this.cursor;
            }
            return (DoubleCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractDoubleCollection
    implements DoubleLookupContainer {
        private final DoubleLongHashMap owner;

        public KeysContainer() {
            this.owner = DoubleLongHashMap.this;
        }

        @Override
        public boolean contains(double e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends DoubleProcedure> T forEach(final T procedure) {
            this.owner.forEach(new DoubleLongProcedure(){

                @Override
                public void apply(double key, long value) {
                    procedure.apply(key);
                }
            });
            return procedure;
        }

        @Override
        public <T extends DoublePredicate> T forEach(final T predicate) {
            this.owner.forEach(new DoubleLongPredicate(){

                @Override
                public boolean apply(double key, long value) {
                    return predicate.apply(key);
                }
            });
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<DoubleCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(DoublePredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(double e) {
            boolean hasKey = this.owner.containsKey(e);
            if (hasKey) {
                this.owner.remove(e);
                return 1;
            }
            return 0;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<DoubleLongCursor> {
        private final DoubleLongCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = DoubleLongHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new DoubleLongCursor();
        }

        @Override
        protected DoubleLongCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    double existing = DoubleLongHashMap.this.keys[this.slot];
                    if (Double.doubleToLongBits(existing) != 0L) {
                        this.cursor.index = this.slot;
                        this.cursor.key = existing;
                        this.cursor.value = DoubleLongHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && DoubleLongHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = 0.0;
                this.cursor.value = DoubleLongHashMap.this.values[this.max];
                return this.cursor;
            }
            return (DoubleLongCursor)this.done();
        }
    }
}

