/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.windowing.triggers;

import org.apache.pulsar.functions.windowing.DefaultEvictionContext;
import org.apache.pulsar.functions.windowing.Event;
import org.apache.pulsar.functions.windowing.EvictionPolicy;
import org.apache.pulsar.functions.windowing.TriggerHandler;
import org.apache.pulsar.functions.windowing.TriggerPolicy;
import org.apache.pulsar.functions.windowing.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatermarkTimeTriggerPolicy<T>
implements TriggerPolicy<T, Long> {
    private static final Logger log = LoggerFactory.getLogger(WatermarkTimeTriggerPolicy.class);
    private final long slidingIntervalMs;
    private final TriggerHandler handler;
    private final EvictionPolicy<T, ?> evictionPolicy;
    private final WindowManager<T> windowManager;
    private volatile long nextWindowEndTs;
    private boolean started;

    public WatermarkTimeTriggerPolicy(long slidingIntervalMs, TriggerHandler handler, EvictionPolicy<T, ?> evictionPolicy, WindowManager<T> windowManager) {
        this.slidingIntervalMs = slidingIntervalMs;
        this.handler = handler;
        this.evictionPolicy = evictionPolicy;
        this.windowManager = windowManager;
        this.started = false;
    }

    @Override
    public void track(Event<T> event) {
        if (this.started && event.isWatermark()) {
            this.handleWaterMarkEvent(event);
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public void start() {
        this.started = true;
    }

    @Override
    public void shutdown() {
    }

    private void handleWaterMarkEvent(Event<T> event) {
        long watermarkTs = event.getTimestamp();
        long windowEndTs = this.nextWindowEndTs;
        log.debug(String.format("Window end ts %d Watermark ts %d", windowEndTs, watermarkTs));
        while (windowEndTs <= watermarkTs) {
            long currentCount = this.windowManager.getEventCount(windowEndTs);
            this.evictionPolicy.setContext(new DefaultEvictionContext(windowEndTs, currentCount));
            if (this.handler.onTrigger()) {
                windowEndTs += this.slidingIntervalMs;
                continue;
            }
            long ts = this.getNextAlignedWindowTs(windowEndTs, watermarkTs);
            log.debug(String.format("Next aligned window end ts %d", ts));
            if (ts == Long.MAX_VALUE) {
                log.debug(String.format("No events to process between %d and watermark ts %d", windowEndTs, watermarkTs));
                break;
            }
            windowEndTs = ts;
        }
        this.nextWindowEndTs = windowEndTs;
    }

    private long getNextAlignedWindowTs(long startTs, long endTs) {
        long nextTs = this.windowManager.getEarliestEventTs(startTs, endTs);
        if (nextTs == Long.MAX_VALUE || nextTs % this.slidingIntervalMs == 0L) {
            return nextTs;
        }
        return nextTs + (this.slidingIntervalMs - nextTs % this.slidingIntervalMs);
    }

    @Override
    public Long getState() {
        return this.nextWindowEndTs;
    }

    @Override
    public void restoreState(Long state) {
        this.nextWindowEndTs = state;
    }

    public String toString() {
        return "WatermarkTimeTriggerPolicy{slidingIntervalMs=" + this.slidingIntervalMs + ", nextWindowEndTs=" + this.nextWindowEndTs + ", started=" + this.started + '}';
    }
}

