/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.pulsar.client.impl.schema.AbstractSchema;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.util.concurrent.FastThreadLocal;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.SchemaType;

public class StringSchema
extends AbstractSchema<String> {
    static final String CHARSET_KEY = "__charset";
    private static final SchemaInfo DEFAULT_SCHEMA_INFO;
    private static final Charset DEFAULT_CHARSET;
    private static final StringSchema UTF8;
    private static final FastThreadLocal<byte[]> tmpBuffer;
    private final Charset charset;
    private final SchemaInfo schemaInfo;

    public static StringSchema fromSchemaInfo(SchemaInfo schemaInfo) {
        Preconditions.checkArgument(SchemaType.STRING == schemaInfo.getType(), "Not a string schema");
        String charsetName = schemaInfo.getProperties().get(CHARSET_KEY);
        if (null == charsetName) {
            return UTF8;
        }
        return new StringSchema(Charset.forName(charsetName));
    }

    public static StringSchema utf8() {
        return UTF8;
    }

    public StringSchema() {
        this.charset = DEFAULT_CHARSET;
        this.schemaInfo = DEFAULT_SCHEMA_INFO;
    }

    public StringSchema(Charset charset) {
        this.charset = charset;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(CHARSET_KEY, charset.name());
        this.schemaInfo = new SchemaInfoImpl().setName(DEFAULT_SCHEMA_INFO.getName()).setType(SchemaType.STRING).setSchema(DEFAULT_SCHEMA_INFO.getSchema()).setProperties(properties);
    }

    @Override
    public byte[] encode(String message) {
        if (null == message) {
            return null;
        }
        return message.getBytes(this.charset);
    }

    @Override
    public String decode(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        return new String(bytes, this.charset);
    }

    @Override
    public String decode(ByteBuf byteBuf) {
        byte[] bytes;
        if (null == byteBuf) {
            return null;
        }
        int size = byteBuf.readableBytes();
        if (size > (bytes = tmpBuffer.get()).length) {
            bytes = new byte[size * 2];
            tmpBuffer.set(bytes);
        }
        byteBuf.getBytes(byteBuf.readerIndex(), bytes, 0, size);
        return new String(bytes, 0, size, this.charset);
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    static {
        DEFAULT_CHARSET = StandardCharsets.UTF_8;
        DEFAULT_SCHEMA_INFO = new SchemaInfoImpl().setName("String").setType(SchemaType.STRING).setSchema(new byte[0]);
        UTF8 = new StringSchema(StandardCharsets.UTF_8);
        tmpBuffer = new FastThreadLocal<byte[]>(){

            @Override
            protected byte[] initialValue() {
                return new byte[1024];
            }
        };
    }
}

