/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.prometheus.metrics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.pulsar.shade.io.prometheus.client.Collector;
import org.apache.pulsar.shade.io.prometheus.client.GaugeMetricFamily;
import org.apache.pulsar.shade.io.prometheus.client.SimpleCollector;

public class ObserverGauge
extends SimpleCollector<Child>
implements Collector.Describable {
    private final Supplier<Number> supplier;

    public static Builder build(String name, String help) {
        return (Builder)((Builder)ObserverGauge.build().name(name)).help(help);
    }

    public static Builder build() {
        return new Builder();
    }

    private ObserverGauge(Builder builder) {
        super(builder);
        this.supplier = builder.supplier;
        this.clear();
    }

    @Override
    protected Child newChild() {
        return new Child(this.supplier);
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples.Sample> samples = new ArrayList<Collector.MetricFamilySamples.Sample>();
        for (Map.Entry c : this.children.entrySet()) {
            Child child = (Child)c.getValue();
            samples.add(new Collector.MetricFamilySamples.Sample(this.fullname, this.labelNames, (List)c.getKey(), ((Number)child.supplier.get()).doubleValue()));
        }
        return this.familySamplesList(Collector.Type.GAUGE, samples);
    }

    @Override
    public List<Collector.MetricFamilySamples> describe() {
        return Collections.singletonList(new GaugeMetricFamily(this.fullname, this.help, this.labelNames));
    }

    static class Child {
        private final Supplier<Number> supplier;

        public Child(Supplier<Number> supplier) {
            this.supplier = supplier;
        }
    }

    public static class Builder
    extends SimpleCollector.Builder<Builder, ObserverGauge> {
        private Supplier<Number> supplier;

        public Builder supplier(Supplier<Number> supplier) {
            this.supplier = supplier;
            return this;
        }

        @Override
        public ObserverGauge register() {
            try {
                return (ObserverGauge)super.register();
            }
            catch (Exception e) {
                return this.create();
            }
        }

        @Override
        public ObserverGauge create() {
            return new ObserverGauge(this);
        }
    }
}

