/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.shade.com.google.common.collect.Maps;
import org.apache.pulsar.shade.org.apache.pulsar.common.stats.Metrics;

public class MBeanStatsGenerator {
    private MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();

    public static Collection<Metrics> generate(PulsarService pulsar) {
        return new MBeanStatsGenerator(pulsar).generate();
    }

    MBeanStatsGenerator(PulsarService pulsar) {
    }

    private Collection<Metrics> generate() {
        ArrayList<Metrics> metricsCollection = new ArrayList<Metrics>();
        Set<ObjectInstance> instances = this.mbs.queryMBeans(null, null);
        for (ObjectInstance instance : instances) {
            Metrics metrics;
            String beanName = instance.getObjectName().toString();
            if (beanName.startsWith("java.lang:type=GarbageCollector") || (metrics = this.convert(instance)) == null) continue;
            metricsCollection.add(metrics);
        }
        return metricsCollection;
    }

    private Metrics convert(ObjectInstance instance) {
        ObjectName objName = instance.getObjectName();
        MBeanInfo info = null;
        try {
            info = this.mbs.getMBeanInfo(objName);
        }
        catch (Exception e) {
            return null;
        }
        Metrics metrics = null;
        metrics = this.createMetricsByDimension(objName);
        for (MBeanAttributeInfo attr : info.getAttributes()) {
            try {
                Object value = this.mbs.getAttribute(instance.getObjectName(), attr.getName());
                metrics.put(attr.getName(), value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return metrics;
    }

    private Metrics createMetricsByDimension(ObjectName objectName) {
        HashMap<String, String> dimensionMap = Maps.newHashMap();
        dimensionMap.put("MBean", objectName.toString());
        return Metrics.create(dimensionMap);
    }
}

